


VACALL(3)                                               VACALL(3)


NNAAMMEE
       vacall - C functions called with variable arguments

SSYYNNOOPPSSIISS
       ##iinncclluuddee <<vvaaccaallll..hh>>

       eexxtteerrnn vvooiidd** vvaaccaallll__ffuunnccttiioonn;;

       vvooiidd _f_u_n_c_t_i_o_n ((_a_l_i_s_t))
         vvaa__aalliisstt _a_l_i_s_t;;
       {{
         vvaa__ssttaarrtt___t_y_p_e((_a_l_i_s_t[[,, _r_e_t_u_r_n___t_y_p_e]]));;
         _a_r_g == vvaa__aarrgg___t_y_p_e((_a_l_i_s_t[[,, _a_r_g___t_y_p_e]]));;
         vvaa__rreettuurrnn___t_y_p_e((_a_l_i_s_t[[[[,, _r_e_t_u_r_n___t_y_p_e]],, _r_e_t_u_r_n___v_a_l_u_e]]));;
       }}

       vvaaccaallll__ffuunnccttiioonn == _&_f_u_n_c_t_i_o_n;;

       _v_a_l == ((((_r_e_t_u_r_n___t_y_p_e ((**)) (()))) vvaaccaallll)) ((_a_r_g_1,,_a_r_g_2,,_._._.));;

DDEESSCCRRIIPPTTIIOONN
       This  set  of  macros  permit  a C function _f_u_n_c_t_i_o_n to be
       called with variable  arguments  and  to  return  variable
       return values.  This is much like the vvaarraarrggss(3) facility,
       but also allows the return value to be  specified  at  run
       time.

       Function  calling  conventions differ considerably on dif-
       ferent machines,  and  _v_a_c_a_l_l  attempts  to  provide  some
       degree of isolation from such architecture dependencies.

       The  function  that can be called with any number and type
       of arguments and which will  return  any  type  of  return
       value is vvaaccaallll.  It will do some magic and call the func-
       tion stored in the variable vvaaccaallll__ffuunnccttiioonn.  If you  want
       to make more than one use of _v_a_c_a_l_l, use the _t_r_a_m_p_o_l_i_n_e(3)
       facility to  store  _&_f_u_n_c_t_i_o_n  into  vvaaccaallll__ffuunnccttiioonn  just
       before calling vvaaccaallll.

       Within  _f_u_n_c_t_i_o_n, the following macros can be used to walk
       through the argument list and specify a return value:

       vvaa__ssttaarrtt___t_y_p_e((_a_l_i_s_t[[,, _r_e_t_u_r_n___t_y_p_e]]));;
              starts the walk through the argument list and spec-
              ifies the return type.

       _a_r_g == vvaa__aarrgg___t_y_p_e((_a_l_i_s_t[[,, _a_r_g___t_y_p_e]]));;
              fetches the next argument from the argument list.

       vvaa__rreettuurrnn___t_y_p_e((_a_l_i_s_t[[[[,, _r_e_t_u_r_n___t_y_p_e]],, _r_e_t_u_r_n___v_a_l_u_e]]));;
              ends  the walk through the argument list and speci-
              fies the return value.

       The _t_y_p_e in vvaa__ssttaarrtt___t_y_p_e and vvaa__rreettuurrnn___t_y_p_e shall be  one



                         14 January 2001                        1





VACALL(3)                                               VACALL(3)


       of vvooiidd, iinntt, uuiinntt, lloonngg, uulloonngg, lloonngglloonngg, uulloonngglloonngg, ddoouu--
       bbllee, ssttrruucctt, ppttrr or (for ANSI C calling conventions  only)
       cchhaarr, sscchhaarr, uucchhaarr, sshhoorrtt, uusshhoorrtt, ffllooaatt, depending on the
       class of _r_e_t_u_r_n___t_y_p_e.

       The _t_y_p_e specifiers in  vvaa__ssttaarrtt___t_y_p_e  and  vvaa__rreettuurrnn___t_y_p_e
       must  be  the  same.  The _r_e_t_u_r_n___t_y_p_e specifiers passed to
       vvaa__ssttaarrtt___t_y_p_e and vvaa__rreettuurrnn___t_y_p_e must be the same.

       The _t_y_p_e in vvaa__aarrgg___t_y_p_e shall be one of iinntt,  uuiinntt,  lloonngg,
       uulloonngg,  lloonngglloonngg,  uulloonngglloonngg,  ddoouubbllee, ssttrruucctt, ppttrr or (for
       ANSI C  calling  conventions  only)  cchhaarr,  sscchhaarr,  uucchhaarr,
       sshhoorrtt,  uusshhoorrtt, ffllooaatt, depending on the class of _a_r_g___t_y_p_e.

       In vvaa__ssttaarrtt__ssttrruucctt((_a_l_i_s_t,,  _r_e_t_u_r_n___t_y_p_e,,  _s_p_l_i_t_t_a_b_l_e));;  the
       _s_p_l_i_t_t_a_b_l_e  flag  specifies whether the struct _r_e_t_u_r_n___t_y_p_e
       can be returned in registers such that every struct  field
       fits entirely in a single register. This needs to be spec-
       ified for structs of size 2*sizeof(long). For  structs  of
       size <= sizeof(long), _s_p_l_i_t_t_a_b_l_e is ignored and assumed to
       be 1. For structs of size > 2*sizeof(long), _s_p_l_i_t_t_a_b_l_e  is
       ignored  and  assumed to be 0. There are some handy macros
       for this:
       vvaa__wwoorrdd__sspplliittttaabbllee__11 ((_t_y_p_e_1))
       vvaa__wwoorrdd__sspplliittttaabbllee__22 ((_t_y_p_e_1,, _t_y_p_e_2))
       vvaa__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3))
       vvaa__wwoorrdd__sspplliittttaabbllee__44 ((_t_y_p_e_1,, _t_y_p_e_2,, _t_y_p_e_3,, _t_y_p_e_4))
       For a struct with three slots
       ssttrruucctt {{ _t_y_p_e_1 _i_d_1;; _t_y_p_e_2 _i_d_2;; _t_y_p_e_3 _i_d_3;; }}
       you can specify _s_p_l_i_t_t_a_b_l_e as vvaa__wwoorrdd__sspplliittttaabbllee__33 ((_t_y_p_e_1,,
       _t_y_p_e_2,, _t_y_p_e_3)) .


NNOOTTEESS
       Functions  which want to emulate Kernighan & Ritchie style
       functions (i.e., in ANSI  C,  functions  without  a  typed
       argument  list)  cannot  use  the _t_y_p_e values cchhaarr, sscchhaarr,
       uucchhaarr, sshhoorrtt, uusshhoorrtt, ffllooaatt.  As prescribed by the default
       K&R  C expression promotions, they have to use iinntt instead
       of cchhaarr, sscchhaarr, uucchhaarr, sshhoorrtt, uusshhoorrtt and ddoouubbllee instead of
       ffllooaatt.

       The   macros   vvaa__ssttaarrtt__lloonngglloonngg(()),  vvaa__ssttaarrtt__uulloonngglloonngg(()),
       vvaa__rreettuurrnn__lloonngglloonngg(()),               vvaa__rreettuurrnn__uulloonngglloonngg(()),
       vvaa__aarrgg__lloonngglloonngg(())  and vvaa__aarrgg__uulloonngglloonngg(()) work only if the
       C compiler has a working lloonngg lloonngg 64-bit integer type.

       The struct types used in vvaa__ssttaarrtt__ssttrruucctt(()) and vvaa__ssttrruucctt(())
       must  only  contain  (signed  or unsigned) int, long, long
       long or pointer fields.  Struct types  containing  (signed
       or  unsigned)  char, short, float, double or other structs
       are not supported.





                         14 January 2001                        2





VACALL(3)                                               VACALL(3)


EEXXAAMMPPLLEE
       This example, a possible implementation of eexxeeccll(3) on top
       of eexxeeccvv(2) using vvaarraarrggss(3),

       ##iinncclluuddee <<vvaarraarrggss..hh>>
       ##ddeeffiinnee MMAAXXAARRGGSS 110000
       //** eexxeeccll iiss ccaalllleedd bbyy eexxeeccll((ffiillee,, aarrgg11,, aarrgg22,, ......,, ((cchhaarr **))00));; **//
       iinntt eexxeeccll ((vvaa__aalliisstt))
         vvaa__ddccll
       {{
         vvaa__lliisstt aapp;;
         cchhaarr** ffiillee;;
         cchhaarr** aarrggss[[MMAAXXAARRGGSS]];;
         iinntt aarrggnnoo == 00;;
         vvaa__ssttaarrtt ((aapp));;
         ffiillee == vvaa__aarrgg((aapp,, cchhaarr**));;
         wwhhiillee ((((aarrggss[[aarrggnnoo]] == vvaa__aarrgg((aapp,, cchhaarr**)))) !!== ((cchhaarr **))00))
           aarrggnnoo++++;;
         vvaa__eenndd ((aapp));;
         rreettuurrnn eexxeeccvv((ffiillee,, aarrggss));;
       }}

       looks like this using vvaaccaallll(3):

       ##iinncclluuddee <<vvaaccaallll..hh>>
       ##ddeeffiinnee MMAAXXAARRGGSS 110000
       //** eexxeeccll iiss ccaalllleedd bbyy vvaaccaallll((ffiillee,, aarrgg11,, aarrgg22,, ......,, ((cchhaarr **))00));; **//
       vvooiidd eexxeeccll ((aapp))
         vvaa__aalliisstt aapp;;
       {{
         cchhaarr** ffiillee;;
         cchhaarr** aarrggss[[MMAAXXAARRGGSS]];;
         iinntt aarrggnnoo == 00;;
         iinntt rreettvvaall;;
         vvaa__ssttaarrtt__iinntt ((aapp));;
         ffiillee == vvaa__aarrgg__ppttrr((aapp,, cchhaarr**));;
         wwhhiillee ((((aarrggss[[aarrggnnoo]] == vvaa__aarrgg__ppttrr((aapp,, cchhaarr**)))) !!== ((cchhaarr **))00))
           aarrggnnoo++++;;
         rreettvvaall == eexxeeccvv((ffiillee,, aarrggss));;
         vvaa__rreettuurrnn__iinntt ((aapp,, rreettvvaall));;
       }}
       vvaaccaallll__ffuunnccttiioonn == &&eexxeeccll;;


SSEEEE AALLSSOO
       vvaarraarrggss(3), ttrraammppoolliinnee(3), ccaallllbbaacckk(3).


BBUUGGSS
       The  current  implementations have been tested on a selec-
       tion of common cases but there  are  probably  still  many
       bugs.

       There  are  typically  built-in  limits on the size of the



                         14 January 2001                        3





VACALL(3)                                               VACALL(3)


       argument-list, which may also  include  the  size  of  any
       structure arguments.

       The  decision whether a struct is to be returned in regis-
       ters or in memory considers only  the  struct's  size  and
       alignment.  This  is inaccurate: for example, gcc on m68k-
       next returns ssttrruucctt {{  cchhaarr  aa,,bb,,cc;;  }}  in  registers  and
       ssttrruucctt  {{ cchhaarr aa[[33]];; }} in memory, although both types have
       the same size and the same alignment.

       <<vvaaccaallll..hh>>  cannot  be  included   when   <<vvaarraarrggss..hh>>   or
       <<ssttddaarrgg..hh>> is included.  (Name clash for vvaa__aalliisstt.)

       The argument list can only be walked once.

       The  use  of  the  global  variable vvaaccaallll__ffuunnccttiioonn is not
       reentrant. This is fixed in the ccaallllbbaacckk(3) package.


PPOORRTTIINNGG
       Knowledge about argument passing conventions can be  found
       in  the  gcc source, file gcc-2.6.3/config/_c_p_u/_c_p_u.h, sec-
       tion "Stack layout; function entry, exit and calling."

       The implementation of varargs for gcc can be found in  the
       gcc source, files gcc-2.6.3/ginclude/va*.h.

       gcc's  __builtin_saveregs() function is defined in the gcc
       source, file gcc-2.6.3/libgcc2.c.


AAUUTTHHOORR
       Bruno Haible <bruno@clisp.org>


AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       Many ideas and a lot of code were  cribbed  from  the  gcc
       source.



















                         14 January 2001                        4


