#!/usr/bin/env tclsh

# Usage: make-c-ext.tcl source.tcl >jim-source.c

# Converts a Tcl source file into C source suitable
# for loading as a static extension.

lassign $argv source

if {![string match *.tcl $source]} {
	error "Source $source is not a .tcl file"
}

# Read the Tcl source and convert to C
# Note that no lines are removed in order to preserve line numbering
set sourcelines {}
set f [open $source]
while {[gets $f buf] >= 0} {
	# Remove comment lines
	regsub {^[ \t]*#.*$} $buf "" buf
	# Escape quotes and backlashes
	set buf [string map [list \\ \\\\ \" \\"] $buf]
	lappend sourcelines \"$buf\\n\"
}
close $f

lappend lines {/* autogenerated - do not edit */}
lappend lines {#include <jim.h>}
set basename [file tail $source]
set pkgname [file rootname $basename]

lappend lines "int Jim_${pkgname}Init(Jim_Interp *interp)"
lappend lines "\{"
lappend lines "\tif (Jim_PackageProvide(interp, \"$pkgname\", \"1.0\", JIM_ERRMSG)) return JIM_ERR;"
lappend lines "\treturn Jim_EvalSource(interp, \"$basename\", 1, [join $sourcelines \n]);"
lappend lines "\}"

puts [join $lines \n]
