// -*- mode: C++ -*-

// Not copyrightable: random test data.
// synth_minidump_unittest_data.h: verbose test data for SynthMinidump tests.

#ifndef PROCESSOR_SYNTH_MINIDUMP_UNITTEST_DATA_H_
#define PROCESSOR_SYNTH_MINIDUMP_UNITTEST_DATA_H_

#include "google_breakpad/common/minidump_format.h"

static const MDRawContextX86 x86_raw_context = {
  0xded5d71b,                           // context_flags
  0x9fdb432e,                           // dr0
  0x26b7a81a,                           // dr1
  0xcac7e348,                           // dr2
  0xcf99ec09,                           // dr3
  0x7dc8c2cd,                           // dr6
  0x21deb880,                           // dr7

  // float_save
  {
    0x8a5d2bb0,                         // control_word
    0x0286c4c9,                         // status_word
    0xf1feea21,                         // tag_word
    0xb2d40576,                         // error_offset
    0x48146cde,                         // error_selector
    0x983f9b21,                         // data_offset
    0x475be12c,                         // data_selector

    // register_area
    {
      0xd9, 0x04, 0x20, 0x6b, 0x88, 0x3a, 0x3f, 0xd5,
      0x59, 0x7a, 0xa9, 0xeb, 0xd0, 0x5c, 0xdf, 0xfe,
      0xad, 0xdd, 0x4a, 0x8b, 0x10, 0xcc, 0x9a, 0x33,
      0xcb, 0xb6, 0xf7, 0x86, 0xcd, 0x69, 0x25, 0xae,
      0x25, 0xe5, 0x7a, 0xa1, 0x8f, 0xb2, 0x84, 0xd9,
      0xf7, 0x2d, 0x8a, 0xa1, 0x80, 0x81, 0x7f, 0x67,
      0x07, 0xa8, 0x23, 0xf1, 0x8c, 0xdc, 0xd8, 0x04,
      0x8b, 0x9d, 0xb1, 0xcd, 0x61, 0x0c, 0x9c, 0x69,
      0xc7, 0x8d, 0x17, 0xb6, 0xe5, 0x0b, 0x94, 0xf7,
      0x78, 0x9b, 0x63, 0x49, 0xba, 0xfc, 0x08, 0x4d
    },

    0x84c53a90,                         // cr0_npx_state
  },
    
  0x79f71e76,                           // gs
  0x8107bd25,                           // fs
  0x452d2921,                           // es
  0x87ec2875,                           // ds
  0xf8bb73f5,                           // edi
  0xa63ebb88,                           // esi
  0x95d35ebe,                           // ebx
  0x17aa2456,                           // edx
  0x135fa208,                           // ecx
  0x500615e6,                           // eax
  0x66d14205,                           // ebp
  0x000719a5,                           // eip
  0x477b481b,                           // cs
  0x8684dfba,                           // eflags
  0xe33ccddf,                           // esp
  0xc0e65d33,                           // ss

  // extended_registers
  {
    0x68, 0x63, 0xdf, 0x50, 0xf7, 0x3b, 0xe8, 0xe5,
    0xcb, 0xd6, 0x66, 0x60, 0xe5, 0xa3, 0x58, 0xb3,
    0x6f, 0x34, 0xca, 0x02, 0x9b, 0x5f, 0xd0, 0x41,
    0xbd, 0xc5, 0x2d, 0xf8, 0xff, 0x15, 0xa2, 0xd0,
    0xe3, 0x2b, 0x3b, 0x8a, 0x9f, 0xc3, 0x9e, 0x28,
    0x0a, 0xc2, 0xac, 0x3b, 0x67, 0x37, 0x01, 0xfd,
    0xc3, 0xaf, 0x60, 0xf6, 0x2c, 0x4f, 0xa9, 0x52,
    0x92, 0xe5, 0x28, 0xde, 0x34, 0xb6, 0x2e, 0x44,
    0x15, 0xa4, 0xb6, 0xe4, 0xc9, 0x1a, 0x14, 0xb9,
    0x51, 0x33, 0x3c, 0xe0, 0xc7, 0x94, 0xf0, 0xf7,
    0x78, 0xdd, 0xe5, 0xca, 0xb7, 0xa6, 0xe0, 0x14,
    0xa6, 0x03, 0xab, 0x77, 0xad, 0xbd, 0xd2, 0x53,
    0x3d, 0x07, 0xe7, 0xaf, 0x90, 0x44, 0x71, 0xbe,
    0x0c, 0xdf, 0x2b, 0x97, 0x40, 0x48, 0xd5, 0xf9,
    0x62, 0x03, 0x91, 0x84, 0xd6, 0xdd, 0x29, 0x97,
    0x35, 0x02, 0xfb, 0x59, 0x97, 0xb0, 0xec, 0xa9,
    0x39, 0x6f, 0x81, 0x71, 0x2a, 0xf0, 0xe7, 0x2c,
    0x4e, 0x93, 0x90, 0xcb, 0x67, 0x69, 0xde, 0xd7,
    0x68, 0x3b, 0x0f, 0x69, 0xa8, 0xf4, 0xa8, 0x83,
    0x42, 0x80, 0x47, 0x65, 0x7a, 0xc9, 0x19, 0x5d,
    0xcb, 0x43, 0xa5, 0xff, 0xf8, 0x9e, 0x62, 0xf4,
    0xe2, 0x6c, 0xcc, 0x17, 0x55, 0x7c, 0x0d, 0x5c,
    0x8d, 0x16, 0x01, 0xd7, 0x3a, 0x0c, 0xf4, 0x7f,
    0x71, 0xdc, 0x48, 0xe9, 0x4b, 0xfe, 0x1a, 0xd0,
    0x04, 0x15, 0x33, 0xec, 0x78, 0xc6, 0x7e, 0xde,
    0x7c, 0x23, 0x18, 0x8d, 0x8f, 0xc2, 0x74, 0xc1,
    0x48, 0xcd, 0x5d, 0xee, 0xee, 0x81, 0x9e, 0x49,
    0x47, 0x8a, 0xf8, 0x61, 0xa3, 0x9c, 0x81, 0x96,
    0xbe, 0x2b, 0x5e, 0xbc, 0xcd, 0x34, 0x0a, 0x2a,
    0x3b, 0x8b, 0x7d, 0xa1, 0xf2, 0x8d, 0xb4, 0x51,
    0x9e, 0x14, 0x78, 0xa3, 0x58, 0x65, 0x2d, 0xd6,
    0x50, 0x40, 0x36, 0x32, 0x31, 0xd4, 0x3e, 0xc2,
    0xe0, 0x87, 0x1c, 0x05, 0x95, 0x80, 0x84, 0x24,
    0x08, 0x6f, 0x5b, 0xc7, 0xe1, 0x1d, 0xd5, 0xa3,
    0x94, 0x44, 0xa1, 0x7c, 0xd8, 0x4b, 0x86, 0xd2,
    0xc6, 0xa9, 0xf3, 0xe2, 0x4d, 0x6e, 0x1f, 0x0e,
    0xf2, 0xf5, 0x71, 0xf9, 0x71, 0x05, 0x24, 0xc9,
    0xc1, 0xe8, 0x91, 0x42, 0x61, 0x86, 0x57, 0x68,
    0xd9, 0xc9, 0x1d, 0xd5, 0x5a, 0xe9, 0xba, 0xe6,
    0x15, 0x8f, 0x87, 0xbd, 0x62, 0x56, 0xed, 0xda,
    0xc2, 0xa5, 0xd5, 0x39, 0xac, 0x05, 0x10, 0x14,
    0x4a, 0xe7, 0xe7, 0x3c, 0x3f, 0xb7, 0xbb, 0xed,
    0x01, 0x6e, 0xcd, 0xee, 0x81, 0xb4, 0x62, 0xf4,
    0x62, 0x16, 0xff, 0x20, 0xb4, 0xf0, 0xbc, 0xff,
    0x7d, 0xd9, 0xcf, 0x95, 0x30, 0x27, 0xe0, 0x2f,
    0x98, 0x53, 0x80, 0x15, 0x13, 0xef, 0x44, 0x58,
    0x12, 0x16, 0xdb, 0x11, 0xef, 0x73, 0x51, 0xcd,
    0x42, 0x3f, 0x98, 0x6c, 0xc9, 0x68, 0xc3, 0xf4,
    0x5b, 0x0f, 0x5d, 0x77, 0xed, 0xdf, 0x0f, 0xff,
    0xb8, 0x69, 0x98, 0x50, 0x77, 0x7a, 0xe8, 0x90,
    0x27, 0x46, 0x10, 0xd2, 0xb5, 0x00, 0x3b, 0x36,
    0x43, 0x6d, 0x67, 0x41, 0x20, 0x3a, 0x32, 0xe0,
    0x2e, 0x5a, 0xfb, 0x4e, 0x4f, 0xa4, 0xf7, 0xc2,
    0xe6, 0x81, 0x1a, 0x51, 0xa8, 0x7c, 0xd4, 0x60,
    0x7c, 0x45, 0xe2, 0xba, 0x5b, 0x42, 0xf3, 0xbf,
    0x28, 0xaa, 0xf2, 0x90, 0xe4, 0x94, 0xdd, 0xaa,
    0x22, 0xd3, 0x71, 0x33, 0xa1, 0x01, 0x43, 0x0e,
    0xfa, 0x46, 0xd2, 0x6e, 0x55, 0x5e, 0x49, 0xeb,
    0x94, 0xf0, 0xb0, 0xb1, 0x2e, 0xf2, 0x3d, 0x6c,
    0x00, 0x5e, 0x01, 0x56, 0x3b, 0xfd, 0x5b, 0xa1,
    0x2f, 0x63, 0x1d, 0xbf, 0xf9, 0xd8, 0x13, 0xf7,
    0x4d, 0xb7, 0x1e, 0x3d, 0x98, 0xd2, 0xee, 0xb8,
    0x48, 0xc8, 0x5b, 0x91, 0x0f, 0x54, 0x9e, 0x26,
    0xb2, 0xc7, 0x3a, 0x6c, 0x8a, 0x35, 0xe1, 0xba
  }
};

static const u_int8_t x86_expected_contents[] = {
  0x1b, 0xd7, 0xd5, 0xde, 
  0x2e, 0x43, 0xdb, 0x9f, 
  0x1a, 0xa8, 0xb7, 0x26, 
  0x48, 0xe3, 0xc7, 0xca, 
  0x09, 0xec, 0x99, 0xcf, 
  0xcd, 0xc2, 0xc8, 0x7d, 
  0x80, 0xb8, 0xde, 0x21, 
  0xb0, 0x2b, 0x5d, 0x8a, 
  0xc9, 0xc4, 0x86, 0x02, 
  0x21, 0xea, 0xfe, 0xf1, 
  0x76, 0x05, 0xd4, 0xb2, 
  0xde, 0x6c, 0x14, 0x48, 
  0x21, 0x9b, 0x3f, 0x98, 
  0x2c, 0xe1, 0x5b, 0x47, 

  // float_save.register_area --- unswapped
  0xd9, 0x04, 0x20, 0x6b, 0x88, 0x3a, 0x3f, 0xd5,
  0x59, 0x7a, 0xa9, 0xeb, 0xd0, 0x5c, 0xdf, 0xfe,
  0xad, 0xdd, 0x4a, 0x8b, 0x10, 0xcc, 0x9a, 0x33,
  0xcb, 0xb6, 0xf7, 0x86, 0xcd, 0x69, 0x25, 0xae,
  0x25, 0xe5, 0x7a, 0xa1, 0x8f, 0xb2, 0x84, 0xd9,
  0xf7, 0x2d, 0x8a, 0xa1, 0x80, 0x81, 0x7f, 0x67,
  0x07, 0xa8, 0x23, 0xf1, 0x8c, 0xdc, 0xd8, 0x04,
  0x8b, 0x9d, 0xb1, 0xcd, 0x61, 0x0c, 0x9c, 0x69,
  0xc7, 0x8d, 0x17, 0xb6, 0xe5, 0x0b, 0x94, 0xf7,
  0x78, 0x9b, 0x63, 0x49, 0xba, 0xfc, 0x08, 0x4d,

  0x90, 0x3a, 0xc5, 0x84, 
  0x76, 0x1e, 0xf7, 0x79, 
  0x25, 0xbd, 0x07, 0x81, 
  0x21, 0x29, 0x2d, 0x45, 
  0x75, 0x28, 0xec, 0x87, 
  0xf5, 0x73, 0xbb, 0xf8, 
  0x88, 0xbb, 0x3e, 0xa6, 
  0xbe, 0x5e, 0xd3, 0x95, 
  0x56, 0x24, 0xaa, 0x17, 
  0x08, 0xa2, 0x5f, 0x13, 
  0xe6, 0x15, 0x06, 0x50, 
  0x05, 0x42, 0xd1, 0x66, 
  0xa5, 0x19, 0x07, 0x00, 
  0x1b, 0x48, 0x7b, 0x47, 
  0xba, 0xdf, 0x84, 0x86, 
  0xdf, 0xcd, 0x3c, 0xe3, 
  0x33, 0x5d, 0xe6, 0xc0, 

  // extended_registers --- unswapped
  0x68, 0x63, 0xdf, 0x50, 0xf7, 0x3b, 0xe8, 0xe5,
  0xcb, 0xd6, 0x66, 0x60, 0xe5, 0xa3, 0x58, 0xb3,
  0x6f, 0x34, 0xca, 0x02, 0x9b, 0x5f, 0xd0, 0x41,
  0xbd, 0xc5, 0x2d, 0xf8, 0xff, 0x15, 0xa2, 0xd0,
  0xe3, 0x2b, 0x3b, 0x8a, 0x9f, 0xc3, 0x9e, 0x28,
  0x0a, 0xc2, 0xac, 0x3b, 0x67, 0x37, 0x01, 0xfd,
  0xc3, 0xaf, 0x60, 0xf6, 0x2c, 0x4f, 0xa9, 0x52,
  0x92, 0xe5, 0x28, 0xde, 0x34, 0xb6, 0x2e, 0x44,
  0x15, 0xa4, 0xb6, 0xe4, 0xc9, 0x1a, 0x14, 0xb9,
  0x51, 0x33, 0x3c, 0xe0, 0xc7, 0x94, 0xf0, 0xf7,
  0x78, 0xdd, 0xe5, 0xca, 0xb7, 0xa6, 0xe0, 0x14,
  0xa6, 0x03, 0xab, 0x77, 0xad, 0xbd, 0xd2, 0x53,
  0x3d, 0x07, 0xe7, 0xaf, 0x90, 0x44, 0x71, 0xbe,
  0x0c, 0xdf, 0x2b, 0x97, 0x40, 0x48, 0xd5, 0xf9,
  0x62, 0x03, 0x91, 0x84, 0xd6, 0xdd, 0x29, 0x97,
  0x35, 0x02, 0xfb, 0x59, 0x97, 0xb0, 0xec, 0xa9,
  0x39, 0x6f, 0x81, 0x71, 0x2a, 0xf0, 0xe7, 0x2c,
  0x4e, 0x93, 0x90, 0xcb, 0x67, 0x69, 0xde, 0xd7,
  0x68, 0x3b, 0x0f, 0x69, 0xa8, 0xf4, 0xa8, 0x83,
  0x42, 0x80, 0x47, 0x65, 0x7a, 0xc9, 0x19, 0x5d,
  0xcb, 0x43, 0xa5, 0xff, 0xf8, 0x9e, 0x62, 0xf4,
  0xe2, 0x6c, 0xcc, 0x17, 0x55, 0x7c, 0x0d, 0x5c,
  0x8d, 0x16, 0x01, 0xd7, 0x3a, 0x0c, 0xf4, 0x7f,
  0x71, 0xdc, 0x48, 0xe9, 0x4b, 0xfe, 0x1a, 0xd0,
  0x04, 0x15, 0x33, 0xec, 0x78, 0xc6, 0x7e, 0xde,
  0x7c, 0x23, 0x18, 0x8d, 0x8f, 0xc2, 0x74, 0xc1,
  0x48, 0xcd, 0x5d, 0xee, 0xee, 0x81, 0x9e, 0x49,
  0x47, 0x8a, 0xf8, 0x61, 0xa3, 0x9c, 0x81, 0x96,
  0xbe, 0x2b, 0x5e, 0xbc, 0xcd, 0x34, 0x0a, 0x2a,
  0x3b, 0x8b, 0x7d, 0xa1, 0xf2, 0x8d, 0xb4, 0x51,
  0x9e, 0x14, 0x78, 0xa3, 0x58, 0x65, 0x2d, 0xd6,
  0x50, 0x40, 0x36, 0x32, 0x31, 0xd4, 0x3e, 0xc2,
  0xe0, 0x87, 0x1c, 0x05, 0x95, 0x80, 0x84, 0x24,
  0x08, 0x6f, 0x5b, 0xc7, 0xe1, 0x1d, 0xd5, 0xa3,
  0x94, 0x44, 0xa1, 0x7c, 0xd8, 0x4b, 0x86, 0xd2,
  0xc6, 0xa9, 0xf3, 0xe2, 0x4d, 0x6e, 0x1f, 0x0e,
  0xf2, 0xf5, 0x71, 0xf9, 0x71, 0x05, 0x24, 0xc9,
  0xc1, 0xe8, 0x91, 0x42, 0x61, 0x86, 0x57, 0x68,
  0xd9, 0xc9, 0x1d, 0xd5, 0x5a, 0xe9, 0xba, 0xe6,
  0x15, 0x8f, 0x87, 0xbd, 0x62, 0x56, 0xed, 0xda,
  0xc2, 0xa5, 0xd5, 0x39, 0xac, 0x05, 0x10, 0x14,
  0x4a, 0xe7, 0xe7, 0x3c, 0x3f, 0xb7, 0xbb, 0xed,
  0x01, 0x6e, 0xcd, 0xee, 0x81, 0xb4, 0x62, 0xf4,
  0x62, 0x16, 0xff, 0x20, 0xb4, 0xf0, 0xbc, 0xff,
  0x7d, 0xd9, 0xcf, 0x95, 0x30, 0x27, 0xe0, 0x2f,
  0x98, 0x53, 0x80, 0x15, 0x13, 0xef, 0x44, 0x58,
  0x12, 0x16, 0xdb, 0x11, 0xef, 0x73, 0x51, 0xcd,
  0x42, 0x3f, 0x98, 0x6c, 0xc9, 0x68, 0xc3, 0xf4,
  0x5b, 0x0f, 0x5d, 0x77, 0xed, 0xdf, 0x0f, 0xff,
  0xb8, 0x69, 0x98, 0x50, 0x77, 0x7a, 0xe8, 0x90,
  0x27, 0x46, 0x10, 0xd2, 0xb5, 0x00, 0x3b, 0x36,
  0x43, 0x6d, 0x67, 0x41, 0x20, 0x3a, 0x32, 0xe0,
  0x2e, 0x5a, 0xfb, 0x4e, 0x4f, 0xa4, 0xf7, 0xc2,
  0xe6, 0x81, 0x1a, 0x51, 0xa8, 0x7c, 0xd4, 0x60,
  0x7c, 0x45, 0xe2, 0xba, 0x5b, 0x42, 0xf3, 0xbf,
  0x28, 0xaa, 0xf2, 0x90, 0xe4, 0x94, 0xdd, 0xaa,
  0x22, 0xd3, 0x71, 0x33, 0xa1, 0x01, 0x43, 0x0e,
  0xfa, 0x46, 0xd2, 0x6e, 0x55, 0x5e, 0x49, 0xeb,
  0x94, 0xf0, 0xb0, 0xb1, 0x2e, 0xf2, 0x3d, 0x6c,
  0x00, 0x5e, 0x01, 0x56, 0x3b, 0xfd, 0x5b, 0xa1,
  0x2f, 0x63, 0x1d, 0xbf, 0xf9, 0xd8, 0x13, 0xf7,
  0x4d, 0xb7, 0x1e, 0x3d, 0x98, 0xd2, 0xee, 0xb8,
  0x48, 0xc8, 0x5b, 0x91, 0x0f, 0x54, 0x9e, 0x26,
  0xb2, 0xc7, 0x3a, 0x6c, 0x8a, 0x35, 0xe1, 0xba
};

#endif // PROCESSOR_SYNTH_MINIDUMP_UNITTEST_DATA_H_
