/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

public class JrpcgenSHA {
    private final int[] W = new int[80];
    private long bytecount;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;

    public JrpcgenSHA() {
        this.reset();
    }

    public void update(byte b) {
        int i = (int)this.bytecount % 64;
        int shift = (3 - i % 4) * 8;
        int idx = i / 4;
        this.W[idx] = this.W[idx] & ~(255 << shift) | (b & 0xFF) << shift;
        if (++this.bytecount % (long)64 == (long)0) {
            this.process();
        }
    }

    public void update(short s) {
        this.update((byte)s);
        this.update((byte)(s >>> 8));
    }

    public void update(int i) {
        this.update((byte)i);
        this.update((byte)(i >>> 8));
        this.update((byte)(i >>> 16));
        this.update((byte)(i >>> 24));
    }

    public void update(String s) {
        int len = s.length();
        for (int idx = 0; idx < len; ++idx) {
            this.update((short)s.charAt(idx));
        }
    }

    public void reset() {
        this.bytecount = 0L;
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
    }

    public byte[] getDigest() {
        long bitcount = this.bytecount * (long)8;
        this.update((byte)-128);
        while ((int)this.bytecount % 64 != 56) {
            this.update((byte)0);
        }
        this.W[14] = (int)(bitcount >>> 32);
        this.W[15] = (int)bitcount;
        this.bytecount += (long)8;
        this.process();
        byte[] result = new byte[]{(byte)(this.H0 >>> 24), (byte)(this.H0 >>> 16), (byte)(this.H0 >>> 8), (byte)this.H0, (byte)(this.H1 >>> 24), (byte)(this.H1 >>> 16), (byte)(this.H1 >>> 8), (byte)this.H1, (byte)(this.H2 >>> 24), (byte)(this.H2 >>> 16), (byte)(this.H2 >>> 8), (byte)this.H2, (byte)(this.H3 >>> 24), (byte)(this.H3 >>> 16), (byte)(this.H3 >>> 8), (byte)this.H3, (byte)(this.H4 >>> 24), (byte)(this.H4 >>> 16), (byte)(this.H4 >>> 8), (byte)this.H4};
        this.reset();
        return result;
    }

    public long getHash() {
        byte[] hash = this.getDigest();
        return ((long)hash[0] & (long)255) + (((long)hash[1] & (long)255) << 8) + (((long)hash[2] & (long)255) << 16) + (((long)hash[3] & (long)255) << 24) + (((long)hash[4] & (long)255) << 32) + (((long)hash[5] & (long)255) << 40) + (((long)hash[6] & (long)255) << 48) + (((long)hash[7] & (long)255) << 56);
    }

    private void process() {
        int TEMP;
        int t;
        for (int t2 = 16; t2 < 80; ++t2) {
            int Wt = this.W[t2 - 3] ^ this.W[t2 - 8] ^ this.W[t2 - 14] ^ this.W[t2 - 16];
            this.W[t2] = Wt << 1 | Wt >>> 31;
        }
        int A = this.H0;
        int B = this.H1;
        int C = this.H2;
        int D = this.H3;
        int E = this.H4;
        for (t = 0; t < 20; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + this.W[t] + 1518500249;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 20; t < 40; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[t] + 1859775393;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 40; t < 60; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + this.W[t] + -1894007588;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        for (t = 60; t < 80; ++t) {
            TEMP = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + this.W[t] + -899497514;
            E = D;
            D = C;
            C = B << 30 | B >>> 2;
            B = A;
            A = TEMP;
        }
        this.H0 += A;
        this.H1 += B;
        this.H2 += C;
        this.H3 += D;
        this.H4 += E;
        for (t = 0; t < 80; ++t) {
            this.W[t] = 0;
        }
    }
}

