/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.LazyLines;
import org.openide.text.Line;
import org.openide.text.LineListener;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public abstract class DocumentLine
extends Line {
    private static Map<CloneableEditorSupport, DocumentLine[]> assigned = new WeakHashMap<CloneableEditorSupport, DocumentLine[]>(5);
    static final long serialVersionUID = 3213776466939427487L;
    protected PositionRef pos;
    @Deprecated
    private boolean breakpoint;
    @Deprecated
    private transient boolean error;
    @Deprecated
    private transient boolean current;
    private transient LR listener;
    private transient DocumentListener docL;
    private List<Part> lineParts = new ArrayList<Part>(3);

    public DocumentLine(Lookup lookup, PositionRef positionRef) {
        super(lookup);
        this.pos = positionRef;
    }

    void init() {
        this.listener = new LR();
        this.pos.getCloneableEditorSupport().addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)((Object)this.pos.getCloneableEditorSupport())));
    }

    public int getLineNumber() {
        try {
            return this.pos.getLine();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public abstract void show(int var1, int var2);

    public void setBreakpoint(boolean bl) {
        if (this.breakpoint != bl) {
            this.breakpoint = bl;
            this.refreshState();
        }
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void markError() {
        DocumentLine documentLine = this.registerLine(1, this);
        if (documentLine != null) {
            documentLine.error = false;
            documentLine.refreshState();
        }
        this.error = true;
        this.refreshState();
    }

    public void unmarkError() {
        this.error = false;
        this.registerLine(1, null);
        this.refreshState();
    }

    public void markCurrentLine() {
        DocumentLine documentLine = this.registerLine(0, this);
        if (documentLine != null) {
            documentLine.current = false;
            documentLine.refreshState();
        }
        this.current = true;
        this.refreshState();
    }

    public void unmarkCurrentLine() {
        this.current = false;
        this.registerLine(0, null);
        this.refreshState();
    }

    @Deprecated
    synchronized void refreshState() {
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument != null) {
            if (this.docL != null) {
                styledDocument.removeDocumentListener(this.docL);
            }
            if (this.error) {
                NbDocument.markError(styledDocument, this.pos.getOffset());
                this.docL = WeakListeners.document((DocumentListener)this.listener, (Object)styledDocument);
                styledDocument.addDocumentListener(this.docL);
                return;
            }
            if (this.current) {
                NbDocument.markCurrent(styledDocument, this.pos.getOffset());
                return;
            }
            if (this.breakpoint) {
                NbDocument.markBreakpoint(styledDocument, this.pos.getOffset());
                return;
            }
            NbDocument.markNormal(styledDocument, this.pos.getOffset());
            return;
        }
    }

    public int hashCode() {
        return ((Object)((Object)this.pos.getCloneableEditorSupport())).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DocumentLine) {
            DocumentLine documentLine = (DocumentLine)object;
            if (documentLine.pos.getCloneableEditorSupport() == this.pos.getCloneableEditorSupport()) {
                return documentLine.getLineNumber() == this.getLineNumber();
            }
        }
        return false;
    }

    @Deprecated
    private DocumentLine registerLine(int n, DocumentLine documentLine) {
        DocumentLine documentLine2;
        CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
        DocumentLine[] documentLineArray = assigned.get((Object)cloneableEditorSupport);
        if (documentLineArray != null) {
            documentLine2 = documentLineArray[n];
        } else {
            documentLineArray = new DocumentLine[2];
            assigned.put(cloneableEditorSupport, documentLineArray);
            documentLine2 = null;
        }
        documentLineArray[n] = documentLine;
        return documentLine2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.pos);
        objectOutputStream.writeBoolean(this.breakpoint);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pos = (PositionRef)objectInputStream.readObject();
        this.setBreakpoint(objectInputStream.readBoolean());
        this.lineParts = new ArrayList<Part>(3);
    }

    Object readResolve() throws ObjectStreamException {
        return this.pos.getCloneableEditorSupport().getLineSet().registerLine(this);
    }

    protected void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        try {
            if (!annotation.isInDocument()) {
                annotation.setInDocument(true);
                FindAnnotationPosition findAnnotationPosition = new FindAnnotationPosition(styledDocument, this.pos.getPosition());
                styledDocument.render(findAnnotationPosition);
                NbDocument.addAnnotation(styledDocument, findAnnotationPosition.getAnnotationPosition(), -1, annotation);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, iOException);
        }
    }

    protected void removeAnnotation(Annotation annotation) {
        super.removeAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        if (annotation.isInDocument()) {
            annotation.setInDocument(false);
            NbDocument.removeAnnotation(styledDocument, annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
        Object object;
        Position position = null;
        if (!bl) {
            try {
                position = this.pos.getPosition();
                object = new FindAnnotationPosition(styledDocument, position);
                styledDocument.render((Runnable)object);
                position = ((FindAnnotationPosition)object).getAnnotationPosition();
            }
            catch (IOException iOException) {
                Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        Object object2 = object = this.getAnnotations();
        synchronized (object2) {
            Iterator<? extends Annotation> object3 = object.iterator();
            while (object3.hasNext()) {
                Annotation annotation = object3.next();
                if (!bl) {
                    if (annotation.isInDocument()) continue;
                    annotation.setInDocument(true);
                    NbDocument.addAnnotation(styledDocument, position, -1, annotation);
                    continue;
                }
                if (!annotation.isInDocument()) continue;
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
        }
        for (Part part : this.lineParts) {
            part.attachDetachAnnotations(styledDocument, bl);
        }
    }

    public String getText() {
        final StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        styledDocument.render(new Runnable(){

            public void run() {
                int n = DocumentLine.this.getLineNumber();
                int n2 = NbDocument.findLineOffset(styledDocument, n);
                int n3 = n + 1 >= NbDocument.findLineRootElement(styledDocument).getElementCount() ? styledDocument.getLength() : NbDocument.findLineOffset(styledDocument, n + 1);
                try {
                    stringArray[0] = styledDocument.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, badLocationException);
                    stringArray[0] = null;
                }
            }
        });
        return stringArray[0];
    }

    void addLinePart(Part part) {
        this.lineParts.add(part);
    }

    void moveLinePart(Part part, DocumentLine documentLine) {
        this.lineParts.remove(part);
        documentLine.addLinePart(part);
        part.changeLine(documentLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChange(DocumentEvent documentEvent, Set set, StyledDocument styledDocument) {
        Position position;
        int n = 0;
        while (n < this.lineParts.size()) {
            Part part = this.lineParts.get(n);
            part.handleDocumentChange(documentEvent);
            if (NbDocument.findLineNumber(styledDocument, part.getOffset()) != part.getLine().getLineNumber()) {
                DocumentLine documentLine = (DocumentLine)set.getCurrent(NbDocument.findLineNumber(styledDocument, part.getOffset()));
                this.moveLinePart(part, documentLine);
                continue;
            }
            ++n;
        }
        try {
            position = this.pos.getPosition();
        }
        catch (IOException iOException) {
            Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, iOException);
            position = null;
        }
        if (position != null) {
            List<? extends Annotation> list;
            int n2 = NbDocument.findLineOffset(styledDocument, NbDocument.findLineNumber(styledDocument, position.getOffset()));
            CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
            this.pos = new PositionRef(cloneableEditorSupport.getPositionManager(), n2, Position.Bias.Forward);
            List<? extends Annotation> list2 = list = this.getAnnotations();
            synchronized (list2) {
                if (list.size() > 0) {
                    try {
                        position = this.pos.getPosition();
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException();
                    }
                    for (Annotation annotation : list) {
                        if (annotation.isInDocument()) {
                            annotation.setInDocument(false);
                            NbDocument.removeAnnotation(cloneableEditorSupport.getDocument(), annotation);
                        }
                        if (annotation.isInDocument()) continue;
                        annotation.setInDocument(true);
                        NbDocument.addAnnotation(cloneableEditorSupport.getDocument(), position, -1, annotation);
                    }
                }
            }
        }
    }

    void notifyMove() {
        this.updatePositionRef();
        for (int i = 0; i < this.lineParts.size(); ++i) {
            this.lineParts.get(i).firePropertyChange("line", null, null);
        }
    }

    private void updatePositionRef() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Set
    extends Line.Set {
        final LineListener listener;
        private List<Line> list;

        public Set(StyledDocument styledDocument) {
            this(styledDocument, null);
        }

        Set(StyledDocument styledDocument, CloneableEditorSupport cloneableEditorSupport) {
            this.listener = new LineListener(styledDocument, cloneableEditorSupport);
        }

        void linesChanged(int n, int n2, DocumentEvent documentEvent) {
            List<Line> list = this.getLinesFromRange(n, n2);
            StyledDocument styledDocument = this.listener.support.getDocument();
            for (Line line : list) {
                line.firePropertyChange("text", null, null);
                if (styledDocument == null || !(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyChange(documentEvent, this, styledDocument);
            }
        }

        void linesMoved(int n, int n2) {
            List<Line> list = this.getLinesFromRange(n, n2);
            for (Line line : list) {
                line.firePropertyChange("lineNumber", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyMove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Line> getLinesFromRange(int n, int n2) {
            ArrayList<Line> arrayList = new ArrayList<Line>(10);
            Map<Line, Reference<Line>> map = this.findWeakHashMap();
            synchronized (map) {
                for (Line line : this.findWeakHashMap().keySet()) {
                    int n3 = line.getLineNumber();
                    if (n > n3 || n3 > n2) continue;
                    arrayList.add(line);
                }
            }
            return arrayList;
        }

        @Override
        public synchronized List<? extends Line> getLines() {
            if (this.list == null) {
                this.list = new LazyLines(this);
            }
            return this.list;
        }

        @Override
        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            int n2 = this.listener.getLine(n);
            return this.safelyRegisterLine(this.createLine(this.offset(n2)));
        }

        @Override
        public int getOriginalLineNumber(Line line) {
            Line line2 = this.findLine(line);
            if (line2 != null) {
                return this.listener.getOld(line2.getLineNumber());
            }
            return -1;
        }

        @Override
        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            return this.safelyRegisterLine(this.createLine(this.offset(n)));
        }

        private int offset(int n) {
            StyledDocument styledDocument = this.listener.support.getDocument();
            int n2 = styledDocument == null ? 0 : NbDocument.findLineOffset(styledDocument, n);
            return n2;
        }

        protected abstract Line createLine(int var1);

        private Line safelyRegisterLine(final Line line) {
            assert (line != null);
            StyledDocument styledDocument = this.listener.support.getDocument();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DocumentRenderer
            implements Runnable {
                public Line result;

                DocumentRenderer() {
                }

                @Override
                public void run() {
                    this.result = Set.super.registerLine(line);
                }
            }
            DocumentRenderer documentRenderer = new DocumentRenderer();
            if (styledDocument != null) {
                styledDocument.render(documentRenderer);
            } else {
                documentRenderer.run();
            }
            return documentRenderer.result;
        }
    }

    private final class LR
    implements Runnable,
    ChangeListener,
    DocumentListener {
        private static final int REFRESH = 0;
        private static final int UNMARK = 1;
        private static final int ATTACH_DETACH = 2;
        private int actionId;
        private EnhancedChangeEvent ev;

        public LR() {
        }

        public LR(int n) {
            this.actionId = n;
        }

        public LR(EnhancedChangeEvent enhancedChangeEvent) {
            this.actionId = 2;
            this.ev = enhancedChangeEvent;
        }

        public void run() {
            switch (this.actionId) {
                case 0: {
                    DocumentLine.this.refreshState();
                    break;
                }
                case 1: {
                    DocumentLine.this.unmarkError();
                    break;
                }
                case 2: {
                    DocumentLine.this.attachDetachAnnotations(this.ev.getDocument(), this.ev.isClosingDocument());
                    this.ev = null;
                }
            }
        }

        private void invoke(int n) {
            new LR(n).run();
        }

        private void invoke(EnhancedChangeEvent enhancedChangeEvent) {
            new LR(enhancedChangeEvent).run();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.invoke(0);
            this.invoke((EnhancedChangeEvent)changeEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    static class Part
    extends Line.Part {
        private PositionRef position;
        private Line line;
        private int length;
        private int previousOffset;

        public Part(Line line, PositionRef positionRef, int n) {
            this.position = positionRef;
            this.line = line;
            this.previousOffset = positionRef.getOffset();
            this.length = this.limitLength(n);
        }

        private int limitLength(int n) {
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return n;
            }
            int n2 = this.position.getOffset() + n;
            if (n2 > styledDocument.getLength()) {
                n2 = styledDocument.getLength();
            }
            if (n2 < this.position.getOffset()) {
                return 0;
            }
            try {
                String string = styledDocument.getText(this.position.getOffset(), n2 - this.position.getOffset());
                int n3 = string.indexOf(10);
                return n3 == -1 ? string.length() : n3 + 1;
            }
            catch (BadLocationException badLocationException) {
                IllegalStateException illegalStateException = new IllegalStateException(badLocationException.getMessage());
                illegalStateException.initCause(badLocationException);
                throw illegalStateException;
            }
        }

        public int getColumn() {
            try {
                return this.position.getColumn();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        public int getLength() {
            return this.length;
        }

        public Line getLine() {
            return this.line;
        }

        int getOffset() {
            return this.position.getOffset();
        }

        void changeLine(Line line) {
            this.line = line;
            this.firePropertyChange("lineNumber", null, line);
        }

        protected void addAnnotation(Annotation annotation) {
            super.addAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            try {
                if (!annotation.isInDocument()) {
                    annotation.setInDocument(true);
                    NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.length, annotation);
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, iOException);
            }
        }

        protected void removeAnnotation(Annotation annotation) {
            super.removeAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            if (annotation.isInDocument()) {
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
        }

        public String getText() {
            final StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return null;
            }
            final String[] stringArray = new String[1];
            styledDocument.render(new Runnable(){

                public void run() {
                    try {
                        int n = Part.this.position.getOffset();
                        stringArray[0] = n >= styledDocument.getLength() ? "" : styledDocument.getText(Part.this.position.getOffset(), Part.this.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, badLocationException);
                        stringArray[0] = null;
                    }
                }
            });
            return stringArray[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
            List<? extends Annotation> list;
            List<? extends Annotation> list2 = list = this.getAnnotations();
            synchronized (list2) {
                for (Annotation annotation : list) {
                    if (!bl) {
                        try {
                            if (annotation.isInDocument()) continue;
                            annotation.setInDocument(true);
                            NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.getLength(), annotation);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(DocumentLine.class.getName()).log(Level.WARNING, null, iOException);
                        }
                        continue;
                    }
                    if (!annotation.isInDocument()) continue;
                    annotation.setInDocument(false);
                    NbDocument.removeAnnotation(styledDocument, annotation);
                }
            }
        }

        void handleDocumentChange(DocumentEvent documentEvent) {
            if (documentEvent.getType().equals(DocumentEvent.EventType.INSERT) && documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength()) {
                this.firePropertyChange("text", null, null);
            }
            if (documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) && (documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength() || documentEvent.getOffset() < this.previousOffset && documentEvent.getOffset() + documentEvent.getLength() > this.previousOffset)) {
                this.length = this.limitLength(this.length);
                this.firePropertyChange("text", null, null);
            }
            if ((documentEvent.getType().equals(DocumentEvent.EventType.INSERT) || documentEvent.getType().equals(DocumentEvent.EventType.REMOVE)) && documentEvent.getOffset() < this.previousOffset) {
                this.firePropertyChange("column", null, null);
            }
            this.previousOffset = this.position.getOffset();
        }
    }

    private static final class FindAnnotationPosition
    implements Runnable {
        private StyledDocument doc;
        private Position annoPos;

        FindAnnotationPosition(StyledDocument styledDocument, Position position) {
            this.doc = styledDocument;
            this.annoPos = position;
        }

        public void run() {
            int n;
            int n2 = this.annoPos.getOffset();
            if (n2 != (n = this.doc.getParagraphElement(n2).getStartOffset())) {
                try {
                    this.annoPos = this.doc.createPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException();
                }
            }
        }

        Position getAnnotationPosition() {
            return this.annoPos;
        }
    }
}

