/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.threads.ThreadData;

public class ThreadStateIcon
implements Icon {
    public static final int ICON_NONE = -100;
    protected Color threadStateColor;
    protected int height;
    protected int width;

    public ThreadStateIcon(int threadState, int width, int height) {
        this.threadStateColor = this.getThreadStateColor(threadState);
        this.width = width;
        this.height = height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.threadStateColor != null) {
            if (!this.threadStateColor.equals(CommonConstants.THREAD_STATUS_ZOMBIE_COLOR)) {
                g.setColor(this.threadStateColor);
                g.fillRect(x, y, this.width, this.height);
            }
            g.setColor(Color.BLACK);
            g.drawRect(x, y, this.width - 1, this.height - 1);
        }
    }

    protected Color getThreadStateColor(int threadState) {
        if (threadState == -100) {
            return null;
        }
        return ThreadData.getThreadStateColor((int)threadState);
    }
}

