/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.awt.Color;
import java.util.List;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public abstract class DrillDownPieChartModel
extends AbstractPieChartModel
implements DrillDownListener {
    private static Color[] COLORS = new Color[]{new Color(0x99FF99), new Color(0x99CC99), new Color(0x666633), new Color(0x336666), new Color(0x6699CC), new Color(0x9999CC), new Color(0xFFCCFF), new Color(0xCC9999), new Color(0x660099), new Color(26112)};
    protected IDrillDown drillDown;
    private Object itemMapLock = new Object();
    private int[] itemMap = null;
    private int itemCount = 0;

    public DrillDownPieChartModel(IDrillDown model) {
        this.setDrillDown(model);
    }

    public void setDrillDown(IDrillDown model) {
        if (this.drillDown != null) {
            this.drillDown.removeListener(this);
        }
        this.drillDown = model;
        this.updateItemMap();
        this.drillDown.addListener(this);
    }

    public Color getItemColor(int index) {
        if (index == -1) {
            return Color.BLACK;
        }
        return COLORS[index % COLORS.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.itemCount;
        }
    }

    public String getItemDescription(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return "";
        }
        return ((Mark)this.drillDown.getSubmarks().get((int)this.getMappedIndex((int)index))).description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drillDownPathChanged(List newDrillDownPath) {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    public void drilldown(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return;
        }
        if (this.drillDown.getSubmarks().isEmpty()) {
            return;
        }
        this.drillDown.drilldown((Mark)this.drillDown.getSubmarks().get(this.getMappedIndex(index)));
    }

    public void drillup() {
        this.drillDown.drillup();
    }

    public void drillup(int index) {
        if (index == -1 || this.getMappedIndex(index) == -1) {
            return;
        }
        this.drillDown.drillup((Mark)this.drillDown.getSubmarks().get(this.getMappedIndex(index)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.drillDown != null && this.itemCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMappedIndex(int index) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (index < 0 || index >= this.itemMap.length) {
                return -1;
            }
            return this.itemMap[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemMap() {
        Object object = this.itemMapLock;
        synchronized (object) {
            int counter = 0;
            int mapCounter = 0;
            int[] map = new int[this.drillDown.getSubmarks().size()];
            for (Mark mark : this.drillDown.getSubmarks()) {
                if (this.drillDown.getMarkTime(mark, false) > 0L) {
                    map[mapCounter++] = counter;
                }
                ++counter;
            }
            this.itemCount = mapCounter > 0 ? mapCounter : 0;
            this.itemMap = map;
        }
    }
}

