/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.StatisticsPanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.ProjectPieChartModel;

public class DrillDownPanel
extends StatisticalModule {
    private DrillDownListener listener = new DrillDownListener(){

        public void dataChanged() {
        }

        public void drillDownPathChanged(List list) {
            DrillDownPanel.this.updateCrumbNav();
        }
    };
    private HTMLTextArea crumbNav;
    private IDrillDown ddModel;
    private PieChart pieChart;
    private ProjectPieChartModel pieModel = null;
    private StatisticsPanel panel = null;
    private int lastNavigableCategory;

    public DrillDownPanel(IDrillDown model) {
        this.ddModel = model;
        this.ddModel.addListener(this.listener);
        this.initComponents();
    }

    public void addSnippet(StatisticalModule component) {
        this.panel.addSnippet(component);
    }

    public void pause() {
    }

    public void refresh(RuntimeCPUCCTNode appNode) {
    }

    public void removeSnippet(StatisticalModule component) {
        this.panel.removeSnippet(component);
    }

    public void resume() {
    }

    private synchronized HTMLTextArea getCrumbNav() {
        if (this.crumbNav == null) {
            this.crumbNav = new HTMLTextArea();
            this.crumbNav.setOpaque(false);
            this.crumbNav.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    String query = e.getURL().getQuery();
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    int index = e.getURL().getQuery().lastIndexOf(61);
                    if (index <= -1) {
                        return;
                    }
                    int catIndex = Integer.parseInt(query.substring(index + 1));
                    DrillDownPanel.this.ddModel.drillup((Mark)DrillDownPanel.this.ddModel.getDrillDownPath().get(catIndex));
                }
            });
            this.updateCrumbNav();
        }
        return this.crumbNav;
    }

    private synchronized PieChart getPieChart() {
        if (this.pieChart == null) {
            this.pieChart = new PieChart();
            this.pieModel = new ProjectPieChartModel(this.ddModel);
            this.pieChart.setModel(this.pieModel);
        }
        return this.pieChart;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.panel = new StatisticsPanel(this.getCrumbNav(), this.getPieChart(), new Runnable(){

            public void run() {
                DrillDownPanel.this.navigateOneLevelBack();
            }
        });
        this.panel.addListener(new StatisticsPanel.Listener(){

            public void itemClicked(int itemIndex) {
                DrillDownPanel.this.pieModel.drilldown(itemIndex);
            }
        });
        this.add((Component)this.panel, "Center");
    }

    private void navigateOneLevelBack() {
        if (this.lastNavigableCategory != -1) {
            this.ddModel.drillup((Mark)this.ddModel.getDrillDownPath().get(this.lastNavigableCategory));
        }
    }

    private synchronized void updateCrumbNav() {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        this.lastNavigableCategory = -1;
        Iterator it = this.ddModel.getDrillDownPath().iterator();
        while (it.hasNext()) {
            Mark mark = (Mark)it.next();
            if (it.hasNext()) {
                sb.append("<a href=\"http://localhost/category?id=").append(counter).append("\">").append(mark.description).append("</a>").append("/");
                this.lastNavigableCategory = counter;
            } else {
                sb.append(mark.description);
            }
            this.crumbNav.setText(sb.toString());
            ++counter;
        }
    }
}

