/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.charts.AsyncMarksProvider;
import org.netbeans.lib.profiler.ui.charts.ChartActionListener;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DateTimeAxisUtils;
import org.netbeans.lib.profiler.ui.charts.DecimalAxisUtils;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;

public class SynchronousXYChart
extends JComponent
implements ComponentListener,
ChartModelListener,
MouseListener,
MouseMotionListener,
AdjustmentListener,
Accessible {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.charts.Bundle");
    private static final String FIT_TO_WINDOW_STRING = messages.getString("SynchronousXYChart_FitToWindowString");
    public static final int TYPE_LINE = 1;
    public static final int TYPE_FILL = 2;
    public static final int VALUES_INTERPOLATED = 50;
    public static final int VALUES_DISCRETE = 51;
    public static final int COPY_ACCEL_GENERIC = 100;
    public static final int COPY_ACCEL_RASTER = 101;
    private static final int HORIZONTAL_LEGEND_MARGIN = 5;
    private static final double minimumVisibleDataWidthRel = 0.1;
    private static final long minimumOptimalUnits = 100L;
    private static final double maximumZoom = DateTimeAxisUtils.getMaximumScale(100L);
    private AccessibleContext accessibleContext;
    private BufferedImage offScreenImage;
    private Color evenSelectionSegmentsColor;
    private Color limitYColor = Color.WHITE;
    private Color oddSelectionSegmentColor;
    private Font horizontalAxisFont;
    private Font horizontalAxisFontSmall;
    private Font verticalAxisFont;
    private Graphics2D offScreenGraphics;
    private Insets chartInsets;
    private Insets insets;
    private JScrollBar scrollBar;
    private Paint backgroundPaint;
    private Paint chartPaint;
    private Paint horizontalAxisPaint;
    private Paint horizontalMeshPaint;
    private Paint verticalAxisPaint;
    private Paint verticalMeshPaint;
    private Rectangle horizontalAxisClip = new Rectangle();
    private Rectangle horizontalAxisMarksClip = new Rectangle();
    private Rectangle verticalAxisClip = new Rectangle();
    private Rectangle verticalAxisClip2 = new Rectangle();
    private String verticalAxisValueString;
    private String verticalAxisValueString2;
    private Stroke chartStroke;
    private Stroke evenSelectionSegmentsStroke;
    private Stroke horizontalAxisStroke;
    private Stroke horizontalMeshStroke;
    private Stroke oddSelectionSegmentStroke;
    private Stroke verticalAxisStroke;
    private Stroke verticalMeshStroke;
    private SynchronousXYChartModel model;
    private Vector chartActionListeners;
    private long[] dataOffsetsY;
    private long[] lastMaxYs;
    private long[] lastMinYs;
    private double[] scaleFactorsY;
    private boolean allowSelection;
    private boolean autoTrackingEnd;
    private boolean customizedEmptyAppearance = false;
    private boolean fitToWindow;
    private boolean internalScrollBarChange;
    private boolean lastLeadingItemIsForBuffer;
    private boolean lastScaleXValid;
    private boolean lastScaleYValid;
    private boolean lastTrailingItemIndexValid;
    private boolean lastViewOffsetXValid;
    private boolean mouseInProgress;
    private boolean offScreenImageInvalid;
    private boolean scaleFactorsNeedUpdate;
    private boolean scrollBarValuesDirty;
    private boolean selectionTracksMovement;
    private boolean trackingEnd;
    private boolean trailingItemVisible;
    private boolean useDayInTimeLegend;
    private boolean useSecondaryVerticalAxis;
    private boolean verticalAxisValueAdaptDivider;
    private boolean verticalAxisValueAdaptDivider2;
    private double dataWidthAtTrackingEndSwitch;
    private double initialZoom;
    private double scaleFactorX;
    private double scrollBarLongToIntFactor;
    private double viewScaleX;
    private int chartHeight;
    private int chartWidth;
    private int copyAccel = 100;
    private int dataType;
    private int drawHeight;
    private int drawWidth;
    private int lastLeadingItemIndex;
    private int lastTrailingItemIndex;
    private int minimumVerticalMarksDistance;
    private int selectionHeight;
    private int selectionWidth;
    private int selectionX;
    private int selectionY;
    private int topChartMargin;
    private int type;
    private int verticalAxisValueDivider;
    private int verticalAxisValueDivider2;
    private long dataOffsetX;
    private long dataViewWidth;
    private long firstValueH;
    private long firstValueV;
    private long lastMaxY;
    private long lastMinY;
    private long lastValueH;
    private long lastValueV;
    private long lastViewOffsetX;
    private long limitYValue = Long.MAX_VALUE;
    private long optimalUnits;
    private long viewOffsetX;

    public SynchronousXYChart() {
        this(2);
    }

    public SynchronousXYChart(int type) {
        this(type, 50);
    }

    public SynchronousXYChart(int type, int dataType) {
        this(type, dataType, 1.0);
    }

    public SynchronousXYChart(int type, int dataType, double initialZoom) {
        this.type = type;
        this.dataType = dataType;
        this.allowSelection = false;
        this.chartInsets = new Insets(10, 20, 10, 20);
        this.topChartMargin = 20;
        this.backgroundPaint = UIManager.getColor("Panel.background");
        this.chartPaint = Color.WHITE;
        this.chartStroke = new BasicStroke(2.0f);
        this.mouseInProgress = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.lastScaleYValid = false;
        this.lastTrailingItemIndex = 0;
        this.lastTrailingItemIndexValid = false;
        this.changeTrackingEnd(false);
        this.changeFitToWindow(false);
        this.autoTrackingEnd = true;
        this.selectionTracksMovement = true;
        this.initialZoom = initialZoom;
        this.viewScaleX = initialZoom;
        this.viewOffsetX = 0L;
        this.verticalMeshPaint = new Color(80, 80, 80, 50);
        this.verticalMeshStroke = new BasicStroke();
        this.horizontalAxisFont = UIManager.getFont("Panel.font");
        this.horizontalAxisFontSmall = this.horizontalAxisFont.deriveFont((float)(this.horizontalAxisFont.getSize() - 2));
        this.verticalAxisFont = UIManager.getFont("Panel.font");
        this.horizontalAxisPaint = Color.BLACK;
        this.horizontalAxisStroke = new BasicStroke();
        this.verticalAxisPaint = Color.BLACK;
        this.verticalAxisStroke = new BasicStroke();
        this.useSecondaryVerticalAxis = false;
        this.verticalAxisValueDivider = 1;
        this.verticalAxisValueString = "";
        this.setVerticalAxisValueAdaptDivider(false);
        this.verticalAxisValueDivider2 = 1;
        this.verticalAxisValueString2 = "";
        this.setVerticalAxisValueAdaptDivider2(false);
        this.useDayInTimeLegend = false;
        this.minimumVerticalMarksDistance = 50;
        this.evenSelectionSegmentsColor = Color.WHITE;
        this.evenSelectionSegmentsStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
        this.oddSelectionSegmentColor = Color.BLACK;
        this.oddSelectionSegmentStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 2.0f);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setAutoTrackingEnd(boolean autoTrackingEnd) {
        this.autoTrackingEnd = autoTrackingEnd;
    }

    public boolean getAutoTrackingEnd() {
        return this.autoTrackingEnd;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        if (this.backgroundPaint == null && backgroundPaint != null || !this.backgroundPaint.equals(backgroundPaint)) {
            this.backgroundPaint = backgroundPaint;
            this.doRepaint(false);
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setChartPaint(Paint chartPaint) {
        if (this.chartPaint == null && chartPaint != null || !this.chartPaint.equals(chartPaint)) {
            this.chartPaint = chartPaint;
            this.doRepaint(false);
        }
    }

    public Paint getChartPaint() {
        return this.backgroundPaint;
    }

    public void setChartStroke(Stroke chartStroke) {
        if (this.chartStroke == null && chartStroke != null || !this.chartStroke.equals(chartStroke)) {
            this.chartStroke = chartStroke;
            this.doRepaint(false);
        }
    }

    public Stroke getChartStroke() {
        return this.chartStroke;
    }

    public void setCopyAcceleration(int copyAccel) {
        this.copyAccel = copyAccel;
    }

    public int getCopyAcceleration() {
        return this.copyAccel;
    }

    public long getDataToViewHeight(long height, int seriesIndex) {
        return (long)Math.ceil((double)height * this.scaleFactorsY[seriesIndex]);
    }

    public long getDataToViewWidth(long width) {
        return (long)Math.ceil((double)width * this.scaleFactorX);
    }

    public long getDataToViewX(long xValue) {
        return (long)Math.ceil((double)(xValue - this.dataOffsetX) * this.scaleFactorX + (double)this.chartInsets.left - (double)this.viewOffsetX);
    }

    public long getDataToViewY(long yValue, int seriesIndex) {
        return (long)this.chartHeight - (long)Math.ceil((double)(yValue - this.dataOffsetsY[seriesIndex]) * this.scaleFactorsY[seriesIndex] - (double)this.chartInsets.top);
    }

    public void setFitToWindow(boolean fitToWindow) {
        if (fitToWindow) {
            this.setFitToWindow();
        } else {
            this.resetFitToWindow();
        }
    }

    public void setFitToWindow() {
        if (!this.fitToWindow) {
            this.changeFitToWindow(true);
            this.changeTrackingEnd(false);
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isFitToWindow() {
        return this.fitToWindow;
    }

    public void setHorizontalAxisFont(Font horizontalAxisFont) {
        if (horizontalAxisFont != null && !this.horizontalAxisFont.equals(horizontalAxisFont)) {
            this.horizontalAxisFont = horizontalAxisFont;
            this.horizontalAxisFontSmall = horizontalAxisFont.deriveFont((float)(horizontalAxisFont.getSize() - 2));
        }
    }

    public Font getHorizontalAxisFont() {
        return this.horizontalAxisFont;
    }

    public void setHorizontalMeshPaint(Paint horizontalMeshPaint) {
        if (horizontalMeshPaint != null && !this.horizontalMeshPaint.equals(horizontalMeshPaint)) {
            this.horizontalMeshPaint = horizontalMeshPaint;
        }
    }

    public Paint getHorizontalMeshPaint() {
        return this.horizontalMeshPaint;
    }

    public void setHorizontalMeshStroke(Stroke horizontalMeshStroke) {
        if (horizontalMeshStroke != null && !this.horizontalMeshStroke.equals(horizontalMeshStroke)) {
            this.horizontalMeshStroke = horizontalMeshStroke;
        }
    }

    public Stroke getHorizontalMeshStroke() {
        return this.horizontalMeshStroke;
    }

    public int getIntBlockIncrement() {
        return (int)((double)(this.chartWidth - 20) * this.scrollBarLongToIntFactor);
    }

    public int getIntExtent() {
        return (int)((double)this.getRealExtent() * this.scrollBarLongToIntFactor);
    }

    public int getIntMaximum() {
        return (int)((double)this.getRealMaximum() * this.scrollBarLongToIntFactor);
    }

    public int getIntMinimum() {
        return 0;
    }

    public int getIntPosition() {
        return (int)((double)this.getRealPosition() * this.scrollBarLongToIntFactor);
    }

    public int getIntUnitIncrement() {
        return (int)(20.0 * this.scrollBarLongToIntFactor);
    }

    public int getLeadingItemIndexForPosition(int x) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return -1;
        }
        long timeAtPosition = (long)this.getXValueAtPosition(x);
        int itemIndex = this.lastLeadingItemIndex;
        if (this.model.getXValue(itemIndex) == timeAtPosition) {
            return itemIndex;
        }
        if (this.model.getXValue(itemIndex) < timeAtPosition) {
            for (int i = itemIndex; i < this.model.getItemCount() - 1; ++i) {
                if (this.model.getXValue(i + 1) <= timeAtPosition) continue;
                return i;
            }
            return -1;
        }
        for (int i = itemIndex; i >= 0; --i) {
            if (this.model.getXValue(i) >= timeAtPosition) continue;
            return i;
        }
        return -1;
    }

    public double getMaximumZoom() {
        return maximumZoom;
    }

    public boolean isMaximumZoom() {
        return this.viewScaleX >= maximumZoom;
    }

    public void setMinimumVerticalMarksDistance(int minimumVerticalMarksDistance) {
        this.minimumVerticalMarksDistance = minimumVerticalMarksDistance;
    }

    public int getMinimumVerticalMarksDistance() {
        return this.minimumVerticalMarksDistance;
    }

    public double getMinimumZoom() {
        if (this.model == null) {
            return 0.0;
        }
        return Math.min(this.initialZoom, (double)this.chartWidth * 0.1 / (double)(this.model.getMaxXValue() - this.model.getMinXValue()));
    }

    public boolean isMinimumZoom() {
        return this.viewScaleX <= this.getMinimumZoom();
    }

    public void setModel(SynchronousXYChartModel model) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (model != null) {
            model.addChartModelListener(this);
        }
        this.model = model;
        this.lastMinYs = new long[model.getSeriesCount()];
        this.lastMaxYs = new long[model.getSeriesCount()];
        this.dataOffsetsY = new long[model.getSeriesCount()];
        this.scaleFactorsY = new double[model.getSeriesCount()];
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    public SynchronousXYChartModel getModel() {
        return this.model;
    }

    public boolean isOverChart(Point point) {
        return this.isOverChart(point.x, point.y);
    }

    public boolean isOverChart(int x, int y) {
        Insets componentInsets = this.getInsets();
        return x >= componentInsets.left + this.chartInsets.left && x <= componentInsets.left + this.chartInsets.left + this.chartWidth && y >= componentInsets.top + this.chartInsets.top && y <= componentInsets.top + this.chartInsets.top + this.chartHeight;
    }

    public long getRealExtent() {
        return this.chartWidth;
    }

    public long getRealMaximum() {
        return this.dataViewWidth;
    }

    public long getRealMinimum() {
        return 0L;
    }

    public long getRealPosition() {
        return this.viewOffsetX;
    }

    public void setScale(double viewScaleX) {
        if (!this.fitToWindow) {
            if (this.isMinimumZoom() && viewScaleX < this.getMinimumZoom()) {
                return;
            }
            if (this.isMaximumZoom() && viewScaleX > this.getMaximumZoom()) {
                return;
            }
        }
        if (this.viewScaleX != viewScaleX) {
            double dataX = this.getViewToDataApproxX(this.chartInsets.left);
            this.changeZoom(viewScaleX);
            this.changeFitToWindow(false);
            this.changePan(Math.min((long)((double)(this.model.getMaxXValue() - this.model.getMinXValue()) * this.viewScaleX - (double)this.chartWidth), (long)((dataX - (double)this.dataOffsetX) * this.viewScaleX)));
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        } else {
            this.repaint();
        }
    }

    public double getScale() {
        return this.viewScaleX;
    }

    public void setScaleAndOffsetX(double viewScaleX, long viewOffsetX) {
        if (this.viewScaleX != viewScaleX || this.viewOffsetX != viewOffsetX) {
            this.changeZoom(viewScaleX);
            this.changePan(viewOffsetX);
            this.changeTrackingEnd(false);
            this.changeFitToWindow(false);
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isSelectionAllowed() {
        return this.allowSelection;
    }

    public void setSelectionTracksMovement(boolean selectionTracksMovement) {
        this.selectionTracksMovement = selectionTracksMovement;
    }

    public boolean getSelectionTracksMovement() {
        return this.selectionTracksMovement;
    }

    public String getTimeAtPosition(int x) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return null;
        }
        if (!this.useDayInTimeLegend) {
            return DateTimeAxisUtils.getMillisValue((long)this.getXValueAtPosition(x), false);
        }
        return DateTimeAxisUtils.getMillisValueFull((long)this.getXValueAtPosition(x));
    }

    public void setTopChartMargin(int topChartMargin) {
        if (this.topChartMargin != topChartMargin) {
            this.topChartMargin = topChartMargin;
        }
    }

    public int getTopChartMargin() {
        return this.topChartMargin;
    }

    public void setTrackingEnd(double viewScaleX) {
        if (this.viewScaleX != viewScaleX) {
            this.changeZoom(viewScaleX);
            this.lastScaleXValid = false;
        }
        this.setTrackingEnd();
    }

    public void setTrackingEnd(boolean trackingEnd) {
        if (trackingEnd) {
            this.setTrackingEnd();
        } else {
            this.resetTrackingEnd();
        }
    }

    public void setTrackingEnd() {
        if (!this.trackingEnd) {
            this.changeTrackingEnd(!this.trailingItemVisible || this.fitToWindow);
            this.lastViewOffsetXValid = false;
            if (this.fitToWindow && this.viewScaleX == 0.0) {
                this.dataWidthAtTrackingEndSwitch = this.model.getMaxXValue() - this.dataOffsetX;
            }
            this.changeFitToWindow(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isTrackingEnd() {
        return this.trackingEnd;
    }

    public void setUseSecondaryVerticalAxis(boolean useSecondaryVerticalAxis) {
        this.useSecondaryVerticalAxis = useSecondaryVerticalAxis;
        this.updateOffScreenImageSize();
    }

    public boolean getUseSecondaryVerticalAxis() {
        return this.useSecondaryVerticalAxis;
    }

    public void setVerticalAxisFont(Font verticalAxisFont) {
        if (verticalAxisFont != null && !this.verticalAxisFont.equals(verticalAxisFont)) {
            this.verticalAxisFont = verticalAxisFont;
        }
    }

    public Font getVerticalAxisFont() {
        return this.verticalAxisFont;
    }

    public void setVerticalAxisValueDivider(int verticalAxisValueDivider) {
        this.verticalAxisValueDivider = verticalAxisValueDivider;
    }

    public int getVerticalAxisValueDivider() {
        return this.verticalAxisValueDivider;
    }

    public void setVerticalAxisValueDivider2(int verticalAxisValueDivider2) {
        this.verticalAxisValueDivider2 = verticalAxisValueDivider2;
    }

    public int getVerticalAxisValueDivider2() {
        return this.verticalAxisValueDivider2;
    }

    public void setVerticalAxisValueString(String verticalAxisValueString) {
        this.verticalAxisValueString = verticalAxisValueString == null ? "" : verticalAxisValueString;
    }

    public String getVerticalAxisValueString() {
        return this.verticalAxisValueString;
    }

    public void setVerticalAxisValueString2(String verticalAxisValueString2) {
        this.verticalAxisValueString2 = verticalAxisValueString2 == null ? "" : verticalAxisValueString2;
    }

    public String getVerticalAxisValueString2() {
        return this.verticalAxisValueString2;
    }

    public void setVerticalMeshPaint(Paint verticalMeshPaint) {
        if (verticalMeshPaint != null && !this.verticalMeshPaint.equals(verticalMeshPaint)) {
            this.verticalMeshPaint = verticalMeshPaint;
        }
    }

    public Paint getVerticalMeshPaint() {
        return this.verticalMeshPaint;
    }

    public void setVerticalMeshStroke(Stroke verticalMeshStroke) {
        if (verticalMeshStroke != null && !this.verticalMeshStroke.equals(verticalMeshStroke)) {
            this.verticalMeshStroke = verticalMeshStroke;
        }
    }

    public Stroke getVerticalMeshStroke() {
        return this.verticalMeshStroke;
    }

    public void setViewOffsetX(long viewOffsetX) {
        if (this.viewOffsetX != viewOffsetX) {
            this.changePan(viewOffsetX);
            this.changeTrackingEnd(false);
            this.changeFitToWindow(false);
            this.lastViewOffsetXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public long getViewOffsetX() {
        return this.viewOffsetX;
    }

    public double getViewToDataApproxHeight(long height, int seriesIndex) {
        return 0.0;
    }

    public double getViewToDataApproxWidth(long width) {
        return (double)width / this.scaleFactorX;
    }

    public double getViewToDataApproxX(long xValue) {
        return (double)(xValue - (long)this.chartInsets.left + this.viewOffsetX) / this.scaleFactorX + (double)this.dataOffsetX;
    }

    public double getViewToDataApproxY(long yValue, int seriesIndex) {
        return 0.0;
    }

    public boolean isWithinData(int x) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return false;
        }
        int leadingItemIndex = this.getLeadingItemIndexForPosition(x);
        if (leadingItemIndex == -1) {
            return false;
        }
        return leadingItemIndex >= 0 && leadingItemIndex < this.model.getItemCount();
    }

    public long getYValueAtPosition(int x, int seriesIndex) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return -1L;
        }
        double positionTime = this.getXValueAtPosition(x);
        int leadingItemIndex = this.getLeadingItemIndexForPosition(x);
        int trailingItemIndex = leadingItemIndex + 1;
        if (trailingItemIndex == this.model.getItemCount()) {
            return -1L;
        }
        long leadingItemValue = this.model.getYValue(leadingItemIndex, seriesIndex);
        if (this.dataType == 51) {
            return leadingItemValue;
        }
        long trailingItemValue = this.model.getYValue(trailingItemIndex, seriesIndex);
        long leadingItemTime = this.model.getXValue(leadingItemIndex);
        long trailingItemTime = this.model.getXValue(trailingItemIndex);
        double interpolationFactor = (positionTime - (double)leadingItemTime) / (double)(trailingItemTime - leadingItemTime);
        return (long)((double)(trailingItemValue - leadingItemValue) * interpolationFactor) + leadingItemValue;
    }

    public synchronized void addChartActionListener(ChartActionListener chartActionListener) {
        if (this.chartActionListeners == null) {
            this.chartActionListeners = new Vector();
        }
        if (!this.chartActionListeners.contains(chartActionListener)) {
            this.chartActionListeners.add(chartActionListener);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.internalScrollBarChange) {
            this.internalScrollBarChange = false;
        } else if (this.autoTrackingEnd && e.getValue() + this.scrollBar.getModel().getExtent() == this.scrollBar.getMaximum()) {
            this.setTrackingEnd();
        } else {
            this.setViewOffsetX((long)((double)e.getValue() / this.scrollBarLongToIntFactor));
            if (!this.scrollBar.getValueIsAdjusting() && this.scrollBarValuesDirty) {
                this.scrollBarValuesDirty = false;
                this.updateScrollBarValues();
            }
        }
    }

    public void allowSelection() {
        this.allowSelection = true;
    }

    public void associateJScrollBar(JScrollBar scrollBar) {
        this.deassociateJScrollBar();
        if (scrollBar != null) {
            this.scrollBar = scrollBar;
            this.scrollBar.addAdjustmentListener(this);
            this.updateScrollBarValues();
        }
    }

    public void chartDataChanged() {
        this.limitYValue = this.model.getLimitYValue();
        this.limitYColor = this.model.getLimitYColor();
        this.updateScaleFactors();
        this.fireChartDataChanged();
        if (this.isShowing()) {
            if (this.trackingEnd && this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                return;
            }
            this.checkChartMargins();
            if (this.trackingEnd || this.fitToWindow || this.trailingItemVisible || !this.lastScaleYValid) {
                this.offScreenImageInvalid = true;
                this.doRepaint(false);
            }
        } else {
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.lastScaleYValid = false;
            this.lastTrailingItemIndexValid = false;
            this.lastLeadingItemIsForBuffer = false;
            this.lastLeadingItemIndex = 0;
            this.trailingItemVisible = true;
            this.scrollBarValuesDirty = true;
            this.offScreenImageInvalid = true;
            if (this.trackingEnd) {
                this.viewOffsetX = (long)(-this.chartWidth) + this.dataViewWidth;
            }
            if (!this.fitToWindow && this.model.getItemCount() > 1) {
                this.updateTrailingItemVisible();
            }
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.updateOffScreenImageSize();
    }

    public void componentShown(ComponentEvent e) {
    }

    public boolean containsValidData() {
        return this.model != null && this.model.getItemCount() > 1;
    }

    public void deassociateJScrollBar() {
        if (this.scrollBar != null) {
            this.scrollBar.removeAdjustmentListener(this);
        }
    }

    public void denySelection() {
        this.allowSelection = false;
    }

    public void fitToViewRectangle(int viewX, int viewY, int viewWidth, int viewHeight) {
        double dataX = this.getViewToDataApproxX(viewX - this.getInsets().left);
        double dataWidth = this.getViewToDataApproxWidth(viewWidth + 1);
        double newScaleX = (double)this.chartWidth / dataWidth;
        if (this.isMaximumZoom() && newScaleX > maximumZoom) {
            this.repaint();
            return;
        }
        this.changeZoom(newScaleX);
        this.changeFitToWindow(false);
        this.changePan((long)((dataX - (double)this.dataOffsetX) * this.viewScaleX));
        this.trackingEnd = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    public boolean hasValidDataForPosition(Point point) {
        return this.hasValidDataForPosition(point.x, point.y);
    }

    public boolean hasValidDataForPosition(int x, int y) {
        return this.isOverChart(x, y) && this.isWithinData(x);
    }

    public static void main(String[] args) {
        SynchronousXYChart xyChart = new SynchronousXYChart(2);
        xyChart.setBorder(BorderFactory.createEmptyBorder(15, 20, 35, 20));
        xyChart.setPreferredSize(new Dimension(600, 400));
        DynamicSynchronousXYChartModel xyChartModel = new DynamicSynchronousXYChartModel();
        xyChartModel.setupModel(new String[]{"Item 1", "Item 2", "Item 3"}, new Color[]{Color.RED, Color.GREEN, Color.BLUE});
        JFrame frame = new JFrame("SynchronousXYChart Tester");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)xyChart, "Center");
        JScrollBar scrollBar = new JScrollBar(0);
        xyChart.associateJScrollBar(scrollBar);
        frame.getContentPane().add((Component)scrollBar, "South");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        xyChartModel.addItemValues(0L, new long[]{30L, 20L, 10L});
        xyChartModel.addItemValues(5L, new long[]{45L, 38L, 20L});
        xyChartModel.addItemValues(20L, new long[]{62L, 61L, 30L});
        xyChartModel.addItemValues(50L, new long[]{90L, 80L, 48L});
        xyChart.setModel(xyChartModel);
    }

    public void setVerticalAxisValueAdaptDivider(boolean verticalAxisValueAdaptDivider) {
        this.verticalAxisValueAdaptDivider = verticalAxisValueAdaptDivider;
    }

    public boolean isVerticalAxisValueAdaptDivider() {
        return this.verticalAxisValueAdaptDivider;
    }

    public void setVerticalAxisValueAdaptDivider2(boolean verticalAxisValueAdaptDivider2) {
        this.verticalAxisValueAdaptDivider2 = verticalAxisValueAdaptDivider2;
    }

    public boolean isVerticalAxisValueAdaptDivider2() {
        return this.verticalAxisValueAdaptDivider2;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.allowSelection && this.mouseInProgress) {
            int mouseX = Math.min(this.insets.left + this.drawWidth - this.chartInsets.right - 1, e.getX());
            if (this.trailingItemVisible) {
                mouseX = Math.min(this.insets.left + (int)this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1)), mouseX);
            }
            int mouseY = Math.min(this.insets.top + this.drawHeight - this.chartInsets.bottom, e.getY());
            this.selectionWidth = mouseX - this.selectionX;
            this.selectionHeight = mouseY - this.selectionY - 1;
            this.doRepaint(false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return;
        }
        if (this.allowSelection && e.getButton() == 1) {
            boolean mouseYInChart;
            boolean mouseXInChart;
            int leftOffset = this.insets.left + this.chartInsets.left;
            int topOffset = this.insets.top + this.chartInsets.top;
            int mouseX = Math.max(leftOffset, e.getX());
            int mouseY = e.getY();
            boolean bl = mouseXInChart = mouseX < leftOffset + this.chartWidth;
            if (this.trailingItemVisible) {
                mouseXInChart = mouseXInChart && mouseX <= this.insets.left + (int)this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1));
            }
            boolean bl2 = mouseYInChart = mouseY >= topOffset && mouseY < topOffset + this.chartHeight;
            if (mouseXInChart && mouseYInChart) {
                this.selectionX = mouseX;
                this.selectionWidth = 0;
                this.selectionY = mouseY;
                this.selectionHeight = mouseY - this.selectionY - 1;
                this.mouseInProgress = true;
                this.doRepaint(false);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.allowSelection && this.mouseInProgress) {
            this.mouseInProgress = false;
            this.performSelectionDone();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model == null) {
            return;
        }
        if (this.offScreenImage == null) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        g.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
        if (this.allowSelection && this.mouseInProgress) {
            this.drawSelection((Graphics2D)g);
        }
    }

    public synchronized void removeChartActionListener(ChartActionListener chartActionListener) {
        if (this.chartActionListeners != null) {
            this.chartActionListeners.remove(chartActionListener);
        }
    }

    public void resetChart() {
        this.changeTrackingEnd(false);
        this.changeFitToWindow(false);
        this.changePan(0L);
        this.changeZoom(this.initialZoom);
        this.mouseInProgress = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.lastScaleYValid = false;
        this.lastLeadingItemIsForBuffer = false;
        this.lastLeadingItemIndex = 0;
        this.trailingItemVisible = true;
        this.scrollBarValuesDirty = true;
        this.offScreenImageInvalid = true;
        this.lastTrailingItemIndexValid = false;
        this.lastTrailingItemIndex = 0;
        this.useDayInTimeLegend = false;
        this.doRepaint(true);
    }

    public void resetFitToWindow() {
        if (this.fitToWindow) {
            this.changeFitToWindow(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public void resetTrackingEnd() {
        if (this.trackingEnd) {
            this.changeTrackingEnd(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public void setupInitialAppearance(long firstValueH, long lastValueH, long firstValueV, long lastValueV) {
        this.customizedEmptyAppearance = true;
        this.firstValueH = firstValueH;
        this.lastValueH = lastValueH;
        this.firstValueV = firstValueV;
        this.lastValueV = lastValueV;
    }

    public void update(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartDataChanged() {
        Vector toNotify;
        if (this.chartActionListeners == null) {
            return;
        }
        SynchronousXYChart synchronousXYChart = this;
        synchronized (synchronousXYChart) {
            toNotify = (Vector)this.chartActionListeners.clone();
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((ChartActionListener)iterator.next()).chartDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartFitToWindowChanged() {
        Vector toNotify;
        if (this.chartActionListeners == null) {
            return;
        }
        SynchronousXYChart synchronousXYChart = this;
        synchronized (synchronousXYChart) {
            toNotify = (Vector)this.chartActionListeners.clone();
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((ChartActionListener)iterator.next()).chartFitToWindowChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartPanned() {
        Vector toNotify;
        if (this.chartActionListeners == null) {
            return;
        }
        SynchronousXYChart synchronousXYChart = this;
        synchronized (synchronousXYChart) {
            toNotify = (Vector)this.chartActionListeners.clone();
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((ChartActionListener)iterator.next()).chartPanned();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartTrackingEndChanged() {
        Vector toNotify;
        if (this.chartActionListeners == null) {
            return;
        }
        SynchronousXYChart synchronousXYChart = this;
        synchronized (synchronousXYChart) {
            toNotify = (Vector)this.chartActionListeners.clone();
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((ChartActionListener)iterator.next()).chartTrackingEndChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartZoomed() {
        Vector toNotify;
        if (this.chartActionListeners == null) {
            return;
        }
        SynchronousXYChart synchronousXYChart = this;
        synchronized (synchronousXYChart) {
            toNotify = (Vector)this.chartActionListeners.clone();
        }
        Iterator iterator = toNotify.iterator();
        while (iterator.hasNext()) {
            ((ChartActionListener)iterator.next()).chartZoomed();
        }
    }

    private int getBottomHorizontalAxisLegendHeight() {
        return this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2 + 10;
    }

    private int getLeadingItemIndex(long offsetX) {
        for (int leadingItemIndex = 0; leadingItemIndex < this.model.getItemCount() - 1; ++leadingItemIndex) {
            if ((long)Math.ceil((double)(this.model.getXValue(leadingItemIndex + 1) - this.dataOffsetX) * this.viewScaleX) <= offsetX) continue;
            return leadingItemIndex;
        }
        return this.model.getItemCount() - 1;
    }

    private int getLeadingItemIndex(long offsetX, int lastLeadingItemIndex) {
        if (offsetX > this.lastViewOffsetX) {
            for (int leadingItemIndex = lastLeadingItemIndex; leadingItemIndex < this.model.getItemCount() - 1; ++leadingItemIndex) {
                if ((long)Math.ceil((double)(this.model.getXValue(leadingItemIndex + 1) - this.dataOffsetX) * this.viewScaleX) <= offsetX) continue;
                return leadingItemIndex;
            }
            return this.model.getItemCount() - 1;
        }
        for (int leadingItemIndex = lastLeadingItemIndex; leadingItemIndex >= 0; --leadingItemIndex) {
            if ((long)Math.ceil((double)(this.model.getXValue(leadingItemIndex) - this.dataOffsetX) * this.viewScaleX) >= offsetX) continue;
            return leadingItemIndex;
        }
        return 0;
    }

    private int getLeftVerticalAxisLegendWidth() {
        if (this.isVerticalAxisValueAdaptDivider()) {
            return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("2000M" + (this.getVerticalAxisValueString() != null ? this.getVerticalAxisValueString() : ""));
        }
        return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth(this.getVerticalAxisMarkString(this.model.getMaxDisplayYValue(0))) - 10;
    }

    private int getRightVerticalAxisLegendWidth() {
        if (this.useSecondaryVerticalAxis) {
            if (this.isVerticalAxisValueAdaptDivider2()) {
                return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("2000M" + (this.getVerticalAxisValueString2() != null ? this.getVerticalAxisValueString2() : ""));
            }
            return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth(this.getVerticalAxisMarkString2(this.model.getMaxDisplayYValue(1))) + 7;
        }
        return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("100") - 10;
    }

    private String getVerticalAxisMarkString(long mark) {
        return mark + this.verticalAxisValueString;
    }

    private String getVerticalAxisMarkString2(long mark) {
        return mark + this.verticalAxisValueString2;
    }

    private double getXValueAtPosition(int x) {
        return this.getViewToDataApproxX(x - this.getInsets().left);
    }

    private void changeFitToWindow(boolean newValue) {
        if (this.fitToWindow != newValue) {
            this.fitToWindow = newValue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartFitToWindowChanged();
                }
            });
        }
    }

    private void changePan(long newValue) {
        if (this.viewOffsetX != (newValue = Math.max(newValue, 0L))) {
            this.viewOffsetX = newValue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartPanned();
                }
            });
        }
    }

    private void changeTrackingEnd(boolean newValue) {
        if (this.trackingEnd != newValue) {
            this.trackingEnd = newValue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartTrackingEndChanged();
                }
            });
        }
    }

    private void changeZoom(double newValue) {
        if (!this.fitToWindow) {
            newValue = Math.max(newValue, this.getMinimumZoom());
            newValue = Math.min(newValue, this.getMaximumZoom());
        }
        if (this.viewScaleX != newValue) {
            this.viewScaleX = newValue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartZoomed();
                }
            });
        }
    }

    private boolean checkBottomChartMargin() {
        int bottomHorizontalAxisLegendHeight = this.getBottomHorizontalAxisLegendHeight();
        if (this.chartInsets.bottom < bottomHorizontalAxisLegendHeight) {
            this.chartInsets.bottom = bottomHorizontalAxisLegendHeight;
            return true;
        }
        return false;
    }

    private void checkChartMargins() {
        if (this.checkLeftChartMargin() || this.checkRightChartMargin()) {
            this.updateOffScreenImageSize();
        }
    }

    private boolean checkLeftChartMargin() {
        int leftVerticalAxisLegendWidth = this.getLeftVerticalAxisLegendWidth();
        if (this.chartInsets.left < leftVerticalAxisLegendWidth) {
            this.chartInsets.left = leftVerticalAxisLegendWidth;
            return true;
        }
        return false;
    }

    private boolean checkRightChartMargin() {
        int rightVerticalAxisLegendWidth = this.getRightVerticalAxisLegendWidth();
        if (this.chartInsets.right < rightVerticalAxisLegendWidth) {
            this.chartInsets.right = rightVerticalAxisLegendWidth;
            return true;
        }
        return false;
    }

    private void doRepaint(boolean rescale) {
        this.scaleFactorsNeedUpdate = rescale;
        this.repaint();
    }

    private void drawChart(Graphics2D g2) {
        if (this.model.getItemCount() < 2) {
            if (this.customizedEmptyAppearance) {
                this.drawChartLegendEmpty(g2);
            }
            return;
        }
        if (this.scaleFactorsNeedUpdate) {
            this.updateScaleFactors();
        }
        if (this.fitToWindow) {
            this.drawChartFitToWindow(g2);
        } else {
            this.drawChartFromCurrentViewOffsetX(g2);
        }
        this.offScreenImageInvalid = false;
    }

    private void drawChartFitToWindow(Graphics2D g2) {
        Shape clip = g2.getClip();
        g2.setClip(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        int thresholdY = Integer.MAX_VALUE;
        if (this.limitYValue != Long.MAX_VALUE) {
            thresholdY = (int)this.getDataToViewY(this.limitYValue, 0);
        }
        if (thresholdY != Integer.MAX_VALUE && thresholdY >= this.chartInsets.top) {
            g2.setPaint(this.limitYColor);
            g2.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, thresholdY - this.chartInsets.top + 1);
            g2.setPaint(this.chartPaint);
            g2.fillRect(this.chartInsets.left, thresholdY + 1, this.chartWidth, this.chartHeight - thresholdY + this.chartInsets.top);
        } else {
            g2.setPaint(this.chartPaint);
            g2.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        }
        if (this.model instanceof AsyncMarksProvider) {
            AsyncMarksProvider amp = (AsyncMarksProvider)((Object)this.model);
            Color markColor = amp.getMarkColor();
            int marksCount = amp.getMarksCount();
            int lastXEnd = Integer.MIN_VALUE;
            for (int i = 0; i < marksCount; ++i) {
                long markBegin = amp.getMarkStart(i);
                long markEnd = amp.getMarkEnd(i);
                int xBegin = (int)this.getDataToViewX(markBegin);
                int xEnd = Math.max((int)this.getDataToViewX(markEnd), xBegin + 1);
                if (xEnd <= lastXEnd) continue;
                int xWidth = xEnd - (xBegin = Math.max(xBegin, lastXEnd));
                if (xWidth > 0) {
                    g2.setColor(markColor);
                    g2.fillRect(xBegin, this.chartInsets.top, xEnd - xBegin, this.chartHeight);
                }
                lastXEnd = xEnd;
            }
        }
        for (int itemIndex = 1; itemIndex < this.model.getItemCount(); ++itemIndex) {
            long startX = this.getDataToViewX(this.model.getXValue(itemIndex - 1));
            long endX = this.getDataToViewX(this.model.getXValue(itemIndex));
            for (int seriesIndex = 0; seriesIndex < this.model.getSeriesCount(); ++seriesIndex) {
                this.drawSeriesItem(g2, this.model.getSeriesColor(seriesIndex), startX, this.getDataToViewY(this.model.getYValue(itemIndex - 1, seriesIndex), seriesIndex), endX, this.getDataToViewY(this.model.getYValue(itemIndex, seriesIndex), seriesIndex));
            }
        }
        this.drawChartLegend(g2, g2.getClip(), 0, this.chartWidth - 1);
        g2.setClip(clip);
    }

    private void drawChartFromCurrentViewOffsetX(Graphics2D g2) {
        this.drawChartFromOffset(g2, this.viewOffsetX);
    }

    private void drawChartFromOffset(Graphics2D g2, long offsetX) {
        Shape clip = g2.getClip();
        if (this.lastViewOffsetXValid) {
            if (this.trailingItemVisible || !this.lastScaleYValid) {
                int leadingItemIndex = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(offsetX) : (this.lastScaleYValid && this.lastTrailingItemIndexValid ? this.lastTrailingItemIndex : this.getLeadingItemIndex(offsetX, this.lastLeadingItemIndex));
                this.drawChartFromOffset(g2, leadingItemIndex, (int)this.getDataToViewX(this.model.getXValue(leadingItemIndex)) - this.chartInsets.left, this.chartWidth);
                if (this.lastLeadingItemIsForBuffer) {
                    this.lastLeadingItemIndex = leadingItemIndex;
                }
                this.lastLeadingItemIsForBuffer = false;
                this.lastTrailingItemIndex = this.model.getItemCount() - 1;
                this.lastTrailingItemIndexValid = true;
                if (this.trackingEnd) {
                    this.lastViewOffsetXValid = false;
                }
            } else {
                this.lastTrailingItemIndexValid = false;
            }
        } else {
            this.lastTrailingItemIndexValid = false;
            if (this.lastScaleXValid) {
                if (this.lastScaleYValid) {
                    if (this.viewOffsetX > this.lastViewOffsetX) {
                        int dirtyWidth = (int)(this.viewOffsetX - this.lastViewOffsetX);
                        int copyWidth = (int)(this.trailingItemVisible ? this.getDataToViewX(this.model.getMaxXValue()) : (long)(this.chartWidth - dirtyWidth));
                        if (copyWidth > 0 && dirtyWidth > 0 && this.chartHeight > 0) {
                            if (this.copyAccel == 101) {
                                int rasterWidth = this.offScreenImage.getRaster().getWidth();
                                int rasterHeight = this.offScreenImage.getRaster().getHeight();
                                int startX = this.chartInsets.left + dirtyWidth;
                                int startY = this.chartInsets.top;
                                if (startX >= 0 && startX + copyWidth <= rasterWidth && startY >= 0 && startY + this.chartHeight <= rasterHeight && this.chartInsets.left >= 0 && this.chartInsets.left + copyWidth <= rasterWidth && this.chartInsets.top >= 0 && this.chartInsets.top + this.chartHeight <= rasterHeight) {
                                    WritableRaster raster = this.offScreenImage.getRaster().createWritableChild(startX, startY, copyWidth, this.chartHeight, 0, 0, null);
                                    this.offScreenImage.getRaster().setDataElements(this.chartInsets.left, this.chartInsets.top, raster);
                                }
                            } else {
                                g2.copyArea(this.chartInsets.left + dirtyWidth, this.chartInsets.top, copyWidth, this.chartHeight, -dirtyWidth, 0);
                            }
                        }
                        if (this.selectionTracksMovement && this.mouseInProgress && this.trackingEnd) {
                            int delta = Math.min(this.selectionX - this.chartInsets.left - this.getInsets().left, dirtyWidth);
                            this.selectionX -= delta;
                            this.selectionWidth += delta;
                        }
                        int leadingItemIndex = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(offsetX + (long)copyWidth, this.lastLeadingItemIndex) : this.getLeadingItemIndex(offsetX);
                        this.drawChartFromOffset(g2, leadingItemIndex, copyWidth, this.chartWidth);
                        this.lastLeadingItemIsForBuffer = true;
                        this.lastLeadingItemIndex = leadingItemIndex;
                    } else {
                        int dirtyWidth = (int)(this.lastViewOffsetX - this.viewOffsetX);
                        int copyWidth = this.chartWidth - dirtyWidth;
                        if (copyWidth > 0 && dirtyWidth > 0 && this.chartHeight > 0) {
                            if (this.copyAccel == 101) {
                                int rasterWidth = this.offScreenImage.getRaster().getWidth();
                                int rasterHeight = this.offScreenImage.getRaster().getHeight();
                                int startX = this.chartInsets.left + dirtyWidth;
                                int startY = this.chartInsets.top;
                                if (startX >= 0 && startX + copyWidth <= rasterWidth && startY >= 0 && startY + this.chartHeight <= rasterHeight && this.chartInsets.left >= 0 && this.chartInsets.left + copyWidth <= rasterWidth && this.chartInsets.top >= 0 && this.chartInsets.top + this.chartHeight <= rasterHeight) {
                                    WritableRaster raster = this.offScreenImage.getRaster().createWritableChild(this.chartInsets.left, this.chartInsets.top, copyWidth, this.chartHeight, 0, 0, null);
                                    this.offScreenImage.getRaster().setDataElements(startX, startY, raster);
                                }
                            } else {
                                g2.copyArea(this.chartInsets.left, this.chartInsets.top, copyWidth, this.chartHeight, dirtyWidth, 0);
                            }
                        }
                        int leadingItemIndex = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(offsetX, this.lastLeadingItemIndex) : this.getLeadingItemIndex(offsetX);
                        this.drawChartFromOffset(g2, leadingItemIndex, 0, dirtyWidth);
                        this.lastLeadingItemIsForBuffer = true;
                        this.lastLeadingItemIndex = leadingItemIndex;
                    }
                } else {
                    int leadingItemIndex = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(offsetX) : this.getLeadingItemIndex(offsetX, this.lastLeadingItemIndex);
                    this.drawChartFromOffset(g2, leadingItemIndex, 0, this.chartWidth);
                    this.lastLeadingItemIsForBuffer = false;
                    this.lastLeadingItemIndex = leadingItemIndex;
                }
            } else {
                int leadingItemIndex = this.getLeadingItemIndex(offsetX);
                this.drawChartFromOffset(g2, leadingItemIndex, 0, this.chartWidth);
                this.lastLeadingItemIsForBuffer = false;
                this.lastLeadingItemIndex = leadingItemIndex;
            }
        }
        this.lastViewOffsetX = offsetX;
        this.lastViewOffsetXValid = true;
        this.lastScaleXValid = true;
        this.lastScaleYValid = true;
        this.updateTrailingItemVisible();
        g2.setClip(clip);
    }

    private void drawChartFromOffset(Graphics2D g2, int leadingItemIndex, int startClipX, int endClipX) {
        startClipX = Math.max(0, startClipX);
        endClipX = Math.min(this.chartWidth, endClipX);
        g2.setClip(this.chartInsets.left + startClipX, this.chartInsets.top, endClipX - startClipX, this.chartHeight);
        int thresholdY = Integer.MAX_VALUE;
        if (this.limitYValue != Long.MAX_VALUE) {
            thresholdY = (int)this.getDataToViewY(this.limitYValue, 0);
        }
        if (thresholdY != Integer.MAX_VALUE && thresholdY >= this.chartInsets.top) {
            g2.setPaint(this.limitYColor);
            g2.fillRect(this.chartInsets.left + startClipX, this.chartInsets.top, endClipX - startClipX, thresholdY - this.chartInsets.top + 1);
            g2.setPaint(this.chartPaint);
            g2.fillRect(this.chartInsets.left + startClipX, thresholdY + 1, endClipX - startClipX, this.chartHeight - thresholdY + this.chartInsets.top);
        } else {
            g2.setPaint(this.chartPaint);
            g2.fillRect(this.chartInsets.left + startClipX, this.chartInsets.top, endClipX - startClipX, this.chartHeight);
        }
        if (this.model instanceof AsyncMarksProvider) {
            AsyncMarksProvider amp = (AsyncMarksProvider)((Object)this.model);
            Color markColor = amp.getMarkColor();
            int marksCount = amp.getMarksCount();
            int lastXEnd = Integer.MIN_VALUE;
            long firstMarkTime = this.model.getXValue(leadingItemIndex);
            for (int i = 0; i < marksCount; ++i) {
                long markEnd = amp.getMarkEnd(i);
                if (markEnd < firstMarkTime) continue;
                long markBegin = amp.getMarkStart(i);
                int xBegin = (int)this.getDataToViewX(markBegin);
                if (xBegin > this.chartInsets.left + endClipX + 1) break;
                int xEnd = Math.max((int)this.getDataToViewX(markEnd), xBegin + 1);
                if (xEnd <= lastXEnd) continue;
                int xWidth = xEnd - (xBegin = Math.max(xBegin, lastXEnd));
                if (xWidth > 0) {
                    g2.setColor(markColor);
                    g2.fillRect(xBegin, this.chartInsets.top, xEnd - xBegin, this.chartHeight);
                }
                lastXEnd = xEnd;
            }
        }
        leadingItemIndex = this.type == 1 ? Math.max(0, leadingItemIndex - 1) : leadingItemIndex;
        for (int itemIndex = leadingItemIndex + 1; itemIndex < this.model.getItemCount(); ++itemIndex) {
            long startX = this.getDataToViewX(this.model.getXValue(itemIndex - 1));
            long endX = this.getDataToViewX(this.model.getXValue(itemIndex));
            for (int seriesIndex = 0; seriesIndex < this.model.getSeriesCount(); ++seriesIndex) {
                this.drawSeriesItem(g2, this.model.getSeriesColor(seriesIndex), startX, this.getDataToViewY(this.model.getYValue(itemIndex - 1, seriesIndex), seriesIndex), endX, this.getDataToViewY(this.model.getYValue(itemIndex, seriesIndex), seriesIndex));
            }
            if (endX > (long)(this.chartInsets.left + endClipX + 1)) break;
        }
        this.drawChartLegend(g2, g2.getClip(), startClipX, endClipX);
    }

    private void drawChartLegend(Graphics2D g2, Shape chartClip, int startClipX, int endClipX) {
        long firstValueH = (long)this.getViewToDataApproxWidth(this.viewOffsetX) + this.model.getMinXValue();
        long lastValueH = (long)this.getViewToDataApproxWidth(this.viewOffsetX + (long)this.chartWidth) + this.model.getMinXValue();
        this.drawHorizontalChartLegend(g2, chartClip, startClipX, endClipX, firstValueH, lastValueH);
        double firstValueV = (double)this.model.getMinDisplayYValue(0) / (double)this.verticalAxisValueDivider;
        double lastValueV = (double)this.model.getMaxDisplayYValue(0) / (double)this.verticalAxisValueDivider;
        this.drawVerticalChartLegend(g2, chartClip, startClipX, endClipX, firstValueV, lastValueV);
    }

    private void drawChartLegendEmpty(Graphics2D g2) {
        Shape clip = g2.getClip();
        g2.setClip(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        Shape newClip = g2.getClip();
        g2.setPaint(this.chartPaint);
        g2.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        this.drawHorizontalChartLegend(g2, newClip, 0, this.chartWidth - 1, this.firstValueH, this.lastValueH);
        this.drawVerticalChartLegend(g2, newClip, 0, this.chartWidth - 1, this.firstValueV, this.lastValueV);
        g2.setClip(clip);
    }

    private void drawFillSeriesItem(Graphics2D g2, Color color, int x1, int y1, int x2, int y2) {
        g2.setColor(color);
        g2.setStroke(this.chartStroke);
        if (this.dataType == 50) {
            Polygon polygon = new Polygon(new int[]{x1, x1, x2, x2}, new int[]{y1, this.chartHeight + this.chartInsets.top, this.chartHeight + this.chartInsets.top, y2}, 4);
            g2.fill(polygon);
        } else if (this.dataType == 51) {
            Polygon polygon = new Polygon(new int[]{x1, x1, x2, x2}, new int[]{y1, this.chartHeight + this.chartInsets.top, this.chartHeight + this.chartInsets.top, y1}, 4);
            g2.fill(polygon);
        }
    }

    private void drawHorizontalAxisLegendSegment(Graphics2D g2, long currentMark, int x) {
        g2.setClip(this.horizontalAxisMarksClip);
        g2.setPaint(this.horizontalAxisPaint);
        g2.drawLine(x, this.chartInsets.top + this.chartHeight + 1, x, this.chartInsets.top + this.chartHeight + 4);
        g2.setClip(this.horizontalAxisClip);
        this.paintHorizontalTimeMarkString(g2, currentMark, x);
    }

    private void drawHorizontalChartLegend(Graphics2D g2, Shape chartClip, int startClipX, int endClipX, long firstValue, long lastValue) {
        g2.setClip(this.horizontalAxisMarksClip);
        g2.setPaint(this.backgroundPaint);
        g2.fillRect(this.horizontalAxisMarksClip.x, this.horizontalAxisMarksClip.y, this.horizontalAxisMarksClip.width, this.horizontalAxisMarksClip.height);
        g2.setClip(this.horizontalAxisClip);
        g2.setPaint(this.backgroundPaint);
        g2.fillRect(this.horizontalAxisClip.x, this.horizontalAxisClip.y, this.horizontalAxisClip.width, this.horizontalAxisClip.height);
        if (lastValue - firstValue > 0L) {
            long firstMark;
            double factor = (double)this.chartWidth / (double)(lastValue - firstValue);
            this.optimalUnits = DateTimeAxisUtils.getOptimalUnits(this.viewScaleX);
            for (long currentMark = firstMark = Math.max(firstValue / this.optimalUnits * this.optimalUnits, 0L); currentMark <= lastValue; currentMark += this.optimalUnits) {
                if (currentMark < firstValue) continue;
                long currentMarkRel = currentMark - firstValue;
                int markPosition = (int)Math.floor((double)currentMarkRel * factor) + this.chartInsets.left;
                this.drawVerticalMeshSegment(g2, chartClip, markPosition, this.chartInsets.top, markPosition, this.chartInsets.top + this.chartHeight);
                this.drawHorizontalAxisLegendSegment(g2, currentMark, markPosition);
            }
        }
    }

    private void drawHorizontalMeshSegment(Graphics2D g2, Shape chartClip, int x1, int y1, int x2, int y2) {
        g2.setClip(chartClip);
        g2.setPaint(this.verticalMeshPaint);
        g2.setStroke(this.verticalMeshStroke);
        g2.drawLine(x1, y1, x2, y2);
    }

    private void drawLineSeriesItem(Graphics2D g2, Color color, int x1, int y1, int x2, int y2) {
        g2.setColor(color);
        g2.setStroke(this.chartStroke);
        if (this.dataType == 50) {
            g2.drawLine(x1, y1, x2, y2);
        } else if (this.dataType == 51) {
            g2.drawLine(x1, y1, x2, y1);
            g2.drawLine(x2, y1, x2, y2);
        }
    }

    private void drawSelection(Graphics2D g2) {
        int selectionTop = this.insets.top + this.chartInsets.top;
        int selectionBottom = selectionTop + this.chartHeight - 1;
        if (this.selectionWidth < 0) {
            if (this.fitToWindow) {
                return;
            }
            Shape clip = g2.getClip();
            Insets componentInsets = this.getInsets();
            g2.setClip(componentInsets.left, componentInsets.top, this.drawWidth, this.drawHeight);
            g2.setFont(this.getFont());
            g2.setColor(this.evenSelectionSegmentsColor);
            g2.setStroke(this.evenSelectionSegmentsStroke);
            g2.drawLine(this.selectionX, selectionTop, this.selectionX, selectionBottom);
            g2.setColor(this.oddSelectionSegmentColor);
            g2.setStroke(this.oddSelectionSegmentStroke);
            g2.drawLine(this.selectionX, selectionTop, this.selectionX, selectionBottom);
            g2.setColor(Color.WHITE);
            g2.drawString(FIT_TO_WINDOW_STRING, this.selectionX + this.selectionWidth + 1, this.selectionY + this.selectionHeight + 1 - 5);
            g2.setColor(Color.BLACK);
            g2.drawString(FIT_TO_WINDOW_STRING, this.selectionX + this.selectionWidth, this.selectionY + this.selectionHeight - 5);
            g2.setClip(clip);
            return;
        }
        g2.setColor(this.evenSelectionSegmentsColor);
        g2.setStroke(this.evenSelectionSegmentsStroke);
        g2.drawLine(this.selectionX, selectionTop, this.selectionX + this.selectionWidth, selectionTop);
        g2.drawLine(this.selectionX + this.selectionWidth, selectionTop, this.selectionX + this.selectionWidth, selectionBottom);
        g2.drawLine(this.selectionX, selectionBottom, this.selectionX + this.selectionWidth, selectionBottom);
        g2.drawLine(this.selectionX, selectionTop, this.selectionX, selectionBottom);
        g2.setColor(this.oddSelectionSegmentColor);
        g2.setStroke(this.oddSelectionSegmentStroke);
        g2.drawLine(this.selectionX, selectionTop, this.selectionX + this.selectionWidth, selectionTop);
        g2.drawLine(this.selectionX + this.selectionWidth, selectionTop, this.selectionX + this.selectionWidth, selectionBottom);
        g2.drawLine(this.selectionX, selectionBottom, this.selectionX + this.selectionWidth, selectionBottom);
        g2.drawLine(this.selectionX, selectionTop, this.selectionX, selectionBottom);
    }

    private void drawSeriesItem(Graphics2D g2, Color color, long x1, long y1, long x2, long y2) {
        if (Math.abs(x1) > 1000000L || Math.abs(x2) > 1000000L) {
            x1 = Math.max(-1000000L, x1);
            x1 = Math.min(1000000L, x1);
            x2 = Math.max(-1000000L, x2);
            x2 = Math.min(1000000L, x2);
        }
        if (this.type == 2) {
            this.drawFillSeriesItem(g2, color, (int)x1, (int)y1, (int)x2, (int)y2);
        } else if (this.type == 1) {
            this.drawLineSeriesItem(g2, color, (int)x1, (int)y1, (int)x2, (int)y2);
        }
    }

    private void drawVerticalAxisLegendSegment(Graphics2D g2, long currentMark, long optimalUnits, int y) {
        if ("%".equals(this.verticalAxisValueString) && currentMark > 100L) {
            return;
        }
        g2.setClip(this.verticalAxisClip);
        g2.setPaint(this.verticalAxisPaint);
        g2.drawLine(this.chartInsets.left - 4, y, this.chartInsets.left, y);
        this.paintVerticalTimeMarkString(g2, currentMark, optimalUnits, y);
    }

    private void drawVerticalAxisLegendSegment2(Graphics2D g2, long currentMark, long optimalUnits, int y) {
        if ("%".equals(this.verticalAxisValueString2) && currentMark > 100L) {
            return;
        }
        g2.setClip(this.verticalAxisClip2);
        g2.setPaint(this.verticalAxisPaint);
        g2.drawLine(this.chartInsets.left + this.chartWidth, y, this.chartInsets.left + this.chartWidth + 3, y);
        this.paintVerticalTimeMarkString2(g2, currentMark, optimalUnits, y);
    }

    private void drawVerticalChartLegend(Graphics2D g2, Shape chartClip, int startClipX, int endClipX, double firstValue, double lastValue) {
        int markPosition;
        double currentMarkRel;
        long currentMark;
        long firstMark;
        double factor;
        if (!this.lastScaleYValid) {
            g2.setClip(this.verticalAxisClip);
            g2.setPaint(this.backgroundPaint);
            g2.fillRect(this.verticalAxisClip.x, this.verticalAxisClip.y, this.verticalAxisClip.width, this.verticalAxisClip.height);
        }
        long div = this.verticalAxisValueDivider;
        String tmp = this.verticalAxisValueString;
        if (this.verticalAxisValueAdaptDivider) {
            if (this.model.getMaxDisplayYValue(0) > 2000000000L && div < 0x40000000L) {
                div = 0x40000000L;
                this.verticalAxisValueString = "G" + this.verticalAxisValueString;
            } else if (this.model.getMaxDisplayYValue(0) > 2000000L && div < 0x100000L) {
                div = 0x100000L;
                this.verticalAxisValueString = "M" + this.verticalAxisValueString;
            } else if (this.model.getMaxDisplayYValue(0) > 2000L && div < 1024L) {
                div = 1024L;
                this.verticalAxisValueString = "K" + this.verticalAxisValueString;
            }
            firstValue /= (double)div;
            lastValue /= (double)div;
        }
        if (lastValue - firstValue > 0.0) {
            factor = (double)(this.chartHeight - this.topChartMargin) / (lastValue - firstValue);
            this.optimalUnits = DecimalAxisUtils.getOptimalUnits(factor, this.minimumVerticalMarksDistance);
            if (this.optimalUnits > 0L) {
                currentMark = firstMark = Math.max((long)(Math.ceil(firstValue / (double)this.optimalUnits) * (double)this.optimalUnits), 0L);
                currentMarkRel = (double)currentMark - firstValue;
                markPosition = this.chartInsets.top + this.chartHeight - (int)(currentMarkRel * factor);
                while (markPosition >= this.chartInsets.top) {
                    if (markPosition <= this.chartInsets.top + this.chartHeight) {
                        this.drawHorizontalMeshSegment(g2, chartClip, startClipX + this.chartInsets.left, markPosition, endClipX + this.chartInsets.left, markPosition);
                        if (!this.lastScaleYValid) {
                            this.drawVerticalAxisLegendSegment(g2, currentMark, this.optimalUnits, markPosition);
                        }
                    }
                    currentMarkRel = (double)(currentMark += this.optimalUnits) - firstValue;
                    markPosition = this.chartInsets.top + this.chartHeight - (int)(currentMarkRel * factor);
                }
            }
        }
        this.verticalAxisValueString = tmp;
        if (this.useSecondaryVerticalAxis && !this.lastScaleYValid) {
            g2.setClip(this.verticalAxisClip2);
            g2.setPaint(this.backgroundPaint);
            g2.fillRect(this.verticalAxisClip2.x, this.verticalAxisClip2.y, this.verticalAxisClip2.width, this.verticalAxisClip2.height);
            div = this.verticalAxisValueDivider2;
            tmp = this.verticalAxisValueString2;
            if (this.isVerticalAxisValueAdaptDivider2()) {
                if (this.model.getMaxDisplayYValue(1) > 2000000000L && div < 0x40000000L) {
                    div = 0x40000000L;
                    this.verticalAxisValueString2 = "G" + this.verticalAxisValueString2;
                } else if (this.model.getMaxDisplayYValue(1) > 2000000L && div < 0x100000L) {
                    div = 0x100000L;
                    this.verticalAxisValueString2 = "M" + this.verticalAxisValueString2;
                } else if (this.model.getMaxDisplayYValue(1) > 2000L && div < 1024L) {
                    div = 1024L;
                    this.verticalAxisValueString2 = "K" + this.verticalAxisValueString2;
                }
            }
            firstValue = (double)this.model.getMinDisplayYValue(1) / (double)div;
            lastValue = (double)this.model.getMaxDisplayYValue(1) / (double)div;
            if (lastValue - firstValue > 0.0) {
                factor = (double)(this.chartHeight - this.topChartMargin) / (lastValue - firstValue);
                this.optimalUnits = DecimalAxisUtils.getOptimalUnits(factor, this.minimumVerticalMarksDistance);
                if (this.optimalUnits > 0L) {
                    currentMark = firstMark = Math.max((long)(Math.ceil(firstValue / (double)this.optimalUnits) * (double)this.optimalUnits), 0L);
                    currentMarkRel = (double)currentMark - firstValue;
                    markPosition = this.chartInsets.top + this.chartHeight - (int)(currentMarkRel * factor);
                    while (markPosition >= this.chartInsets.top) {
                        if (markPosition <= this.chartInsets.top + this.chartHeight) {
                            this.drawVerticalAxisLegendSegment2(g2, currentMark, this.optimalUnits, markPosition);
                        }
                        currentMarkRel = (double)(currentMark += this.optimalUnits) - firstValue;
                        markPosition = this.chartInsets.top + this.chartHeight - (int)(currentMarkRel * factor);
                    }
                }
            }
            this.verticalAxisValueString2 = tmp;
        }
    }

    private void drawVerticalMeshSegment(Graphics2D g2, Shape chartClip, int x1, int y1, int x2, int y2) {
        g2.setClip(chartClip);
        g2.setPaint(this.verticalMeshPaint);
        g2.setStroke(this.verticalMeshStroke);
        g2.drawLine(x1, y1, x2, y2);
    }

    private void fitToSelection() {
        this.fitToViewRectangle(this.selectionX, this.selectionY, this.selectionWidth, this.selectionHeight);
    }

    private void fitToWindow() {
        this.dataViewWidth = this.chartWidth;
        this.changeZoom((double)this.chartWidth / (double)(this.model.getMaxXValue() - this.dataOffsetX));
        this.lastScaleXValid = false;
        this.changePan(0L);
        this.lastViewOffsetXValid = false;
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    private void paintHorizontalTimeMarkString(Graphics2D g2, long currentMark, int x) {
        int y = this.chartInsets.top + this.chartHeight + this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2;
        int markStringMillisMargin = 0;
        int markStringMillisReduce = 2;
        String markStringNoMillis = DateTimeAxisUtils.getTimeMarkNoMillisString(currentMark, this.optimalUnits, this.useDayInTimeLegend);
        int wMarkStringNoMillis = g2.getFontMetrics(this.horizontalAxisFont).stringWidth(markStringNoMillis);
        String markStringMillis = DateTimeAxisUtils.getTimeMarkMillisString(currentMark, this.optimalUnits);
        if (!markStringMillis.equals("")) {
            markStringMillis = "." + markStringMillis;
        }
        int wMarkStringMillis = g2.getFontMetrics(this.horizontalAxisFontSmall).stringWidth(markStringMillis);
        int xMarkStringNoMillis = x - (wMarkStringNoMillis + wMarkStringMillis) / 2 + 1;
        int xMarkStringMillis = xMarkStringNoMillis + wMarkStringNoMillis + markStringMillisMargin;
        g2.setFont(this.horizontalAxisFont);
        g2.drawString(markStringNoMillis, xMarkStringNoMillis, y);
        g2.setFont(this.horizontalAxisFontSmall);
        g2.drawString(markStringMillis, xMarkStringMillis, y - markStringMillisReduce + 1);
    }

    private void paintVerticalTimeMarkString(Graphics2D g2, long currentMark, long optimalUnits, int y) {
        String currentMarkString = this.getVerticalAxisMarkString(currentMark);
        int currentMarkWidth = g2.getFontMetrics(this.verticalAxisFont).stringWidth(currentMarkString);
        int currentMarkX = this.chartInsets.left - currentMarkWidth - 6;
        int currentMarkY = y + this.verticalAxisFont.getSize() / 2 - 2;
        if (this.useSecondaryVerticalAxis) {
            g2.setPaint(this.model.getSeriesColor(0));
        }
        g2.setFont(this.verticalAxisFont);
        g2.drawString(currentMarkString, currentMarkX, currentMarkY);
    }

    private void paintVerticalTimeMarkString2(Graphics2D g2, long currentMark, long optimalUnits, int y) {
        if (currentMark > this.model.getMaxDisplayYValue(1)) {
            return;
        }
        String currentMarkString = this.getVerticalAxisMarkString2(currentMark);
        int currentMarkX = this.chartInsets.left + this.chartWidth + 6;
        int currentMarkY = y + this.verticalAxisFont.getSize() / 2 - 2;
        g2.setPaint(this.model.getSeriesColor(1));
        g2.setFont(this.verticalAxisFont);
        g2.drawString(currentMarkString, currentMarkX, currentMarkY);
    }

    private void performSelectionDone() {
        if (this.selectionWidth > 0) {
            this.fitToSelection();
        } else if (this.selectionWidth < 0) {
            this.fitToWindow();
        } else {
            this.doRepaint(false);
        }
    }

    private void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right - 1;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        if (this.drawWidth > 0 && this.drawHeight > 0) {
            this.offScreenImage = (BufferedImage)this.createImage(this.drawWidth + 1, this.drawHeight + 1);
            this.offScreenGraphics = this.offScreenImage.createGraphics();
            this.chartInsets.top = 20;
            if (this.useSecondaryVerticalAxis) {
                this.checkRightChartMargin();
            } else {
                this.chartInsets.right = 0;
            }
            this.chartInsets.bottom = this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2 + 8;
            this.chartInsets.left = this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("MMMMM");
            this.chartWidth = this.drawWidth - this.chartInsets.left - this.chartInsets.right;
            this.chartHeight = this.drawHeight - this.chartInsets.top - this.chartInsets.bottom;
            Area chartArea = new Area(new Rectangle(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight));
            Area componentArea = new Area(new Rectangle(0, 0, this.drawWidth + 1, this.drawHeight + 1));
            componentArea.subtract(chartArea);
            this.offScreenGraphics.setPaint(this.backgroundPaint);
            this.offScreenGraphics.fill(componentArea);
            this.offScreenGraphics.setPaint(this.chartPaint);
            this.offScreenGraphics.fill(chartArea);
            this.offScreenGraphics.setPaint(this.horizontalAxisPaint);
            this.offScreenGraphics.setStroke(this.horizontalAxisStroke);
            this.offScreenGraphics.drawLine(this.chartInsets.left, this.chartInsets.top + this.chartHeight, this.chartInsets.left + this.chartWidth - 1, this.chartInsets.top + this.chartHeight);
            this.offScreenGraphics.setPaint(this.verticalAxisPaint);
            this.offScreenGraphics.setStroke(this.verticalAxisStroke);
            this.offScreenGraphics.drawLine(this.chartInsets.left - 1, this.chartInsets.top, this.chartInsets.left - 1, this.chartInsets.top + this.chartHeight);
            if (this.useSecondaryVerticalAxis) {
                this.offScreenGraphics.drawLine(this.chartInsets.left + this.chartWidth, this.chartInsets.top, this.chartInsets.left + this.chartWidth, this.chartInsets.top + this.chartHeight);
            }
            this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.offScreenImageInvalid = true;
            this.lastScaleYValid = false;
            this.trailingItemVisible = true;
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.horizontalAxisMarksClip.setRect(this.chartInsets.left - 1, this.chartInsets.top + this.chartHeight + 1, this.chartWidth + 1, 3.0);
            this.horizontalAxisClip.setRect(5.0, this.chartInsets.top + this.chartHeight + this.verticalAxisFont.getSize() / 2 + 1, this.drawWidth - 10, this.horizontalAxisFont.getSize() + 2);
            this.verticalAxisClip.setRect(0.0, this.chartInsets.top - this.verticalAxisFont.getSize() / 2, this.chartInsets.left - 1, this.chartHeight + this.verticalAxisFont.getSize());
            if (this.useSecondaryVerticalAxis) {
                this.verticalAxisClip2.setRect(this.chartInsets.left + this.chartWidth + 1, this.chartInsets.top - this.verticalAxisFont.getSize() / 2, this.chartInsets.right - 1, this.chartHeight + this.verticalAxisFont.getSize());
            }
            if (this.model != null) {
                this.updateScaleFactors();
            }
            this.doRepaint(false);
        }
    }

    private void updateScaleFactors() {
        long dataLimitX;
        if (!this.useDayInTimeLegend) {
            Calendar firstTimestampCalendar = Calendar.getInstance();
            firstTimestampCalendar.setTime(new Date(this.model.getMinXValue()));
            Calendar lastTimestampCalendar = Calendar.getInstance();
            lastTimestampCalendar.setTime(new Date(this.model.getMaxXValue()));
            if (firstTimestampCalendar.get(7) != lastTimestampCalendar.get(7) || firstTimestampCalendar.get(2) != lastTimestampCalendar.get(2) || firstTimestampCalendar.get(1) != lastTimestampCalendar.get(1)) {
                this.useDayInTimeLegend = true;
            }
        }
        if (this.customizedEmptyAppearance && this.model.getItemCount() < 2) {
            dataLimitX = this.lastValueH;
            this.dataOffsetX = this.firstValueH;
        } else {
            dataLimitX = this.model.getMaxXValue();
            this.dataOffsetX = this.model.getMinXValue();
        }
        if (this.fitToWindow) {
            this.dataViewWidth = this.chartWidth;
            this.scaleFactorX = (double)this.chartWidth / (double)(dataLimitX - this.dataOffsetX);
            this.lastScaleXValid = false;
            this.lastLeadingItemIndex = 0;
            this.trailingItemVisible = false;
            this.changePan(0L);
            this.lastViewOffsetXValid = false;
        } else {
            if (this.viewScaleX == 0.0 && this.chartWidth > 0) {
                this.viewScaleX = (double)this.chartWidth / this.dataWidthAtTrackingEndSwitch;
            }
            this.dataViewWidth = (long)((double)(dataLimitX - this.dataOffsetX) * this.viewScaleX);
            this.scaleFactorX = this.viewScaleX;
            if (this.trackingEnd && !this.trailingItemVisible) {
                this.changePan((long)(-this.chartWidth) + this.dataViewWidth);
                this.lastViewOffsetXValid = false;
            }
        }
        if (this.fitToWindow) {
            this.changeZoom(this.scaleFactorX);
        } else {
            this.viewScaleX = this.scaleFactorX;
        }
        boolean yScaleChanged = false;
        for (int seriesIndex = 0; seriesIndex < this.model.getSeriesCount(); ++seriesIndex) {
            long maxYValue = this.model.getMaxDisplayYValue(seriesIndex);
            long minYValue = this.model.getMinDisplayYValue(seriesIndex);
            if (this.lastMaxYs[seriesIndex] != maxYValue) {
                yScaleChanged = true;
            }
            if (this.lastMinYs[seriesIndex] != minYValue) {
                yScaleChanged = true;
            }
            this.lastMaxYs[seriesIndex] = maxYValue;
            this.lastMinYs[seriesIndex] = minYValue;
            this.dataOffsetsY[seriesIndex] = minYValue;
            this.scaleFactorsY[seriesIndex] = (double)(this.chartHeight - this.topChartMargin) / (double)(maxYValue - this.dataOffsetsY[seriesIndex]);
        }
        this.lastScaleYValid = this.lastScaleYValid && !yScaleChanged;
        this.updateScrollBarValues();
        this.scaleFactorsNeedUpdate = false;
    }

    private void updateScrollBarValues() {
        if (this.scrollBar != null) {
            this.scrollBarLongToIntFactor = this.dataViewWidth > Integer.MAX_VALUE ? 2.147483647E9 / (double)this.dataViewWidth : 1.0;
            int value = this.getIntPosition();
            int extent = this.getIntExtent();
            int minimum = this.getIntMinimum();
            int maximum = this.getIntMaximum();
            if (this.dataViewWidth <= (long)this.chartWidth) {
                if (this.scrollBar.isEnabled()) {
                    this.scrollBar.setEnabled(false);
                }
            } else {
                if (!this.scrollBar.isEnabled()) {
                    this.scrollBar.setEnabled(true);
                }
                if (!this.scrollBar.getValueIsAdjusting()) {
                    this.internalScrollBarChange = true;
                    this.scrollBar.setUnitIncrement(this.getIntUnitIncrement());
                    this.scrollBar.setBlockIncrement(this.getIntBlockIncrement());
                    this.scrollBar.setValues(value, extent, minimum, maximum);
                } else {
                    this.scrollBarValuesDirty = true;
                }
            }
        }
    }

    private void updateTrailingItemVisible() {
        long preTrailingItemX;
        if (this.trackingEnd) {
            this.trailingItemVisible = false;
        }
        boolean preTrailingItemVisible = (preTrailingItemX = this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 2))) >= 0L && preTrailingItemX <= (long)(this.chartWidth + this.chartInsets.left - 1);
        long trailingItemX = this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1));
        boolean bl = this.trailingItemVisible = trailingItemX >= 0L && trailingItemX <= (long)(this.chartWidth + this.chartInsets.left - 1);
        if (preTrailingItemVisible && !this.trailingItemVisible) {
            this.changeTrackingEnd(true);
        }
    }
}

