/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.HandshakeHash;
import com.sun.net.ssl.internal.ssl.InputRecord;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLException;

class HandshakeInStream
extends InputStream {
    InputRecord r = new InputRecord();

    HandshakeInStream(HandshakeHash handshakeHash) {
        this.r.setHandshakeHash(handshakeHash);
    }

    public int available() {
        return this.r.available();
    }

    public int read() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.r.read(byArray, n, n2);
        if (n3 != n2) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        return this.r.skip(l);
    }

    public void mark(int n) {
        this.r.mark(n);
    }

    public void reset() {
        this.r.reset();
    }

    public boolean markSupported() {
        return true;
    }

    void incomingRecord(InputRecord inputRecord) throws IOException {
        this.r.queueHandshake(inputRecord);
    }

    void digestNow() {
        this.r.doHashes();
    }

    void ignore(int n) {
        this.r.ignore(n);
    }

    int getInt8() throws IOException {
        return this.read();
    }

    int getInt16() throws IOException {
        return this.getInt8() << 8 | this.getInt8();
    }

    int getInt24() throws IOException {
        return this.getInt8() << 16 | this.getInt8() << 8 | this.getInt8();
    }

    int getInt32() throws IOException {
        return this.getInt8() << 24 | this.getInt8() << 16 | this.getInt8() << 8 | this.getInt8();
    }

    byte[] getBytes8() throws IOException {
        int n = this.getInt8();
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }

    byte[] getBytes16() throws IOException {
        int n = this.getInt16();
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }

    byte[] getBytes24() throws IOException {
        int n = this.getInt24();
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }
}

