/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;

public abstract class PrestimeCPUCCTNode
implements CCTNode,
Cloneable {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle");
    private static final String SELF_TIME_STRING = messages.getString("PrestimeCPUCCTNode_SelfTimeString");
    private static final String FROM_MSG = messages.getString("PrestimeCPUCCTNode_FromMsg");
    protected static final char MASK_SELF_TIME_NODE = '\u0001';
    protected static final char MASK_CONTEXT_CALLS_NODE = '\u0002';
    protected static final char MASK_THREAD_NODE = '\u0004';
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME_0 = 2;
    public static final int SORT_BY_TIME_1 = 3;
    public static final int SORT_BY_INVOCATIONS = 4;
    protected CPUCCTContainer container;
    protected PrestimeCPUCCTNode parent;
    protected PrestimeCPUCCTNode[] children;
    protected char flags;

    protected PrestimeCPUCCTNode() {
    }

    protected PrestimeCPUCCTNode(CPUCCTContainer container, PrestimeCPUCCTNode parent) {
        this.container = container;
        this.parent = parent;
    }

    public abstract CCTNode getChild(int var1);

    public abstract CCTNode[] getChildren();

    public CPUCCTContainer getContainer() {
        return this.container;
    }

    public void setContextCallsNode() {
        this.flags = (char)2;
    }

    public boolean isContextCallsNode() {
        return (this.flags & 2) != 0;
    }

    public String[] getMethodClassNameAndSig() {
        if (!this.isThreadNode()) {
            return this.container.getMethodClassNameAndSig(this.getMethodId());
        }
        return new String[]{this.container.getThreadName(), "", ""};
    }

    public abstract int getMethodId();

    public abstract int getNCalls();

    public abstract int getNChildren();

    public String getNodeName() {
        if (this.isSelfTimeNode()) {
            return SELF_TIME_STRING;
        }
        if (this.isThreadNode()) {
            return this.container.getThreadName();
        }
        int methodId = this.getMethodId();
        String[] methodClassNameAndSig = this.container.getMethodClassNameAndSig(methodId);
        String res = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(methodClassNameAndSig[0], methodClassNameAndSig[1], methodClassNameAndSig[2]).toFormatted();
        if (this.isContextCallsNode()) {
            return MessageFormat.format(FROM_MSG, res);
        }
        return res;
    }

    public CCTNode getParent() {
        return this.parent;
    }

    public abstract long getSleepTime0();

    public abstract int getThreadId();

    public void setSelfTimeNode() {
        this.flags = '\u0001';
    }

    public boolean isSelfTimeNode() {
        return (this.flags & '\u0001') != 0;
    }

    public void setThreadNode() {
        this.flags = (char)4;
    }

    public boolean isThreadNode() {
        return (this.flags & 4) != 0;
    }

    public abstract long getTotalTime0();

    public abstract float getTotalTime0InPerCent();

    public abstract long getTotalTime1();

    public abstract float getTotalTime1InPerCent();

    public abstract long getWaitTime0();

    public int getIndexOfChild(Object child) {
        for (int i = 0; i < this.children.length; ++i) {
            if ((PrestimeCPUCCTNode)child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public abstract void sortChildren(int var1, boolean var2);

    public String toString() {
        return this.getNodeName();
    }

    protected void doSortChildren(int sortBy, boolean sortOrder) {
        int len = this.children.length;
        for (int i = 0; i < len; ++i) {
            this.children[i].sortChildren(sortBy, sortOrder);
        }
        if (len > 1) {
            switch (sortBy) {
                case 1: {
                    this.sortChildrenByName(sortOrder);
                    break;
                }
                case 2: {
                    this.sortChildrenByTime0(sortOrder);
                    break;
                }
                case 3: {
                    this.sortChildrenByTime1(sortOrder);
                    break;
                }
                case 4: {
                    this.sortChildrenByInvocations(sortOrder);
                }
            }
        }
    }

    protected void sortChildrenByInvocations(boolean sortOrder) {
        int len = this.children.length;
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].getNCalls();
        }
        this.sortInts(values, sortOrder);
    }

    protected void sortChildrenByName(boolean sortOrder) {
        int len = this.children.length;
        String[] values = new String[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].getNodeName();
        }
        this.sortStrings(values, sortOrder);
    }

    protected void sortChildrenByTime0(boolean sortOrder) {
        int len = this.children.length;
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].getTotalTime0();
        }
        this.sortLongs(values, sortOrder);
    }

    protected void sortChildrenByTime1(boolean sortOrder) {
        int len = this.children.length;
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = this.children[i].getTotalTime1();
        }
        this.sortLongs(values, sortOrder);
    }

    protected void sortInts(int[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1] < values[j] : values[j - 1] > values[j]); --j) {
                int tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PrestimeCPUCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    protected void sortLongs(long[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1] < values[j] : values[j - 1] > values[j]); --j) {
                long tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PrestimeCPUCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }

    protected void sortStrings(String[] values, boolean sortOrder) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            for (int j = i; j > 0 && (!sortOrder ? values[j - 1].compareTo(values[j]) < 0 : values[j - 1].compareTo(values[j]) > 0); --j) {
                String tmp = values[j];
                values[j] = values[j - 1];
                values[j - 1] = tmp;
                PrestimeCPUCCTNode tmpCh = this.children[j];
                this.children[j] = this.children[j - 1];
                this.children[j - 1] = tmpCh;
            }
        }
    }
}

