/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.coderegion;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.ResultsSnapshot;

public final class CodeRegionResultsSnapshot
extends ResultsSnapshot {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.coderegion.Bundle");
    private static final String CODE_FRAGMENT_MSG = messages.getString("CodeRegionResultsSnapshot_CodeFragmentMsg");
    private long[] rawData;
    private long timerCountsInSecond;

    public CodeRegionResultsSnapshot(long beginTime, long timeTaken, long[] rawData, long timerCountsInSecond) {
        super(beginTime, timeTaken);
        this.rawData = rawData;
        this.timerCountsInSecond = timerCountsInSecond;
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public CodeRegionResultsSnapshot() {
    }

    public int getInvocations() {
        if (this.rawData == null) {
            return 0;
        }
        return this.rawData.length;
    }

    public long getTimerCountsInSecond() {
        return this.timerCountsInSecond;
    }

    public long[] getTimes() {
        return this.rawData;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.timerCountsInSecond = in.readLong();
        int len = in.readInt();
        this.rawData = new long[len];
        for (int i = 0; i < len; ++i) {
            this.rawData[i] = in.readLong();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public String toString() {
        return MessageFormat.format(CODE_FRAGMENT_MSG, super.toString());
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeLong(this.timerCountsInSecond);
        out.writeInt(this.rawData.length);
        for (int i = 0; i < this.rawData.length; ++i) {
            out.writeLong(this.rawData[i]);
        }
    }

    private void debugValues() {
        LOGGER.finest("rawData.length: " + this.debugLength(this.rawData));
        LOGGER.finest("timerCountsInSecond: " + this.timerCountsInSecond);
    }
}

