/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofInstanceValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class InstanceDump
extends HprofObject
implements Instance {
    final ClassDump dumpClass;

    InstanceDump(ClassDump cls, long offset) {
        super(offset);
        this.dumpClass = cls;
    }

    public List getFieldValues() {
        long offset = this.fileOffset + (long)this.getInstanceFieldValuesOffset();
        List fields = this.dumpClass.getAllInstanceFields();
        ArrayList<HprofInstanceValue> values = new ArrayList<HprofInstanceValue>(fields.size());
        Iterator fit = fields.iterator();
        while (fit.hasNext()) {
            HprofField field = (HprofField)fit.next();
            if (field.getVauleType() == 2) {
                values.add(new HprofInstanceObjectValue(this, field, offset));
            } else {
                values.add(new HprofInstanceValue(this, field, offset));
            }
            offset += (long)field.getValueSize();
        }
        return values;
    }

    public boolean isGCRoot() {
        return this.dumpClass.getHprof().getGCRoot(this) != null;
    }

    public long getInstanceId() {
        return this.dumpClass.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    public int getInstanceNumber() {
        return this.dumpClass.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    public JavaClass getJavaClass() {
        return this.dumpClass;
    }

    public Instance getNearestGCRootPointer() {
        return this.dumpClass.getHprof().nearestGCRoot.getNearestGCRootPointer(this);
    }

    public int getReachableSize() {
        return 0;
    }

    public List getReferences() {
        HprofByteBuffer buffer = this.dumpClass.getHprofBuffer();
        byte[] idArr = new byte[buffer.getIDSize()];
        buffer.get(this.fileOffset + 1L, idArr);
        return this.dumpClass.getHprof().findReferencesFor(this.getInstanceId(), idArr);
    }

    public int getRetainedSize() {
        return 0;
    }

    public int getSize() {
        return this.dumpClass.getInstanceSize();
    }

    public List getStaticFieldValues() {
        return this.dumpClass.getStaticFieldValues();
    }

    public Object getValueOfField(String name) {
        Iterator fIt = this.getFieldValues().iterator();
        FieldValue matchingFieldValue = null;
        while (fIt.hasNext()) {
            FieldValue fieldValue = (FieldValue)fIt.next();
            if (!fieldValue.getField().getName().equals(name)) continue;
            matchingFieldValue = fieldValue;
        }
        if (matchingFieldValue == null) {
            return null;
        }
        if (matchingFieldValue instanceof HprofInstanceObjectValue) {
            return ((HprofInstanceObjectValue)matchingFieldValue).getInstance();
        }
        return ((HprofInstanceValue)matchingFieldValue).getTypeValue();
    }

    private int getInstanceFieldValuesOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return 1 + idSize + 4 + idSize + 4;
    }
}

