/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofMappedByteBuffer
extends HprofByteBuffer {
    private MappedByteBuffer dumpBuffer;

    HprofMappedByteBuffer(File dumpFile) throws IOException {
        FileInputStream fis = new FileInputStream(dumpFile);
        FileChannel channel = fis.getChannel();
        this.length = channel.size();
        this.dumpBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        channel.close();
        this.readHeader();
    }

    char getChar(long index) {
        return this.dumpBuffer.getChar((int)index);
    }

    double getDouble(long index) {
        return this.dumpBuffer.getDouble((int)index);
    }

    float getFloat(long index) {
        return this.dumpBuffer.getFloat((int)index);
    }

    int getInt(long index) {
        return this.dumpBuffer.getInt((int)index);
    }

    long getLong(long index) {
        return this.dumpBuffer.getLong((int)index);
    }

    short getShort(long index) {
        return this.dumpBuffer.getShort((int)index);
    }

    byte get(long index) {
        return this.dumpBuffer.get((int)index);
    }

    synchronized void get(long position, byte[] chars) {
        this.dumpBuffer.position((int)position);
        this.dumpBuffer.get(chars);
    }
}

