/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Iterator;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaClass;

class ComputedSummary
implements HeapSummary {
    private int bytes;
    private int instances;
    private long time;

    ComputedSummary(HprofHeap heap) {
        Iterator classIt = heap.getAllClasses().iterator();
        while (classIt.hasNext()) {
            JavaClass jcls = (JavaClass)classIt.next();
            this.instances += jcls.getInstancesCount();
            this.bytes += jcls.getAllInstancesSize();
        }
        this.time = heap.dumpBuffer.getTime();
    }

    public long getTime() {
        return this.time;
    }

    public long getTotalAllocatedBytes() {
        return -1L;
    }

    public long getTotalAllocatedInstances() {
        return -1L;
    }

    public int getTotalLiveBytes() {
        return this.bytes;
    }

    public int getTotalLiveInstances() {
        return this.instances;
    }
}

