/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.queries;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.spi.queries.CollocationQueryImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysRelativeCollocationQuery
implements CollocationQueryImplementation {
    private File[] roots;

    @Override
    public File findRoot(File file) {
        File[] fileArray = this.getFileSystemRoots();
        if (fileArray.length == 0) {
            assert (false) : "Cannot find filesystem roots";
            return null;
        }
        if (fileArray.length == 1) {
            return fileArray[0];
        }
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(this.roots != null ? this.roots : fileArray));
        return this.getRoot(file, hashSet);
    }

    @Override
    public boolean areCollocated(File file, File file2) {
        File file3 = this.findRoot(file);
        File file4 = this.findRoot(file2);
        return file3 != null && file3.equals(file4);
    }

    private File[] getFileSystemRoots() {
        if (this.roots != null) {
            return this.roots;
        }
        return File.listRoots();
    }

    private File getRoot(File file, Set<File> set) {
        while (file != null && !set.contains(file)) {
            file = file.getParentFile();
        }
        return file;
    }

    final void setFileSystemRoots(File[] fileArray) {
        this.roots = fileArray;
    }
}

