/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.components;

import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.ui.components.DisplayAreaSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;

class DisplayArea
extends JComponent {
    private boolean ignoresContentsHeight = true;
    private String caption = "";
    private Presenter presenter;
    private ViewArea viewContainer;
    private TabsContainer tabsContainer;
    private MiddleSpacer middleSpacer;
    private OptionsContainer optionsContainer;

    public DisplayArea() {
        this.initComponents();
        this.setClosable(true);
        this.setVisible(false);
    }

    public void setCaption(String caption) {
        this.caption = caption;
        if (this.presenter != null) {
            this.presenter.setCaption(caption);
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setClosable(boolean closable) {
        this.optionsContainer.setClosable(closable);
        this.updatePresenter();
    }

    public boolean isClosable() {
        return this.optionsContainer.isClosable();
    }

    public void setIgnoresContentsHeight(boolean ignoresContentsHeight) {
        this.ignoresContentsHeight = ignoresContentsHeight;
    }

    public boolean ignoresContentsHeight() {
        return this.ignoresContentsHeight;
    }

    public Presenter getPresenter() {
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
            this.updatePresenter();
        }
        return this.presenter;
    }

    public void addTab(Tab tab) {
        DisplayAreaSupport.TabButton tabButton = this.tabsContainer.addTab(tab);
        if (tabButton != null) {
            this.optionsContainer.addOptions(tab);
            this.updateTabbed();
            if (this.tabsContainer.indexOfTab(tab) == 0) {
                this.setSelectedTab(tab);
            }
            final Tab tabF = tab;
            tabButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        DisplayArea.this.setSelectedTab(tabF);
                    }
                }
            });
            tabButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayArea.this.setSelectedTab(tabF);
                }
            });
        }
        if (this.tabsContainer.getTabsCount() > 0) {
            this.setVisible(true);
        }
        this.updatePresenter();
    }

    public void removeTab(Tab tab) {
        boolean wasSelected;
        Tab toSelect = null;
        boolean bl = wasSelected = this.getSelectedTab() == tab;
        if (wasSelected && (toSelect = this.tabsContainer.getPreviousTab(tab)) == null) {
            toSelect = this.tabsContainer.getNextTab(tab);
        }
        if (this.tabsContainer.removeTab(tab)) {
            this.optionsContainer.removeOptions(tab);
            if (wasSelected) {
                if (toSelect != null) {
                    this.setSelectedTab(toSelect);
                } else {
                    this.viewContainer.setSelectedView(null);
                }
            }
            this.updateTabbed();
        }
        if (this.tabsContainer.getTabsCount() == 0) {
            this.setVisible(false);
        }
        this.updatePresenter();
    }

    public boolean containsTab(Tab tab) {
        return this.tabsContainer.containsTab(tab);
    }

    public void setSelectedTab(Tab tab) {
        if (this.tabsContainer.getSelectedTab() == tab) {
            return;
        }
        this.tabsContainer.setSelectedTab(tab);
        this.optionsContainer.setSelectedOptions(tab);
        this.viewContainer.setSelectedView(tab.getView());
    }

    public Tab getSelectedTab() {
        return this.tabsContainer.getSelectedTab();
    }

    public Dimension getPreferredSize() {
        if (this.ignoresContentsHeight()) {
            return new Dimension(0, this.tabsContainer.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.ignoresContentsHeight()) {
            return this.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    private void updatePresenter() {
        if (this.presenter == null) {
            return;
        }
        this.presenter.setVisible(this.tabsContainer.getTabsCount() > 0 && this.isClosable());
    }

    private void updateTabbed() {
        boolean tabbed = this.tabsContainer.getTabsCount() > 1;
        this.middleSpacer.updateTabbed(tabbed);
        this.optionsContainer.updateTabbed(tabbed);
    }

    private Presenter createPresenter() {
        final Presenter presenter = new Presenter();
        presenter.setCaption(this.caption);
        presenter.setOpaque(false);
        final boolean[] internalChange = new boolean[]{false};
        presenter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                internalChange[0] = true;
                DisplayArea.this.setVisible(presenter.isSelected());
                internalChange[0] = false;
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    boolean isShowing = DisplayArea.this.isShowing();
                    presenter.setToolTipText(isShowing ? "Hide " + DisplayArea.this.caption : "Show " + DisplayArea.this.caption);
                    if (!internalChange[0]) {
                        presenter.setSelected(isShowing);
                    }
                }
            }
        });
        return presenter;
    }

    private void initComponents() {
        this.viewContainer = new ViewArea();
        this.tabsContainer = new TabsContainer();
        this.middleSpacer = new MiddleSpacer();
        this.optionsContainer = new OptionsContainer();
        JPanel captionArea = new JPanel();
        captionArea.setLayout(new BorderLayout());
        captionArea.setOpaque(false);
        captionArea.add((Component)this.tabsContainer, "West");
        captionArea.add((Component)this.middleSpacer, "Center");
        captionArea.add((Component)this.optionsContainer, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)captionArea, "North");
        this.add((Component)this.viewContainer, "Center");
    }

    private static class ViewArea
    extends JPanel {
        private ViewArea() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectedView(JComponent component) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.removeAll();
                if (component != null) {
                    this.add((Component)component, "Center");
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    private static class OptionsContainer
    extends JPanel {
        private JPanel contentsPanel;
        private JButton closeButton;
        private CardLayout layout = new CardLayout(0, 0);
        private Map<Tab, JPanel> tabsMapper = new HashMap<Tab, JPanel>();

        private OptionsContainer() {
            this.initComponents();
        }

        private void setClosable(boolean closable) {
            this.closeButton.setVisible(closable);
        }

        private boolean isClosable() {
            return this.closeButton.isVisible();
        }

        private void addOptions(Tab tab) {
            JPanel optionsContainer = new JPanel();
            optionsContainer.setLayout(new BoxLayout(optionsContainer, 0));
            optionsContainer.setOpaque(false);
            JComponent[] options = tab.getOptions();
            if (options != null) {
                for (JComponent option : options) {
                    option.setBorder(BorderFactory.createEmptyBorder(3, 5, 2, 8));
                    option.setAlignmentY(0.5f);
                    optionsContainer.add(option);
                }
            }
            this.tabsMapper.put(tab, optionsContainer);
            this.contentsPanel.add((Component)optionsContainer, tab.getName());
        }

        private void removeOptions(Tab tab) {
            JPanel optionsContainer = this.tabsMapper.remove(tab);
            if (optionsContainer != null) {
                this.contentsPanel.remove(optionsContainer);
            }
        }

        private void setSelectedOptions(Tab tab) {
            this.layout.show(this.contentsPanel, tab.getName());
        }

        private void updateTabbed(boolean tabbed) {
            if (tabbed) {
                this.setBorder(new DisplayAreaSupport.TabbedCaptionBorder(DisplayAreaSupport.BORDER_COLOR_NORMAL, DisplayAreaSupport.COLOR_NONE, DisplayAreaSupport.BORDER_COLOR_HIGHLIGHT, DisplayAreaSupport.BORDER_COLOR_NORMAL));
            } else {
                this.setBorder(new DisplayAreaSupport.TabbedCaptionBorder(DisplayAreaSupport.BORDER_COLOR_NORMAL, DisplayAreaSupport.COLOR_NONE, DisplayAreaSupport.COLOR_NONE, DisplayAreaSupport.BORDER_COLOR_NORMAL));
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(DisplayAreaSupport.BACKGROUND_COLOR_NORMAL);
            ImageIcon closeIcon = new ImageIcon(DisplayArea.class.getResource("/com/sun/tools/visualvm/core/ui/resources/closePanel.png"));
            this.closeButton = new DisplayAreaSupport.ImageIconButton(closeIcon);
            this.closeButton.setToolTipText(NbBundle.getMessage(DisplayArea.class, (String)"ToolTip_Hide"));
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsContainer.this.getParent().getParent().setVisible(false);
                }
            });
            this.contentsPanel = new JPanel(this.layout);
            this.contentsPanel.setOpaque(false);
            this.add((Component)this.contentsPanel, "West");
            this.add((Component)this.closeButton, "East");
        }
    }

    private static class MiddleSpacer
    extends JPanel {
        private MiddleSpacer() {
            this.setLayout(null);
            this.setOpaque(true);
            this.setBackground(DisplayAreaSupport.BACKGROUND_COLOR_NORMAL);
        }

        private void updateTabbed(boolean tabbed) {
            if (tabbed) {
                this.setBorder(new DisplayAreaSupport.TabbedCaptionBorder(DisplayAreaSupport.BORDER_COLOR_NORMAL, DisplayAreaSupport.COLOR_NONE, DisplayAreaSupport.BORDER_COLOR_HIGHLIGHT, DisplayAreaSupport.COLOR_NONE));
            } else {
                this.setBorder(new DisplayAreaSupport.TabbedCaptionBorder(DisplayAreaSupport.BORDER_COLOR_NORMAL, DisplayAreaSupport.COLOR_NONE, DisplayAreaSupport.BACKGROUND_COLOR_NORMAL, DisplayAreaSupport.COLOR_NONE));
            }
        }
    }

    private static class TabsContainer
    extends JPanel {
        private List<Tab> tabs = new ArrayList<Tab>();
        private Tab selectedTab;

        private TabsContainer() {
            this.setLayout(null);
            this.setOpaque(true);
            this.setBackground(DisplayAreaSupport.BACKGROUND_COLOR_NORMAL);
        }

        private DisplayAreaSupport.TabButton addTab(Tab tab) {
            if (this.tabs.contains(tab)) {
                return null;
            }
            if (this.getLayout() == null) {
                this.setLayout(new BoxLayout(this, 0));
            }
            this.tabs.add(tab);
            Collections.sort(this.tabs, Positionable.COMPARATOR);
            DisplayAreaSupport.TabButton tabButton = new DisplayAreaSupport.TabButton(tab.getName(), tab.getDescription());
            DisplayAreaSupport.TabButtonContainer tabButtonContainer = new DisplayAreaSupport.TabButtonContainer(tabButton);
            tabButtonContainer.setAlignmentY(0.0f);
            this.add((Component)tabButtonContainer, this.tabs.indexOf(tab));
            this.updateTabButtons();
            return tabButton;
        }

        private int indexOfTab(Tab tab) {
            return this.tabs.indexOf(tab);
        }

        private boolean removeTab(Tab tab) {
            int index = this.indexOfTab(tab);
            if (index != -1) {
                this.tabs.remove(index);
                this.remove(index);
                if (tab == this.selectedTab) {
                    this.selectedTab = null;
                }
                this.updateTabButtons();
                return true;
            }
            return false;
        }

        private boolean containsTab(Tab tab) {
            return this.tabs.contains(tab);
        }

        private void setSelectedTab(Tab tab) {
            this.selectedTab = tab;
            this.updateTabButtons();
        }

        private Tab getSelectedTab() {
            return this.selectedTab;
        }

        private Tab getPreviousTab(Tab tab) {
            int index = this.tabs.indexOf(tab);
            return index > 0 ? this.tabs.get(--index) : null;
        }

        private Tab getNextTab(Tab tab) {
            int index = this.tabs.indexOf(tab);
            return index < this.tabs.size() - 1 ? this.tabs.get(++index) : null;
        }

        private int getTabsCount() {
            return this.tabs.size();
        }

        private void updateTabButtons() {
            int tabIndex = this.tabs.indexOf(this.selectedTab);
            Component[] components = this.getComponents();
            int componentsCount = components.length;
            for (int i = 0; i < componentsCount; ++i) {
                ((DisplayAreaSupport.TabButtonContainer)components[i]).updateTabButton(i, tabIndex, componentsCount);
            }
        }
    }

    public static class Tab
    implements Positionable {
        private String name;
        private String description;
        private int preferredPosition;
        private JComponent view;
        private JComponent[] options;

        public Tab(String name, JComponent view) {
            this(name, null, 0x7FFFFFFE, view, null);
        }

        public Tab(String name, String description, int preferredPosition, JComponent view, JComponent[] options) {
            this.setName(name);
            this.setDescription(description);
            this.setPreferredPosition(preferredPosition);
            this.setView(view);
            this.setOptions(options);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setPreferredPosition(int preferredPosition) {
            this.preferredPosition = preferredPosition;
        }

        public int getPreferredPosition() {
            return this.preferredPosition;
        }

        public void setView(JComponent view) {
            this.view = view;
        }

        public JComponent getView() {
            return this.view;
        }

        public void setOptions(JComponent[] options) {
            this.options = options;
        }

        public JComponent[] getOptions() {
            return this.options;
        }
    }

    public static class Presenter
    extends JCheckBox {
        public void setCaption(String caption) {
            this.setText(caption);
        }

        public String getCaption() {
            return this.getText();
        }

        public void setDescription(String description) {
            this.setToolTipText(description);
        }

        public String getDescription() {
            return this.getToolTipText();
        }
    }
}

