/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import java.io.File;

public abstract class Snapshot
extends DataSource {
    public static final String PROPERTY_FILE = "prop_file";
    private File file;
    private final SnapshotCategory category;

    public Snapshot(File file, SnapshotCategory category) {
        this(file, category, null);
    }

    public Snapshot(File file, SnapshotCategory category, DataSource master) {
        super(master);
        this.file = file;
        this.category = category;
    }

    public final File getFile() {
        return this.file;
    }

    public final SnapshotCategory getCategory() {
        return this.category;
    }

    protected final void setFile(File newFile) {
        if (this.file == null && newFile == null) {
            return;
        }
        File oldFile = this.file;
        this.file = newFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_FILE, oldFile, newFile);
    }

    public void save(File directory) {
        File f = this.getFile();
        if (f != null && f.isFile()) {
            File saveFile = Utils.getUniqueFile(directory, f.getName());
            Utils.copyFile(f, saveFile);
            this.getStorage().saveCustomPropertiesTo(new File(saveFile.getAbsolutePath() + ".properties"));
        }
    }

    public boolean supportsSaveAs() {
        return false;
    }

    public void saveAs() {
        throw new UnsupportedOperationException("Save as not supported");
    }

    public boolean supportsDelete() {
        return true;
    }

    public void delete() {
        DataSourceWindowManager.sharedInstance().closeDataSource(this);
        this.getOwner().getRepository().removeDataSource(this);
    }

    protected void remove() {
        final File f = this.getFile();
        if (f != null) {
            Utils.FILE_QUEUE.post(new Runnable(){

                public void run() {
                    Utils.delete(f, true);
                }
            });
        }
        this.setFile(null);
        super.remove();
    }

    protected Storage createStorage() {
        File f = this.getFile();
        if (f != null) {
            String customPropertiesFileName = f.getName() + ".properties";
            if (f.isDirectory()) {
                return new Storage(f, customPropertiesFileName);
            }
            if (f.isFile()) {
                File directory = f.getParentFile();
                return new Storage(directory, customPropertiesFileName);
            }
        }
        return super.createStorage();
    }
}

