/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.explorer;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExplorerNode
extends DefaultMutableTreeNode
implements Positionable {
    private String name;
    private Icon icon;
    private int preferredPosition;
    private int autoExpansionPolicy;
    private boolean firstExpansionFlag = true;

    public ExplorerNode(DataSource dataSource) {
        super(dataSource);
    }

    public ExplorerNode(DataSource dataSource, String name, Icon icon, int preferredPosition) {
        super(dataSource);
        this.setName(name);
        this.setIcon(icon);
        this.setPreferredPosition(preferredPosition);
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public DataSource getUserObject() {
        return (DataSource)super.getUserObject();
    }

    public void addNode(ExplorerNode newChild) {
        this.addNodes(Collections.singleton(newChild));
    }

    public void addNodes(Set<ExplorerNode> newChildren) {
        int originalChildCount = this.getChildCount();
        ArrayList<ExplorerNode> sortedNewChildren = new ArrayList<ExplorerNode>(newChildren);
        Collections.sort(sortedNewChildren, Positionable.COMPARATOR);
        int insertPosition = 0;
        for (ExplorerNode newChild : sortedNewChildren) {
            int newChildPreferredPosition = newChild.getPreferredPosition();
            if (insertPosition == this.getChildCount()) {
                this.add(newChild);
                ++insertPosition;
                continue;
            }
            ExplorerNode node = (ExplorerNode)this.getChildAt(insertPosition);
            while (node.getPreferredPosition() <= newChildPreferredPosition && insertPosition < this.getChildCount()) {
                if (++insertPosition >= this.getChildCount()) continue;
                node = (ExplorerNode)this.getChildAt(insertPosition);
            }
            if (insertPosition == this.getChildCount()) {
                this.add(newChild);
            } else {
                this.insert(newChild, insertPosition);
            }
            ++insertPosition;
        }
        boolean shouldExpand = false;
        boolean firstChildAdded = originalChildCount == 0 && this.getChildCount() > 0;
        switch (this.autoExpansionPolicy) {
            case 1: {
                if (this.firstExpansionFlag && firstChildAdded) {
                    shouldExpand = true;
                }
                this.firstExpansionFlag = false;
                break;
            }
            case 2: {
                if (!firstChildAdded) break;
                shouldExpand = true;
                break;
            }
            case 3: 
            case 4: {
                if (newChildren.size() <= 0) break;
                shouldExpand = true;
            }
        }
        if (shouldExpand) {
            ExplorerSupport.sharedInstance().expandNode(this);
        }
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        super.remove(aChild);
        if (this.autoExpansionPolicy == 4) {
            ExplorerSupport.sharedInstance().expandNode(this);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int getPreferredPosition() {
        return this.preferredPosition;
    }

    void setName(String name) {
        this.name = name;
    }

    void setIcon(Icon icon) {
        this.icon = icon;
    }

    void setPreferredPosition(int preferredPosition) {
        this.preferredPosition = preferredPosition;
    }

    void setAutoExpansionPolicy(int autoExpansionPolicy) {
        this.autoExpansionPolicy = autoExpansionPolicy;
        this.firstExpansionFlag = true;
    }
}

