/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.ModuleChangeHandler;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.WindowManagerConfig;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PersistenceManager
implements PropertyChangeListener {
    static final Logger LOG = Logger.getLogger("org.netbeans.core.windows.persistence");
    static final String ROOT_MODULE_FOLDER = "Windows2";
    public static final String ROOT_LOCAL_FOLDER = "Windows2Local";
    static final String WINDOWMANAGER_FOLDER = "WindowManager";
    static final String GROUPS_FOLDER = "Groups";
    static final String MODES_FOLDER = "Modes";
    public static final String COMPS_FOLDER = "Components";
    public static final String WINDOWMANAGER_EXT = "wswmgr";
    public static final String WORKSPACE_EXT = "wswksp";
    public static final String MODE_EXT = "wsmode";
    public static final String TCREF_EXT = "wstcref";
    public static final String GROUP_EXT = "wsgrp";
    public static final String TCGROUP_EXT = "wstcgrp";
    public static final String COMPONENT_EXT = "settings";
    private static final String DEFAULT_TC_NAME = "untitled_tc";
    private static final boolean DEBUG = Debug.isLoggable(PersistenceManager.class);
    private FileObject rootModuleFolder;
    private FileObject rootLocalFolder;
    private FileObject compsModuleFolder;
    private FileObject groupsModuleFolder;
    private FileObject groupsLocalFolder;
    private FileObject modesModuleFolder;
    private FileObject modesLocalFolder;
    private WindowManagerParser windowManagerParser;
    private ModuleChangeHandler changeHandler;
    private final Map<TopComponent, String> topComponent2IDMap = new WeakHashMap<TopComponent, String>(30);
    private final Map<TopComponent, String> topComponentNonPersistent2IDMap = new WeakHashMap<TopComponent, String>(30);
    private Set<String> globalIDSet = new HashSet<String>(30);
    private final Map<String, Reference<TopComponent>> id2TopComponentMap = Collections.synchronizedMap(new HashMap(30));
    private final Map<String, Reference<TopComponent>> id2TopComponentNonPersistentMap = Collections.synchronizedMap(new HashMap(30));
    private final Map<DataObject, String> dataobjectToTopComponentMap = new WeakHashMap<DataObject, String>(30);
    private Set invalidIds = new HashSet(10);
    private final Set<String> usedTcIds = new HashSet<String>(10);
    private final Object LOCK_IDS = new Object();
    private XMLReader parser;
    private static PersistenceManager defaultInstance;
    private final Set<String> warnedIDs = Collections.synchronizedSet(new HashSet());
    private Map<Exception, String> failedCompsMap;

    private PersistenceManager() {
    }

    public static synchronized PersistenceManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PersistenceManager();
        }
        return defaultInstance;
    }

    public void reset() {
        this.rootModuleFolder = null;
        this.rootLocalFolder = null;
        this.compsModuleFolder = null;
        this.groupsModuleFolder = null;
        this.groupsLocalFolder = null;
        this.modesModuleFolder = null;
        this.modesLocalFolder = null;
        this.windowManagerParser = null;
        if (this.changeHandler != null) {
            this.changeHandler.stopHandling();
        }
        this.changeHandler = null;
    }

    public void clear() {
        this.reset();
        this.topComponent2IDMap.clear();
        this.topComponentNonPersistent2IDMap.clear();
        this.globalIDSet = new HashSet<String>(30);
        this.id2TopComponentMap.clear();
        this.id2TopComponentNonPersistentMap.clear();
        this.dataobjectToTopComponentMap.clear();
        this.invalidIds = new HashSet(10);
        this.usedTcIds.clear();
    }

    FileObject getRootModuleFolder() throws IOException {
        try {
            if (this.rootModuleFolder == null) {
                this.rootModuleFolder = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)ROOT_MODULE_FOLDER);
            }
            return this.rootModuleFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_RootFolder", (Object)ROOT_MODULE_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    FileObject getRootLocalFolder() throws IOException {
        try {
            if (this.rootLocalFolder == null) {
                this.rootLocalFolder = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)ROOT_LOCAL_FOLDER);
            }
            return this.rootLocalFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_RootFolder", (Object)ROOT_LOCAL_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    void setRootModuleFolder(FileObject fileObject) {
        this.rootModuleFolder = fileObject;
    }

    void setRootLocalFolder(FileObject fileObject) {
        this.rootLocalFolder = fileObject;
    }

    public FileObject getComponentsModuleFolder() throws IOException {
        try {
            if (this.compsModuleFolder == null) {
                this.compsModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)COMPS_FOLDER);
            }
            return this.compsModuleFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_CompsFolder", (Object)COMPS_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public FileObject getComponentsLocalFolder() throws IOException {
        try {
            FileObject fileObject = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)COMPS_FOLDER);
            return fileObject;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_CompsFolder", (Object)COMPS_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public FileObject getGroupsModuleFolder() throws IOException {
        try {
            if (this.groupsModuleFolder == null) {
                this.groupsModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)GROUPS_FOLDER);
            }
            return this.groupsModuleFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_GroupsFolder", (Object)GROUPS_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public FileObject getGroupsLocalFolder() throws IOException {
        try {
            if (this.groupsLocalFolder == null) {
                this.groupsLocalFolder = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)GROUPS_FOLDER);
            }
            return this.groupsLocalFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_GroupsFolder", (Object)GROUPS_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public FileObject getModesModuleFolder() throws IOException {
        try {
            if (this.modesModuleFolder == null) {
                this.modesModuleFolder = FileUtil.createFolder((FileObject)this.getRootModuleFolder(), (String)MODES_FOLDER);
            }
            return this.modesModuleFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_ModesFolder", (Object)MODES_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public FileObject getModesLocalFolder() throws IOException {
        try {
            if (this.modesLocalFolder == null) {
                this.modesLocalFolder = FileUtil.createFolder((FileObject)this.getRootLocalFolder(), (String)MODES_FOLDER);
            }
            return this.modesLocalFolder;
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_ModesFolder", (Object)MODES_FOLDER);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            throw iOException;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getSource();
            this.removeTopComponentForDataObject((DataObject)object);
        }
    }

    public boolean isTopComponentPersistentWhenClosed(TopComponent topComponent) {
        int n = topComponent.getPersistenceType();
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTopComponentForDataObject(DataObject dataObject) {
        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (instanceCookie == null) {
            Object object = this.LOCK_IDS;
            synchronized (object) {
                TopComponent topComponent;
                Reference<TopComponent> reference;
                String string = this.dataobjectToTopComponentMap.remove(dataObject);
                if (string != null && (reference = this.id2TopComponentMap.remove(string)) != null && (topComponent = reference.get()) != null) {
                    this.topComponent2IDMap.remove(topComponent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGlobalTopComponentID(TopComponent topComponent, String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            String string2 = this.topComponent2IDMap.get(topComponent);
            if (string2 != null) {
                if (this.isInvalidId(string2)) {
                    this.restorePair(topComponent, string2);
                }
                return string2;
            }
            string2 = this.topComponentNonPersistent2IDMap.get(topComponent);
            if (string2 != null) {
                return string2;
            }
        }
        if (this.isTopComponentProbablyPersistent(topComponent)) {
            try {
                return this.createTopComponentPersistentID(topComponent, string);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "[PersistenceManager.getGlobalTopComponentID]: Cannot create TC ID", iOException);
                return this.createTopComponentNonPersistentID(topComponent, string);
            }
        }
        return this.createTopComponentNonPersistentID(topComponent, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGlobalTopComponentID(String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.id2TopComponentMap.remove(string);
            this.id2TopComponentNonPersistentMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopComponent getTopComponentPersistentForID(String string, boolean bl) {
        block19: {
            Object object;
            DataObject dataObject;
            Object object2 = this.LOCK_IDS;
            synchronized (object2) {
                dataObject = this.id2TopComponentMap.get(string);
                if (dataObject != null) {
                    object = dataObject.get();
                    if (object != null) {
                        return object;
                    }
                    this.id2TopComponentMap.remove(string);
                }
            }
            if (!bl) {
                return null;
            }
            object2 = null;
            try {
                dataObject = PersistenceManager.findTopComponentDataObject(this.getComponentsLocalFolder(), string);
                if (dataObject == null) {
                    dataObject = PersistenceManager.findTopComponentDataObject(this.getComponentsModuleFolder(), string);
                }
                if (dataObject != null) {
                    object = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                    if (object != null) {
                        TopComponent topComponent = (TopComponent)object.instanceCreate();
                        Object object3 = this.LOCK_IDS;
                        synchronized (object3) {
                            this.topComponent2IDMap.put(topComponent, string);
                            this.id2TopComponentMap.put(string, new TopComponentReference(topComponent, string));
                            this.dataobjectToTopComponentMap.put(dataObject, string);
                        }
                        dataObject.addPropertyChangeListener((PropertyChangeListener)this);
                        return topComponent;
                    }
                    String string2 = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_BrokenTCSetting", (Object)string);
                    object2 = new SafeException((Exception)new IOException(string2));
                    LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + string2, (Throwable)object2);
                    break block19;
                }
                object = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_FailedLocateTC", (Object)string);
                object2 = new FileNotFoundException((String)object);
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + (String)object);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + noClassDefFoundError.getMessage(), noClassDefFoundError);
            }
            catch (InvalidObjectException invalidObjectException) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + invalidObjectException.getMessage(), invalidObjectException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + " Object not found: " + dataObjectNotFoundException.getMessage() + ". It was probably deleted.", dataObjectNotFoundException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + classCastException.getMessage(), classCastException);
            }
            catch (IOException iOException) {
                LOG.log(this.warningLevelForDeserTC(string), "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + string + "'. Reason: " + iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    private Level warningLevelForDeserTC(String string) {
        return this.warnedIDs.add(string) ? Level.INFO : Level.FINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopComponent getTopComponentNonPersistentForID(String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            WeakReference weakReference = (WeakReference)this.id2TopComponentNonPersistentMap.get(string);
            if (weakReference != null) {
                TopComponent topComponent = (TopComponent)weakReference.get();
                if (topComponent != null) {
                    return topComponent;
                }
                this.id2TopComponentNonPersistentMap.remove(string);
            }
            return null;
        }
    }

    public TopComponent getTopComponentForID(String string, boolean bl) {
        TopComponent topComponent = this.getTopComponentNonPersistentForID(string);
        if (topComponent == null) {
            return this.getTopComponentPersistentForID(string, bl);
        }
        return topComponent;
    }

    private static DataObject findTopComponentDataObject(FileObject fileObject, String string) throws IOException {
        DataFolder dataFolder;
        FileObject fileObject2 = fileObject.getFileObject(string, COMPONENT_EXT);
        if (fileObject2 == null) {
            fileObject2 = fileObject.getFileObject(string, "ser");
        }
        if (fileObject2 == null) {
            fileObject2 = fileObject.getFileObject(string, "xml");
        }
        if (fileObject2 != null) {
            return DataObject.find((FileObject)fileObject2);
        }
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            dataFolder = DataObject.find((FileObject)fileObject2);
            if (!dataFolder.getName().equals(string)) continue;
            return dataFolder;
        }
        dataFolder = DataFolder.findFolder((FileObject)fileObject);
        enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!dataObject.getName().equals(string)) continue;
            return dataObject;
        }
        return null;
    }

    private boolean isTopComponentProbablyPersistent(TopComponent topComponent) {
        int n = topComponent.getPersistenceType();
        return 2 != n;
    }

    public boolean isTopComponentPersistent(TopComponent topComponent) {
        int n = topComponent.getPersistenceType();
        return 2 != n && (1 != n || topComponent.isOpened());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTopComponents(WindowManagerConfig windowManagerConfig) {
        HashMap<String, Reference<TopComponent>> hashMap;
        DataFolder dataFolder;
        try {
            dataFolder = DataFolder.findFolder((FileObject)this.getComponentsLocalFolder());
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "[PersistenceManager.saveTopComponents] Cannot get components folder", iOException);
            return;
        }
        Iterator iterator = this.LOCK_IDS;
        synchronized (iterator) {
            hashMap = new HashMap<String, Reference<TopComponent>>(this.id2TopComponentMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            String string;
            TopComponent topComponent = (TopComponent)((Reference)entry.getValue()).get();
            if (topComponent == null || !topComponent.isOpened() && !this.isTopComponentPersistentWhenClosed(topComponent)) continue;
            try {
                FileObject fileObject = dataFolder.getPrimaryFile().getFileObject((String)entry.getKey(), COMPONENT_EXT);
                string = null;
                if (fileObject != null) {
                    string = DataObject.find((FileObject)fileObject);
                }
                if (string == null) {
                    InstanceDataObject.create((DataFolder)dataFolder, (String)PersistenceManager.unescape((String)entry.getKey()), (Object)topComponent, null);
                    continue;
                }
                object = (SaveCookie)string.getCookie(SaveCookie.class);
                if (object != null) {
                    object.save();
                    continue;
                }
                string.delete();
                InstanceDataObject.create((DataFolder)dataFolder, (String)PersistenceManager.unescape((String)entry.getKey()), (Object)topComponent, null);
            }
            catch (NotSerializableException notSerializableException) {
                string = this.topComponent2IDMap.get(topComponent);
                LOG.log(Level.INFO, "TopComponent " + string + " is not serializable.", notSerializableException);
                this.removeTCFromConfig(windowManagerConfig, string);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
                string = this.topComponent2IDMap.get(topComponent);
                this.removeTCFromConfig(windowManagerConfig, string);
            }
            catch (RuntimeException runtimeException) {
                string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_CannotSaveTCSettings", (Object)topComponent.getName());
                Exceptions.attachLocalizedMessage((Throwable)runtimeException, (String)string);
                LOG.log(Level.INFO, null, runtimeException);
                object = this.topComponent2IDMap.get(topComponent);
                this.removeTCFromConfig(windowManagerConfig, (String)object);
            }
            catch (LinkageError linkageError) {
                string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_CannotSaveTCSettings", (Object)topComponent.getName());
                Exceptions.attachLocalizedMessage((Throwable)linkageError, (String)string);
                LOG.log(Level.INFO, null, linkageError);
                object = this.topComponent2IDMap.get(topComponent);
                this.removeTCFromConfig(windowManagerConfig, (String)object);
            }
        }
    }

    private static FileObject findTopComponentRefFile(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string, TCREF_EXT);
        if (fileObject2 != null) {
            return fileObject2;
        }
        for (FileObject fileObject3 : fileObject.getChildren()) {
            if (!fileObject3.isFolder() || (fileObject2 = PersistenceManager.findTopComponentRefFile(fileObject3, string)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    private static String escape(String string) {
        try {
            Method method = InstanceDataObject.class.getDeclaredMethod("escapeAndCut", String.class);
            method.setAccessible(true);
            return (String)method.invoke(null, string);
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Escape support failed", exception);
            return string;
        }
    }

    private static String unescape(String string) {
        try {
            Method method = InstanceDataObject.class.getDeclaredMethod("unescape", String.class);
            method.setAccessible(true);
            return (String)method.invoke(null, string);
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Escape support failed", exception);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTopComponentNonPersistentID(TopComponent topComponent, String string) {
        String string2;
        String string3 = string2 = string != null ? string : null;
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT_TC_NAME;
        }
        boolean bl = true;
        String string4 = string2 = PersistenceManager.escape(string2);
        int n = 1;
        Object object = this.LOCK_IDS;
        synchronized (object) {
            while (bl) {
                bl = false;
                if (!this.globalIDSet.contains(string4.toUpperCase(Locale.ENGLISH))) continue;
                bl = true;
                string4 = string2 + "_" + n;
                ++n;
            }
            this.topComponentNonPersistent2IDMap.put(topComponent, string4);
            this.id2TopComponentNonPersistentMap.put(string4, new WeakReference<TopComponent>(topComponent));
            this.globalIDSet.add(string4.toUpperCase(Locale.ENGLISH));
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTopComponentPersistentID(TopComponent topComponent, String string) throws IOException {
        String string2;
        String string3 = string2 = string != null ? string : null;
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT_TC_NAME;
        }
        boolean bl = true;
        String string4 = string2;
        String string5 = string2 = PersistenceManager.escape(string2);
        int n = 1;
        Object object = this.LOCK_IDS;
        synchronized (object) {
            while (bl) {
                bl = false;
                String string6 = FileUtil.findFreeFileName((FileObject)this.getComponentsLocalFolder(), (String)string5, (String)COMPONENT_EXT);
                if (string5.equals(string6) && !this.globalIDSet.contains(string6.toUpperCase(Locale.ENGLISH))) continue;
                bl = true;
                string5 = PersistenceManager.escape(string4 + "_" + n);
                ++n;
            }
            this.topComponent2IDMap.put(topComponent, string5);
            this.id2TopComponentMap.put(string5, new TopComponentReference(topComponent, string5));
            this.globalIDSet.add(string5.toUpperCase(Locale.ENGLISH));
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String restorePair(TopComponent topComponent, String string) {
        FileObject fileObject = null;
        try {
            fileObject = this.getComponentsLocalFolder();
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "[PersistenceManager.restorePair] Cannot get components folder", iOException);
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(string, COMPONENT_EXT);
        if (fileObject2 != null) {
            Object object = this.LOCK_IDS;
            synchronized (object) {
                this.id2TopComponentMap.put(string, new TopComponentReference(topComponent, string));
                this.validateId(string);
            }
            return string;
        }
        return null;
    }

    private boolean isInvalidId(String string) {
        return this.invalidIds.contains(string);
    }

    private void validateId(String string) {
        if (this.invalidIds != null) {
            this.invalidIds.remove(string);
        }
    }

    public void annotatePersistenceError(Exception exception, String string) {
        if (this.failedCompsMap == null) {
            this.failedCompsMap = new HashMap<Exception, String>();
        }
        this.failedCompsMap.put(exception, string);
    }

    public void checkPersistenceErrors(boolean bl) {
        if (this.failedCompsMap == null || this.failedCompsMap.isEmpty()) {
            return;
        }
        for (Exception exception : this.failedCompsMap.keySet()) {
            String string = this.failedCompsMap.get(exception);
            String string2 = NbBundle.getMessage(PersistenceManager.class, (String)(bl ? "FMT_TCReadError" : "FMT_TCWriteError"), (Object)string);
            Exceptions.attachLocalizedMessage((Throwable)exception, (String)string2);
            LOG.log(Level.INFO, null, exception);
        }
        this.failedCompsMap = null;
    }

    public WindowManagerParser getWindowManagerParser() {
        if (this.windowManagerParser == null) {
            this.windowManagerParser = new WindowManagerParser(this, WINDOWMANAGER_FOLDER);
        }
        return this.windowManagerParser;
    }

    public XMLReader getXMLParser(DefaultHandler defaultHandler) throws SAXException {
        if (this.parser == null) {
            this.parser = XMLUtil.createXMLReader();
            this.parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException {
                    if ("-//NetBeans//DTD Mode Properties 1.0//EN".equals(string) || "-//NetBeans//DTD Mode Properties 1.1//EN".equals(string) || "-//NetBeans//DTD Mode Properties 1.2//EN".equals(string) || "-//NetBeans//DTD Mode Properties 2.0//EN".equals(string) || "-//NetBeans//DTD Mode Properties 2.1//EN".equals(string) || "-//NetBeans//DTD Mode Properties 2.2//EN".equals(string) || "-//NetBeans//DTD Mode Properties 2.3//EN".equals(string) || "-//NetBeans//DTD Group Properties 2.0//EN".equals(string) || "-//NetBeans//DTD Top Component in Group Properties 2.0//EN".equals(string) || "-//NetBeans//DTD Top Component in Mode Properties 1.0//EN".equals(string) || "-//NetBeans//DTD Top Component in Mode Properties 2.0//EN".equals(string) || "-//NetBeans//DTD Top Component in Mode Properties 2.1//EN".equals(string) || "-//NetBeans//DTD Top Component in Mode Properties 2.2//EN".equals(string) || "-//NetBeans//DTD Window Manager Properties 1.0//EN".equals(string) || "-//NetBeans//DTD Window Manager Properties 1.1//EN".equals(string) || "-//NetBeans//DTD Window Manager Properties 2.0//EN".equals(string) || "-//NetBeans//DTD Window Manager Properties 2.1//EN".equals(string)) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                        return new InputSource(byteArrayInputStream);
                    }
                    return null;
                }
            });
        }
        this.parser.setContentHandler(defaultHandler);
        this.parser.setErrorHandler(defaultHandler);
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsedTCId(String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsedTCId(String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsedTCId(String string) {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            return this.usedTcIds.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUsedTCId() throws IOException {
        String string;
        for (FileObject fileObject : this.getComponentsLocalFolder().getChildren()) {
            boolean bl;
            if (fileObject.isFolder() || !COMPONENT_EXT.equals(fileObject.getExt())) continue;
            string = fileObject.getName();
            Object object = this.LOCK_IDS;
            synchronized (object) {
                bl = this.usedTcIds.contains(string);
            }
            if (bl) continue;
            PersistenceManager.deleteOneFO(fileObject);
        }
        for (FileObject fileObject : this.getComponentsLocalFolder().getChildren()) {
            if (fileObject.isFolder() || !COMPONENT_EXT.equals(fileObject.getExt())) continue;
            string = fileObject.getName();
            Object object = this.LOCK_IDS;
            synchronized (object) {
                this.globalIDSet.add(string.toUpperCase(Locale.ENGLISH));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerConfig loadWindowSystem() throws IOException {
        Object object = this.LOCK_IDS;
        synchronized (object) {
            this.usedTcIds.clear();
        }
        this.copySettingsFiles();
        object = this.getWindowManagerParser();
        WindowManagerConfig windowManagerConfig = ((WindowManagerParser)object).load();
        this.checkUsedTCId();
        if (this.changeHandler == null) {
            this.changeHandler = new ModuleChangeHandler();
            this.changeHandler.startHandling();
        }
        this.parser = null;
        return windowManagerConfig;
    }

    public void saveWindowSystem(WindowManagerConfig windowManagerConfig) {
        WindowManagerParser windowManagerParser = this.getWindowManagerParser();
        try {
            this.saveTopComponents(windowManagerConfig);
            windowManagerParser.save(windowManagerConfig);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
    }

    private void removeTCFromConfig(WindowManagerConfig windowManagerConfig, String string) {
        int n;
        boolean bl;
        int n2;
        boolean bl2 = false;
        for (n2 = 0; n2 < windowManagerConfig.tcIdViewList.length; ++n2) {
            if (!string.equals(windowManagerConfig.tcIdViewList[n2])) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            ArrayList<String> arrayList = new ArrayList<String>(windowManagerConfig.tcIdViewList.length);
            for (int i = 0; i < windowManagerConfig.tcIdViewList.length; ++i) {
                if (string.equals(windowManagerConfig.tcIdViewList[i])) continue;
                arrayList.add(windowManagerConfig.tcIdViewList[i]);
            }
            windowManagerConfig.tcIdViewList = arrayList.toArray(new String[arrayList.size()]);
        }
        for (n2 = 0; n2 < windowManagerConfig.modes.length; ++n2) {
            ModeConfig modeConfig = windowManagerConfig.modes[n2];
            if (string.equals(modeConfig.selectedTopComponentID)) {
                modeConfig.selectedTopComponentID = "";
            }
            if (string.equals(modeConfig.previousSelectedTopComponentID)) {
                modeConfig.previousSelectedTopComponentID = "";
            }
            bl = false;
            for (int i = 0; i < modeConfig.tcRefConfigs.length; ++i) {
                if (!string.equals(modeConfig.tcRefConfigs[i].tc_id)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            ArrayList<TCRefConfig> arrayList = new ArrayList<TCRefConfig>(modeConfig.tcRefConfigs.length);
            for (n = 0; n < modeConfig.tcRefConfigs.length; ++n) {
                if (string.equals(modeConfig.tcRefConfigs[n].tc_id)) continue;
                arrayList.add(modeConfig.tcRefConfigs[n]);
            }
            modeConfig.tcRefConfigs = arrayList.toArray(new TCRefConfig[arrayList.size()]);
        }
        for (n2 = 0; n2 < windowManagerConfig.groups.length; ++n2) {
            GroupConfig groupConfig = windowManagerConfig.groups[n2];
            bl = false;
            for (int i = 0; i < groupConfig.tcGroupConfigs.length; ++i) {
                if (!string.equals(groupConfig.tcGroupConfigs[i].tc_id)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            ArrayList<TCGroupConfig> arrayList = new ArrayList<TCGroupConfig>(groupConfig.tcGroupConfigs.length);
            for (n = 0; n < groupConfig.tcGroupConfigs.length; ++n) {
                if (string.equals(groupConfig.tcGroupConfigs[n].tc_id)) continue;
                arrayList.add(groupConfig.tcGroupConfigs[n]);
            }
            groupConfig.tcGroupConfigs = arrayList.toArray(new TCGroupConfig[arrayList.size()]);
        }
    }

    private void copySettingsFiles() throws IOException {
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFiles ENTER");
        }
        HashSet<String> hashSet = new HashSet<String>(100);
        FileObject[] fileObjectArray = this.getComponentsLocalFolder().getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isFolder() || !COMPONENT_EXT.equals(fileObjectArray[i].getExt())) continue;
            hashSet.add(fileObjectArray[i].getName());
        }
        FileObject[] fileObjectArray2 = this.getComponentsModuleFolder().getChildren();
        for (int i = 0; i < fileObjectArray2.length; ++i) {
            if (fileObjectArray2[i].isFolder() || !COMPONENT_EXT.equals(fileObjectArray2[i].getExt()) || hashSet.contains(fileObjectArray2[i].getName())) continue;
            this.copySettingsFile(fileObjectArray2[i]);
        }
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFiles LEAVE");
        }
    }

    private void copySettingsFile(FileObject fileObject) throws IOException {
        if (DEBUG) {
            Debug.log(PersistenceManager.class, "copySettingsFile fo:" + fileObject);
        }
        FileObject fileObject2 = this.getComponentsLocalFolder();
        try {
            fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_CopyFails", (Object)fileObject2);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            LOG.log(Level.INFO, null, iOException);
        }
    }

    void copySettingsFileIfNeeded(FileObject fileObject) throws IOException {
        FileObject fileObject2 = this.getComponentsLocalFolder().getFileObject(fileObject.getNameExt());
        if (fileObject2 == null) {
            this.copySettingsFile(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOneFO(FileObject fileObject) {
        FileLock fileLock = null;
        if (fileObject.isValid()) {
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    @Deprecated
    static final ModuleInfo findModule(String string, String string2, String string3) {
        SpecificationVersion specificationVersion = null;
        int n = -1;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.INFO, null, numberFormatException);
            }
        }
        if (string3 != null) {
            specificationVersion = new SpecificationVersion(string3);
        }
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        for (ModuleInfo moduleInfo : result.allInstances()) {
            if (!moduleInfo.getCodeNameBase().equals(string)) continue;
            if (n < 0 && specificationVersion == null || moduleInfo.getCodeNameRelease() >= n) {
                return moduleInfo;
            }
            if (n >= 0 && moduleInfo.getCodeNameRelease() != n) continue;
            if (specificationVersion == null) {
                return moduleInfo;
            }
            if (moduleInfo.getSpecificationVersion() == null || moduleInfo.getSpecificationVersion().compareTo((Object)specificationVersion) < 0) continue;
            return moduleInfo;
        }
        return null;
    }

    public static String escapeTcId4XmlContent(String string) {
        if (string.indexOf(38) != -1 || string.indexOf(39) != -1) {
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("'", "&apos;");
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopComponentReference
    extends WeakReference<TopComponent>
    implements Runnable {
        private final String tcID;

        public TopComponentReference(TopComponent topComponent, String string) {
            super(topComponent, Utilities.activeReferenceQueue());
            this.tcID = string;
        }

        @Override
        public void run() {
            PersistenceManager.this.removeGlobalTopComponentID(this.tcID);
        }
    }
}

