/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RecentViewList;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.PersistenceObserver;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowManagerImpl
extends WindowManager
implements Workspace {
    public static final String PROP_ACTIVE_MODE = "activeMode";
    public static final String PROP_MAXIMIZED_MODE = "maximizedMode";
    public static final String PROP_EDITOR_AREA_STATE = "editorAreaState";
    private static final Object LOCK_INIT = new Object();
    private static WindowManagerImpl defaultInstance;
    private final Central central = new Central();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final RecentViewList recentViewList = new RecentViewList(this);
    private TopComponent persistenceShowingTC;
    private Exclusive exclusive = new Exclusive();
    private static final boolean NAME_HACK;
    private static final String ASSERTION_ERROR_MESSAGE = "WindowsAPI is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerImpl() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance != null) {
                throw new IllegalStateException("Instance already exists");
            }
            defaultInstance = this;
        }
    }

    public static WindowManagerImpl getInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        return (WindowManagerImpl)((Object)Lookup.getDefault().lookup(WindowManager.class));
    }

    public void topComponentRequestAttention(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
        this.central.topComponentRequestAttention(modeImpl, topComponent);
    }

    public void topComponentCancelRequestAttention(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
        this.central.topComponentCancelRequestAttention(modeImpl, topComponent);
    }

    public Frame getMainWindow() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.central.getMainWindow();
    }

    public void updateUI() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        this.central.updateUI();
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return null;
    }

    public Workspace createWorkspace(String string, String string2) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace findWorkspace(String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace[] getWorkspaces() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return new Workspace[]{this};
    }

    public void setWorkspaces(Workspace[] workspaceArray) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
    }

    public Workspace getCurrentWorkspace() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public TopComponentGroup findTopComponentGroup(String string) {
        WindowManagerImpl.assertEventDispatchThread();
        for (TopComponentGroupImpl topComponentGroupImpl : this.getTopComponentGroups()) {
            if (!topComponentGroupImpl.getName().equals(string)) continue;
            return topComponentGroupImpl;
        }
        return null;
    }

    public TopComponent findTopComponent(String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getTopComponentForID(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return "FakeWorkspace";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WindowManagerImpl.class, (String)"LBL_FakeWorkspace");
    }

    public Set<? extends ModeImpl> getModes() {
        return this.central.getModes();
    }

    public Rectangle getBounds() {
        if (this.getEditorAreaState() == 0) {
            return this.getMainWindowBoundsJoined();
        }
        return this.getMainWindowBoundsSeparated();
    }

    public void activate() {
    }

    public Mode createMode(String string, String string2, URL uRL) {
        if (this.getEditorAreaState() == 0) {
            return new WrapMode(this.createMode(string, 1, 0, false, null));
        }
        return this.createMode(string, 0, 1, false, new SplitConstraint[]{new SplitConstraint(1, 1, 0.2)});
    }

    public Mode findMode(String string) {
        return this.findModeImpl(string);
    }

    public Mode findMode(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.containsTopComponent(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public void remove() {
    }

    public void addTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.addTopComponentGroup(topComponentGroupImpl);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.removeTopComponentGroup(topComponentGroupImpl);
    }

    public Set<TopComponentGroupImpl> getTopComponentGroups() {
        return this.central.getTopComponentGroups();
    }

    public ModeImpl createMode(String string, int n, int n2, boolean bl, SplitConstraint[] splitConstraintArray) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        if (splitConstraintArray == null && n != 2) {
            if (n == 1) {
                return this.getDefaultEditorMode();
            }
            return this.getDefaultViewMode();
        }
        modeImpl = this.createModeImpl(string, n, n2, bl);
        this.addMode(modeImpl, splitConstraintArray);
        return modeImpl;
    }

    public ModeImpl createSlidingMode(String string, boolean bl, String string2, Map<String, Integer> map) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        modeImpl = this.createModeImpl(string, 2, bl);
        this.central.addSlidingMode(modeImpl, null, string2, map);
        return modeImpl;
    }

    ModeImpl createModeImpl(String string, int n, boolean bl) {
        int n2 = this.getEditorAreaState() == 0 ? 0 : 1;
        return this.createModeImpl(string, n, n2, bl);
    }

    ModeImpl createModeImpl(String string, int n, int n2, boolean bl) {
        if (string == null) {
            string = ModeImpl.getUnusedModeName();
        }
        ModeImpl modeImpl = ModeImpl.createModeImpl(string, n2, n, bl);
        return modeImpl;
    }

    ModeImpl getDefaultEditorMode() {
        ModeImpl modeImpl = this.findModeImpl("editor");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.INFO, null, new IllegalStateException("Creating default editor mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("editor", 1, true);
            this.addMode(modeImpl2, new SplitConstraint[0]);
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultViewMode() {
        ModeImpl modeImpl = this.findModeImpl("explorer");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.INFO, null, new IllegalStateException("Creating default view mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("explorer", 0, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultSlidingMode() {
        ModeImpl modeImpl = this.findModeImpl("sliding");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.INFO, null, new IllegalStateException("Creating default sliding mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("sliding", 2, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    private ModeImpl findModeImpl(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!string.equals(modeImpl.getName())) continue;
            return modeImpl;
        }
        return null;
    }

    public TopComponent getSelectedTopComponent(Mode mode) {
        return this.central.getModeSelectedTopComponent((ModeImpl)mode);
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.central.getMainWindowBoundsJoined();
    }

    public void setMainWindowBoundsJoined(Rectangle rectangle) {
        this.central.setMainWindowBoundsJoined(rectangle);
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.central.getMainWindowBoundsSeparated();
    }

    public void setMainWindowBoundsSeparated(Rectangle rectangle) {
        this.central.setMainWindowBoundsSeparated(rectangle);
    }

    public int getMainWindowFrameStateJoined() {
        return this.central.getMainWindowFrameStateJoined();
    }

    public void setMainWindowFrameStateJoined(int n) {
        this.central.setMainWindowFrameStateJoined(n);
    }

    public int getMainWindowFrameStateSeparated() {
        return this.central.getMainWindowFrameStateSeparated();
    }

    public void setMainWindowFrameStateSeparated(int n) {
        this.central.setMainWindowFrameStateSeparated(n);
    }

    public ModeImpl getActiveMode() {
        return this.central.getActiveMode();
    }

    public void setActiveMode(ModeImpl modeImpl) {
        this.central.setActiveMode(modeImpl);
    }

    public void setEditorAreaBounds(Rectangle rectangle) {
        this.central.setEditorAreaBounds(rectangle);
    }

    public Rectangle getEditorAreaBounds() {
        return this.central.getEditorAreaBounds();
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        this.central.setEditorAreaConstraints(splitConstraintArray);
    }

    public Component getEditorAreaComponent() {
        return this.central.getEditorAreaComponent();
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.central.getEditorAreaConstraints();
    }

    public void setEditorAreaState(int n) {
        this.setEditorAreaStateImpl(n);
    }

    void setEditorAreaStateImpl(int n) {
        this.central.setEditorAreaState(n);
    }

    public int getEditorAreaState() {
        return this.central.getEditorAreaState();
    }

    public void setEditorAreaFrameState(int n) {
        this.central.setEditorAreaFrameState(n);
    }

    public int getEditorAreaFrameState() {
        return this.central.getEditorAreaFrameState();
    }

    public void switchMaximizedMode(ModeImpl modeImpl) {
        this.central.switchMaximizedMode(modeImpl);
    }

    public void setEditorMaximizedMode(ModeImpl modeImpl) {
        this.central.setEditorMaximizedMode(modeImpl);
    }

    public void setViewMaximizedMode(ModeImpl modeImpl) {
        this.central.setViewMaximizedMode(modeImpl);
    }

    public ModeImpl getCurrentMaximizedMode() {
        return this.central.getCurrentMaximizedMode();
    }

    public ModeImpl getEditorMaximizedMode() {
        return this.central.getEditorMaximizedMode();
    }

    public ModeImpl getViewMaximizedMode() {
        return this.central.getViewMaximizedMode();
    }

    public void setModeConstraints(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        this.central.setModeConstraints(modeImpl, splitConstraintArray);
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        return this.central.getModeConstraints(modeImpl);
    }

    private void addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (modeImpl.getKind() == 2) {
            this.central.addSlidingMode(modeImpl, null, "left", null);
        } else {
            this.central.addMode(modeImpl, splitConstraintArray);
        }
    }

    public void removeMode(ModeImpl modeImpl) {
        if (modeImpl.getKind() != 2) {
            this.central.removeMode(modeImpl);
        }
    }

    public void setToolbarConfigName(String string) {
        this.central.setToolbarConfigName(string);
    }

    public String getToolbarConfigName() {
        return this.central.getToolbarConfigName();
    }

    public void setVisible(boolean bl) {
        SwingUtilities.invokeLater(this.exclusive);
        this.central.setVisible(bl);
    }

    public boolean isVisible() {
        return this.central.isVisible();
    }

    public void attachTopComponentToSide(TopComponent topComponent, ModeImpl modeImpl, String string) {
        this.central.attachTopComponentsToSide(new TopComponent[]{topComponent}, modeImpl, string);
    }

    public TopComponent getTopComponentForID(String string) {
        return PersistenceHandler.getDefault().getTopComponentForID(string, true);
    }

    public boolean isTopComponentAllowedToMoveAnywhere(TopComponent topComponent) {
        return Boolean.TRUE.equals(topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere"));
    }

    public ModeImpl findModeForOpenedID(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getOpenedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl findModeForClosedID(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getClosedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public String getTopComponentDisplayName(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        String string = topComponent.getHtmlDisplayName();
        if (string == null) {
            string = topComponent.getDisplayName();
        }
        if (string == null) {
            string = topComponent.getName();
        }
        if (NAME_HACK && string != null) {
            if (string.endsWith("*")) {
                if (string.startsWith("<html>")) {
                    string = string.substring(6);
                }
                string = "<html><b>" + string.substring(0, string.length() - 2);
            } else {
                int n = string.indexOf("[r/o]");
                if (n > 0) {
                    if (string.startsWith("<html>")) {
                        string = string.substring(6);
                        n -= 6;
                    }
                    int n2 = "[r/o]".length();
                    String string2 = "<html><font color='#555555'><i>" + string.substring(0, n - 1);
                    if (n + n2 < string.length()) {
                        string2 = string2 + string.substring(n + n2);
                    }
                    string = string2;
                }
            }
        }
        return string;
    }

    Central getCentral() {
        return this.central;
    }

    public boolean isDragInProgress() {
        return this.central.isDragInProgress();
    }

    public String guessSlideSide(TopComponent topComponent) {
        return this.central.guessSlideSide(topComponent);
    }

    public boolean isDocked(TopComponent topComponent) {
        return this.central.isDocked(topComponent);
    }

    public void userUndockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        if (!this.isDocked(topComponent)) {
            throw new IllegalStateException("TopComponent is already in floating state: " + topComponent);
        }
        this.central.userUndockedTopComponent(topComponent, modeImpl);
    }

    public void userDockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        if (this.isDocked(topComponent)) {
            throw new IllegalStateException("TopComponent is already inside main window: " + topComponent);
        }
        this.central.userDockedTopComponent(topComponent, modeImpl);
    }

    public void setRecentViewList(TopComponent[] topComponentArray) {
        this.recentViewList.setTopComponents(topComponentArray);
    }

    public TopComponent[] getRecentViewList() {
        return this.recentViewList.getTopComponents();
    }

    void doFirePropertyChange(final String string, final Object object, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.firePropertyChange(string, object, object2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.this.changeSupport.firePropertyChange(string, object, object2);
                }
            });
        }
    }

    public PersistenceObserver getPersistenceObserver() {
        return PersistenceHandler.getDefault();
    }

    public void notifyTopComponentOpened(TopComponent topComponent) {
        this.componentOpenNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentOpened(topComponent);
    }

    public void notifyTopComponentClosed(TopComponent topComponent) {
        this.componentCloseNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentClosed(topComponent);
    }

    static void notifyRegistryTopComponentActivated(final TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentActivated(topComponent);
        if (SwingUtilities.isEventDispatchThread()) {
            WindowManagerImpl.getInstance().activateComponent(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().activateComponent(topComponent);
                }
            });
        }
    }

    private static void notifyRegistryTopComponentOpened(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentOpened(topComponent);
    }

    private static void notifyRegistryTopComponentClosed(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentClosed(topComponent);
    }

    private static void notifyRegistrySelectedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).selectedNodesChanged(topComponent, nodeArray);
    }

    public void componentShowing(TopComponent topComponent) {
        if (topComponent != null && topComponent != this.persistenceShowingTC) {
            super.componentShowing(topComponent);
        }
    }

    void specialPersistenceCompShow(TopComponent topComponent) {
        this.componentShowing(topComponent);
        this.persistenceShowingTC = topComponent;
    }

    public void componentHidden(TopComponent topComponent) {
        if (topComponent != null) {
            super.componentHidden(topComponent);
            if (topComponent == this.persistenceShowingTC) {
                this.persistenceShowingTC = null;
            }
        }
    }

    protected void topComponentOpen(TopComponent topComponent) {
        this.topComponentOpenAtTabPosition(topComponent, -1);
    }

    protected void topComponentOpenAtTabPosition(TopComponent topComponent, int n) {
        String string;
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (topComponent == null) {
            throw new IllegalArgumentException("Cannot open a null TopComponent");
        }
        ModeImpl modeImpl = this.getMode(topComponent);
        if (modeImpl == null) {
            modeImpl = this.getDefaultEditorMode();
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
        }
        boolean bl = modeImpl.getOpenedTopComponents().contains(topComponent);
        ModeImpl modeImpl2 = this.getCurrentMaximizedMode();
        if (modeImpl2 != null && modeImpl != modeImpl2 && modeImpl.getKind() != 2 && this.central.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        if (n == -1) {
            modeImpl.addOpenedTopComponent(topComponent);
        } else {
            modeImpl.addOpenedTopComponent(topComponent, n);
        }
        if (this.central.isEditorMaximized() && !bl && modeImpl.getState() != 1 && !this.isTopComponentDockedInMaximizedMode(string = this.findTopComponentID(topComponent)) && modeImpl.getKind() == 0) {
            this.central.slide(topComponent, modeImpl, this.central.getSlideSideForMode(modeImpl));
            this.topComponentRequestActive(topComponent);
        }
    }

    protected int topComponentGetTabPosition(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            return modeImpl.getTopComponentTabPosition(topComponent);
        }
        return -1;
    }

    protected void topComponentClose(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        boolean bl = this.topComponentIsOpened(topComponent);
        if (!bl) {
            return;
        }
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            if (modeImpl == this.central.getCurrentMaximizedMode() && this.central.isViewMaximized()) {
                this.central.switchMaximizedMode(null);
                this.topComponentClose(topComponent);
            } else {
                modeImpl.close(topComponent);
            }
        }
    }

    protected void topComponentRequestActive(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.activateModeTopComponent(modeImpl, topComponent);
        }
    }

    protected void topComponentRequestVisible(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.setModeSelectedTopComponent(modeImpl, topComponent);
        }
    }

    protected void topComponentDisplayNameChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentDisplayNameChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentHtmlDisplayNameChanged(TopComponent topComponent, String string) {
        this.topComponentDisplayNameChanged(topComponent, null);
    }

    protected void topComponentToolTipChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentToolTipChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentIconChanged(TopComponent topComponent, Image image) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentIconChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentActivatedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        WindowManagerImpl.notifyRegistrySelectedNodesChanged(topComponent, nodeArray);
    }

    protected boolean topComponentIsOpened(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getModeForOpenedTopComponent(topComponent) != null;
    }

    protected Action[] topComponentDefaultActions(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ActionUtils.createDefaultPopupActions(topComponent);
    }

    protected String topComponentID(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (string == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.WARNING, null, new IllegalStateException("Assertion failed. " + topComponent.getClass().getName() + ".preferredID method shouldn't be overriden to return null. " + "Please change your impl to return non-null string."));
        }
        return PersistenceManager.getDefault().getGlobalTopComponentID(topComponent, string);
    }

    public void invokeWhenUIReady(Runnable runnable) {
        this.exclusive.register(runnable);
    }

    public boolean isEditorTopComponent(TopComponent topComponent) {
        if (null == topComponent) {
            return false;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.containsTopComponent(topComponent)) continue;
            return modeImpl.getKind() == 1;
        }
        return false;
    }

    public boolean isOpenedEditorTopComponent(TopComponent topComponent) {
        if (null == topComponent) {
            return false;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getOpenedTopComponents().contains(topComponent)) continue;
            return modeImpl.getKind() == 1;
        }
        return false;
    }

    public boolean isEditorMode(Mode mode) {
        if (null == mode) {
            return false;
        }
        ModeImpl modeImpl = this.findModeImpl(mode.getName());
        return null != modeImpl && modeImpl.getKind() == 1;
    }

    public void resetModel() {
        this.central.resetModel();
        RegistryImpl registryImpl = (RegistryImpl)this.componentRegistry();
        registryImpl.clear();
    }

    private ModeImpl getMode(TopComponent topComponent) {
        return (ModeImpl)this.findMode(topComponent);
    }

    private ModeImpl getModeForOpenedTopComponent(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getOpenedTopComponents().contains(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl getPreviousModeForTopComponent(String string, ModeImpl modeImpl) {
        return this.getCentral().getModeTopComponentPreviousMode(string, modeImpl);
    }

    public int getPreviousIndexForTopComponent(String string, ModeImpl modeImpl) {
        return this.getCentral().getModeTopComponentPreviousIndex(string, modeImpl);
    }

    public void setPreviousModeForTopComponent(String string, ModeImpl modeImpl, ModeImpl modeImpl2, int n) {
        this.getCentral().setModeTopComponentPreviousMode(string, modeImpl, modeImpl2, n);
    }

    public void setTopComponentDockedInMaximizedMode(String string, boolean bl) {
        this.getCentral().setTopComponentDockedInMaximizedMode(string, bl);
    }

    public boolean isTopComponentDockedInMaximizedMode(String string) {
        return this.getCentral().isTopComponentDockedInMaximizedMode(string);
    }

    public void setTopComponentSlidedInDefaultMode(String string, boolean bl) {
        this.getCentral().setTopComponentSlidedInDefaultMode(string, bl);
    }

    public boolean isTopComponentSlidedInDefaultMode(String string) {
        return this.getCentral().isTopComponentSlidedInDefaultMode(string);
    }

    public boolean isTopComponentMaximizedWhenSlidedIn(String string) {
        return this.getCentral().isTopComponentMaximizedWhenSlidedIn(string);
    }

    public void setTopComponentMaximizedWhenSlidedIn(String string, boolean bl) {
        this.getCentral().setTopComponentMaximizedWhenSlidedIn(string, bl);
    }

    public void userToggledTopComponentSlideInMaximize(String string) {
        this.getCentral().userToggledTopComponentSlideInMaximize(string);
    }

    public static boolean isSeparateWindow(Window window) {
        if (!(window instanceof RootPaneContainer)) {
            return false;
        }
        JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
        if (jRootPane == null) {
            return false;
        }
        return jRootPane.getClientProperty("SeparateWindow") != null;
    }

    static void assertEventDispatchThread() {
        assert (SwingUtilities.isEventDispatchThread()) : "WindowsAPI is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/";
    }

    static void assertEventDispatchThreadWeak() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.WARNING, null, new IllegalStateException("Assertion failed. WindowsAPI is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/"));
        }
    }

    public TopComponent[] getEditorTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        Set<? extends ModeImpl> set = this.getModes();
        for (Mode mode : set) {
            ModeImpl modeImpl = this.findModeImpl(mode.getName());
            if (modeImpl.getKind() != 1) continue;
            arrayList.addAll(modeImpl.getOpenedTopComponents());
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }

    public TopComponent getArbitrarySelectedEditorTopComponent() {
        Set<? extends ModeImpl> set = this.getModes();
        for (Mode mode : set) {
            ModeImpl modeImpl = this.findModeImpl(mode.getName());
            if (modeImpl.getKind() != 1) continue;
            return mode.getSelectedTopComponent();
        }
        return null;
    }

    public void deselectEditorTopComponents() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() != 1) continue;
            DummyTopComponent dummyTopComponent = new DummyTopComponent();
            modeImpl.addOpenedTopComponent(dummyTopComponent);
            modeImpl.setSelectedTopComponent(dummyTopComponent);
        }
    }

    public void closeNonEditorViews() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (null == modeImpl || modeImpl.getKind() == 1) continue;
            List<TopComponent> list = modeImpl.getOpenedTopComponents();
            for (TopComponent topComponent : list) {
                topComponent.close();
            }
        }
    }

    static {
        NAME_HACK = Boolean.getBoolean("nb.tabnames.html");
    }

    private static class DummyTopComponent
    extends TopComponent {
        private DummyTopComponent() {
        }

        protected String preferredID() {
            return "temp";
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    private static final class Exclusive
    implements Runnable {
        private ArrayList<Runnable> arr = new ArrayList();

        private Exclusive() {
        }

        public synchronized void register(Runnable runnable) {
            this.arr.add(runnable);
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!WindowManagerImpl.getInstance().isVisible()) {
                return;
            }
            ArrayList<Runnable> arrayList = null;
            Exclusive exclusive = this;
            synchronized (exclusive) {
                if (this.arr.isEmpty()) {
                    return;
                }
                arrayList = this.arr;
                this.arr = new ArrayList();
            }
            for (Runnable runnable : arrayList) {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.WARNING, null, runtimeException);
                }
            }
        }
    }

    private static class WrapMode
    implements Mode {
        private Mode wrap;

        public WrapMode(Mode mode) {
            this.wrap = mode;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.addPropertyChangeListener(propertyChangeListener);
        }

        public boolean canDock(TopComponent topComponent) {
            return this.wrap.canDock(topComponent);
        }

        public boolean dockInto(TopComponent topComponent) {
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
            return this.wrap.dockInto(topComponent);
        }

        public Rectangle getBounds() {
            return this.wrap.getBounds();
        }

        public String getDisplayName() {
            return this.wrap.getDisplayName();
        }

        public Image getIcon() {
            return this.wrap.getIcon();
        }

        public String getName() {
            return this.wrap.getName();
        }

        public TopComponent getSelectedTopComponent() {
            return this.wrap.getSelectedTopComponent();
        }

        public TopComponent[] getTopComponents() {
            return this.wrap.getTopComponents();
        }

        public Workspace getWorkspace() {
            return this.wrap.getWorkspace();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.removePropertyChangeListener(propertyChangeListener);
        }

        public void setBounds(Rectangle rectangle) {
            this.wrap.setBounds(rectangle);
        }
    }
}

