/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.List;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;
import org.openide.util.Exceptions;

class FCLSupport {
    ListenerList<FileChangeListener> listeners;

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(fileChangeListener);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fileEvent, Op op) {
        List<FileChangeListener> list;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getAllListeners();
        }
        for (FileChangeListener fileChangeListener : list) {
            FCLSupport.dispatchEvent(fileChangeListener, fileEvent, op);
        }
    }

    static final void dispatchEvent(FileChangeListener fileChangeListener, FileEvent fileEvent, Op op) {
        try {
            switch (op) {
                case DATA_CREATED: {
                    fileChangeListener.fileDataCreated(fileEvent);
                    break;
                }
                case FOLDER_CREATED: {
                    fileChangeListener.fileFolderCreated(fileEvent);
                    break;
                }
                case FILE_CHANGED: {
                    fileChangeListener.fileChanged(fileEvent);
                    break;
                }
                case FILE_DELETED: {
                    fileChangeListener.fileDeleted(fileEvent);
                    break;
                }
                case FILE_RENAMED: {
                    fileChangeListener.fileRenamed((FileRenameEvent)fileEvent);
                    break;
                }
                case ATTR_CHANGED: {
                    fileChangeListener.fileAttributeChanged((FileAttributeEvent)fileEvent);
                    break;
                }
                default: {
                    throw new AssertionError((Object)op);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            Exceptions.printStackTrace((Throwable)runtimeException);
        }
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.hasListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        DATA_CREATED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_DELETED,
        FILE_RENAMED,
        ATTR_CHANGED;

    }
}

