/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.NetscapeCertTypeExtension;

public class CertUtils {
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String OID_EKU_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String OID_EKU_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private static final String OID_EKU_TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    private static final String OID_CRL = "2.5.29.31";
    private static final String OID_AIA = "1.3.6.1.5.5.7.1.1";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";
    private static final String NSCT_S_MIME = "s_mime";
    private static final String NSCT_SSL_CLIENT = "ssl_client";
    private static final String NSCT_SSL_SERVER = "ssl_server";
    private static final int KU_SIGNATURE = 0;

    public static KeyStore createEmptyKeyStore() {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        return keyStore;
    }

    public static void checkUsageForCodeSigning(X509Certificate x509Certificate, int n) throws CertificateException, IOException {
        CertUtils.checkUsageForCodeSigning(x509Certificate, n, false);
    }

    public static void checkUsageForCodeSigning(X509Certificate x509Certificate, int n, boolean bl) throws CertificateException, IOException {
        String string = null;
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        if (!CertUtils.checkBasicConstraintsForCodeSigning(x509Certificate, set, n)) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints");
            string = ResourceManager.getMessage("trustdecider.check.basicconstraints");
            throw new CertificateException(string);
        }
        if (n == 0) {
            if (!CertUtils.checkLeafKeyUsageForCodeSigning(x509Certificate, set, bl)) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage");
                string = ResourceManager.getMessage("trustdecider.check.leafkeyusage");
                throw new CertificateException(string);
            }
        } else if (!CertUtils.checkSignerKeyUsage(x509Certificate, set)) {
            Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage");
            string = ResourceManager.getMessage("trustdecider.check.signerkeyusage");
            throw new CertificateException(string);
        }
        if (!set.isEmpty()) {
            Trace.msgSecurityPrintln("trustdecider.check.extensions");
            string = ResourceManager.getMessage("trustdecider.check.extensions");
            throw new CertificateException(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraintsForCodeSigning(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return true;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return true;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.certtypebit");
                return false;
            }
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            return false;
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA) || CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) && !CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.bitvalue");
            return false;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.enduser");
            return false;
        }
        if (n - 1 <= n2) return true;
        Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.pathlength");
        return false;
    }

    private static boolean checkLeafKeyUsageForCodeSigning(X509Certificate x509Certificate, Set set, boolean bl) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.length");
                return false;
            }
            boolean bl2 = blArray[0];
            if (!bl2) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.digitalsignature");
                return false;
            }
        }
        List list = X509Util.getExtendedKeyUsage(x509Certificate);
        Set<String> set2 = x509Certificate.getNonCriticalExtensionOIDs();
        if (list != null && (set.contains(OID_EXTENDED_KEY_USAGE) || set2.contains(OID_EXTENDED_KEY_USAGE))) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (bl) {
                if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_TIME_STAMPING)) {
                    Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.tsaextkeyusageinfo");
                    return false;
                }
            } else if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.extkeyusageinfo");
                return false;
            }
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && !CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING)) {
            Trace.msgSecurityPrintln("trustdecider.check.leafkeyusage.certtypebit");
            return false;
        }
        return true;
    }

    private static boolean checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.lengthandbit");
            return false;
        }
        List list = X509Util.getExtendedKeyUsage(x509Certificate);
        Set<String> set2 = x509Certificate.getNonCriticalExtensionOIDs();
        if (list != null && (set.contains(OID_EXTENDED_KEY_USAGE) || set2.contains(OID_EXTENDED_KEY_USAGE))) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                Trace.msgSecurityPrintln("trustdecider.check.signerkeyusage.keyusage");
                return false;
            }
        }
        return true;
    }

    static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private static boolean checkKeyUsage(X509Certificate x509Certificate, int n) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null) {
            return true;
        }
        return blArray.length > n && blArray[n];
    }

    private static boolean checkEKU(X509Certificate x509Certificate, String string) throws CertificateException {
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list == null) {
            return true;
        }
        return list.contains(string) || list.contains(OID_EKU_ANY_USAGE);
    }

    static boolean checkTLSClient(X509Certificate x509Certificate) throws CertificateException {
        if (!CertUtils.checkKeyUsage(x509Certificate, 0)) {
            Trace.msgSecurityPrintln("clientauth.checkTLSClient.checkKeyUsage");
            return false;
        }
        if (!CertUtils.checkEKU(x509Certificate, OID_EKU_CLIENT_AUTH)) {
            Trace.msgSecurityPrintln("clientauth.checkTLSClient.checkEKU");
            return false;
        }
        return true;
    }

    public static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    private static String extractFromQuote(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = 0;
        if (n >= 0) {
            if ((n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n)) < 0) {
                return string.substring(n);
            }
            return string.substring(n, n2);
        }
        return null;
    }

    public static String extractSubjectAliasName(X509Certificate x509Certificate) {
        String string = ResourceManager.getMessage("config.unknownSubject");
        try {
            Principal principal = x509Certificate.getSubjectDN();
            String string2 = principal.getName();
            string = CertUtils.extractFromQuote(string2, "CN=");
            if (string == null) {
                String string3 = CertUtils.extractFromQuote(string2, "O=");
                String string4 = CertUtils.extractFromQuote(string2, "OU=");
                if (string3 != null || string4 != null) {
                    MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("config.certShowOOU"));
                    Object[] objectArray = new Object[]{string3, string4};
                    if (string3 == null) {
                        objectArray[0] = "";
                    }
                    if (string4 == null) {
                        objectArray[1] = "";
                    }
                    string = messageFormat.format(objectArray);
                }
            }
            if (string == null) {
                string = ResourceManager.getMessage("config.unknownSubject");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String extractIssuerAliasName(X509Certificate x509Certificate) {
        String string = ResourceManager.getMessage("config.unknownIssuer");
        try {
            Principal principal = x509Certificate.getIssuerDN();
            String string2 = principal.getName();
            string = CertUtils.extractFromQuote(string2, "CN=");
            if (string == null) {
                String string3 = CertUtils.extractFromQuote(string2, "O=");
                String string4 = CertUtils.extractFromQuote(string2, "OU=");
                if (string3 != null || string4 != null) {
                    MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("config.certShowOOU"));
                    Object[] objectArray = new Object[]{string3, string4};
                    if (string3 == null) {
                        objectArray[0] = "";
                    }
                    if (string4 == null) {
                        objectArray[1] = "";
                    }
                    string = messageFormat.format(objectArray);
                }
            }
            if (string == null) {
                string = ResourceManager.getMessage("config.unknownIssuer");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static long getFileLastModified(final String string) {
        long l = 0L;
        try {
            l = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Long(new File(string).lastModified());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.securityPrintException(privilegedActionException);
        }
        return l;
    }

    static boolean getCertCRLExtension(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_CRL);
        if (byArray == null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.notfound");
            return false;
        }
        if (byArray[0] == 4) {
            byArray = new DerValue(byArray).getOctetString();
        }
        Trace.msgSecurityPrintln(CertUtils.extractSubjectAliasName(x509Certificate));
        CRLDistributionPointsExtension cRLDistributionPointsExtension = new CRLDistributionPointsExtension(new Boolean(false), byArray);
        Trace.msgSecurityPrintln(cRLDistributionPointsExtension.toString());
        return true;
    }

    static boolean getCertAIAExtension(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_AIA);
        if (byArray == null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.notfound");
            return false;
        }
        if (byArray[0] == 4) {
            byArray = new DerValue(byArray).getOctetString();
        }
        Trace.msgSecurityPrintln(CertUtils.extractSubjectAliasName(x509Certificate));
        AuthorityInfoAccessExtension authorityInfoAccessExtension = new AuthorityInfoAccessExtension(new Boolean(false), byArray);
        Trace.msgSecurityPrintln(authorityInfoAccessExtension.toString());
        return true;
    }

    static boolean checkWildcardDomain(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return false;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase(string = string.trim())) {
            return true;
        }
        int n = string2.indexOf("*.");
        if (n == -1) {
            return false;
        }
        String string3 = string2.substring(n + 1);
        String string4 = string2.substring(0, n);
        return !string4.contains(".") && string.indexOf(string4) == 0 && string.endsWith(string3) && string.length() >= string2.length();
    }
}

