/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPUSampledInstr
extends ProfilerRuntimeCPU {
    protected static int samplingInterval = 10;
    protected static SamplingThread st;

    public static void setSamplingInterval(int v) {
        samplingInterval = v;
    }

    public static void enableProfiling(boolean v) {
        if (v) {
            ProfilerRuntimeCPUSampledInstr.createNewDataStructures();
            ProfilerRuntimeCPU.enableProfiling(v);
        } else {
            ProfilerRuntimeCPU.enableProfiling(v);
            ProfilerRuntimeCPUSampledInstr.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void markerMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0 || ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                ti.inCallGraph = true;
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++ti.inProfilingRuntimeMethod;
            ti.inCallGraph = true;
        }
        {
            if (!instrMethodInvoked[methodId = (char)methodId]) {
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodId] = true;
            }
            ++ti.stackDepth;
            if (ti.stackDepth > 1) {
                if (!ti.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)18, ti, methodId);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, ti, methodId);
                    ti.sampleDue = false;
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, ti, methodId);
            }
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void markerMethodExit(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            if (ti.rootMethodStackDepth > 0) {
                ProfilerRuntimeCPUSampledInstr.methodExit(methodId);
            } else {
                ++ti.inProfilingRuntimeMethod;
                --ti.stackDepth;
                if (ti.stackDepth < 1) {
                    ti.inCallGraph = false;
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, ti, methodId);
                } else if (!ti.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)19, ti, methodId);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, ti, methodId);
                    ti.sampleDue = false;
                }
                --ti.inProfilingRuntimeMethod;
            }
        }
    }

    public static void methodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (!instrMethodInvoked[methodId = (char)methodId]) {
                long absTimeStamp = Timers.getCurrentTimeInCounts();
                long threadTimeStamp = Timers.getThreadCPUTimeInNanos();
                externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodId] = true;
                ProfilerRuntimeCPUSampledInstr.writeAdjustTimeEvent(ti, absTimeStamp, threadTimeStamp);
            }
            ++ti.stackDepth;
            if (!ti.sampleDue) {
                if (methodId <= '\u3fff') {
                    ProfilerRuntimeCPUSampledInstr.writeCompactEvent(ti, (char)(0x8000 | methodId));
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)16, ti, methodId);
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)6, ti, methodId);
                ti.sampleDue = false;
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void methodExit(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (ti.rootMethodStackDepth == ti.stackDepth) {
                ti.rootMethodStackDepth = 0;
            }
            --ti.stackDepth;
            if (ti.stackDepth < 1) {
                ti.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, ti, methodId);
            } else if (!ti.sampleDue) {
                if ((methodId = (char)methodId) <= '\u3fff') {
                    ProfilerRuntimeCPUSampledInstr.writeCompactEvent(ti, (char)(0xC000 | methodId));
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)17, ti, methodId);
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)7, ti, methodId);
                ti.sampleDue = false;
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rootMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ProfilerServer.notifyClientOnResultsAvailability();
        if (ti.isInitialized() && !ti.inCallGraph && ti.stackDepth > 0) {
            ti.inCallGraph = true;
            ProfilerRuntimeCPUSampledInstr.methodEntry(methodId);
            ti.inCallGraph = false;
            return;
        }
        if (ti != null && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            ProfilerRuntimeCPUSampledInstr.methodEntry(methodId);
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0) return;
            if (ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                if (!ProfilerServer.startProfilingPointsActive()) {
                    ti.inCallGraph = true;
                }
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            if (ti.stackDepth > 0) {
                ti.rootMethodStackDepth = ti.stackDepth + 1;
                ProfilerRuntimeCPUSampledInstr.methodEntry(methodId);
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (!ProfilerServer.startProfilingPointsActive()) {
                ti.inCallGraph = true;
            }
        }
        {
            methodId = methodId;
            if (!instrMethodInvoked[methodId]) {
                externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[methodId] = true;
            }
            ++ti.stackDepth;
            ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)1, ti, methodId);
            ti.rootMethodStackDepth = ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeCPU.clearDataStructures();
        if (st != null) {
            st.terminate();
        }
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeCPU.createNewDataStructures();
        st = new SamplingThread();
        st.setPriority(10);
        Threads.recordAdditionalProfilerOwnThread(st);
        st.start();
    }

    static void writeCompactEvent(ThreadInfo ti, char event) {
        ti.evBuf[ti.evBufPos++] = (byte)(event >> 8 & 0xFF);
        ti.evBuf[ti.evBufPos++] = (byte)(event & 0xFF);
        if (ti.evBufPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(ti);
        }
    }

    static void writeUnstampedEvent(byte eventType, ThreadInfo ti, char methodId) {
        byte[] evBuf = ti.evBuf;
        int curPos = ti.evBufPos;
        evBuf[curPos++] = eventType;
        evBuf[curPos++] = (byte)(methodId >> 8 & 0xFF);
        evBuf[curPos++] = (byte)(methodId & 0xFF);
        ti.evBufPos = curPos;
        if (curPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(ti);
        }
    }

    static class SamplingThread
    extends Thread {
        private static final boolean isSolaris = System.getProperty("os.name").startsWith("Sun");
        private static final boolean isLinux = System.getProperty("os.name").startsWith("Linux");
        private static final boolean isUnix = isSolaris || isLinux;
        private static final int VIOLATION_THRESHOLD = 10;
        private static final boolean DEBUG = false;
        private boolean terminated;
        private int count;

        SamplingThread() {
        }

        public void run() {
            if (isSolaris) {
                samplingInterval *= 1000000;
            } else if (isLinux) {
                samplingInterval *= 1000;
            }
            int adjustedSamplingInterval = samplingInterval;
            int upperBound = samplingInterval * 5 / 4;
            int lowerBound = samplingInterval / 10;
            int violationCount = 10;
            long startTime = Timers.getCurrentTimeInCounts();
            while (!this.terminated) {
                if (!isUnix) {
                    try {
                        Thread.sleep(samplingInterval);
                    }
                    catch (InterruptedException ex) {}
                } else {
                    long time = Timers.getCurrentTimeInCounts();
                    Timers.osSleep((int)adjustedSamplingInterval);
                    time = Timers.getCurrentTimeInCounts() - time;
                    if (time > (long)upperBound && adjustedSamplingInterval > lowerBound) {
                        if (violationCount > 0) {
                            --violationCount;
                        } else {
                            adjustedSamplingInterval = adjustedSamplingInterval * 95 / 100;
                            violationCount = 10;
                        }
                    }
                }
                ThreadInfo.setSampleDueForAllThreads();
            }
        }

        public void terminate() {
            this.terminated = true;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

