/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.profiler.common.integration.IntegrationProvider;
import org.netbeans.modules.profiler.ui.wizards.panels.ManualIntegrationPanel;
import org.netbeans.modules.profiler.ui.wizards.panels.components.StepsPanelComponent;
import org.netbeans.modules.profiler.ui.wizards.providers.TargetPlatformEnum;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ManualIntegrationPanelUI
extends JPanel
implements ListDataListener {
    private ManualIntegrationPanel.Model model;
    private DefaultListModel listModel = null;
    private JComboBox comboJvms;
    private JLabel label;
    private StepsPanelComponent stepsPanel;

    ManualIntegrationPanelUI(ManualIntegrationPanel.Model model) {
        this.model = model;
        this.initComponents();
    }

    private void initComponents() {
        this.stepsPanel = new StepsPanelComponent();
        this.comboJvms = new JComboBox();
        this.label = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(470, 300));
        this.setPreferredSize(new Dimension(500, 400));
        this.stepsPanel.setHintText(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.stepsPanel.hintText"));
        this.stepsPanel.setMinimumSize(new Dimension(400, 200));
        this.stepsPanel.setPreferredSize(new Dimension(500, 200));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/ui/wizards/panels/Bundle");
        this.stepsPanel.setTitle(bundle.getString("ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"));
        this.comboJvms.setModel(new DefaultComboBoxModel<String>(new String[]{"Java"}));
        this.comboJvms.setMaximumSize(new Dimension(470, 24));
        this.comboJvms.setMinimumSize(new Dimension(200, 24));
        this.comboJvms.setPreferredSize(new Dimension(466, 24));
        this.comboJvms.getModel().addListDataListener(this);
        this.label.setLabelFor(this.comboJvms);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)bundle.getString("TargetJVMWizardPanelUI_SelectJvmString"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.stepsPanel, -1, 476, Short.MAX_VALUE).add(1, (Component)this.label).add(1, (Component)this.comboJvms, 0, 476, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.comboJvms, -2, 24, -2).add(14, 14, 14).add((Component)this.stepsPanel, -1, 316, Short.MAX_VALUE).addContainerGap()));
        this.comboJvms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.comboJvms.AccessibleContext.accessibleDescription"));
    }

    public ComboBoxModel getJvmListModel() {
        return new DefaultComboBoxModel(){

            public Object getElementAt(int index) {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().get(index) : null;
            }

            public Object getSelectedItem() {
                return ManualIntegrationPanelUI.this.model.getJvm();
            }

            public int getSize() {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().size() : 0;
            }

            public void setSelectedItem(Object anItem) {
                ManualIntegrationPanelUI.this.model.setJvm((TargetPlatformEnum)anItem);
                ManualIntegrationPanelUI.this.showIntegrationHints();
            }
        };
    }

    public void refresh() {
        List supportedJvms = this.model.getSupportedJvms();
        TargetPlatformEnum defaultPlatform = TargetPlatformEnum.JDK5;
        if (this.model.getJvm() == null || !supportedJvms.contains(this.model.getJvm())) {
            if (!supportedJvms.contains(defaultPlatform)) {
                defaultPlatform = (TargetPlatformEnum)supportedJvms.get(0);
            }
        } else {
            defaultPlatform = this.model.getJvm();
        }
        ((DefaultComboBoxModel)this.comboJvms.getModel()).removeAllElements();
        Iterator it = this.model.getSupportedJvms().iterator();
        while (it.hasNext()) {
            ((DefaultComboBoxModel)this.comboJvms.getModel()).addElement(it.next());
        }
        this.comboJvms.setSelectedItem(defaultPlatform);
        this.showIntegrationHints();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"TargetJVMWizardPanelUI_SelectJvmString"), this.model.getApplication()));
    }

    private void showIntegrationHints() {
        IntegrationProvider.IntegrationHints hints = this.model.getIntegrationHints();
        this.stepsPanel.setTitle(MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"), this.model.getApplication()));
        this.stepsPanel.setSteps(this.model.getIntegrationHints());
    }

    public void contentsChanged(ListDataEvent e) {
        this.model.setJvm((TargetPlatformEnum)this.comboJvms.getSelectedItem());
        this.showIntegrationHints();
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }
}

