/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.framework.steps;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.ui.wizards.framework.WizardContext;
import org.netbeans.modules.profiler.ui.wizards.framework.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.ui.wizards.framework.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.ui.wizards.framework.screen.NullWizardScreen;
import org.netbeans.modules.profiler.ui.wizards.framework.screen.WizardScreen;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.NullWizardStep;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.WizardStep;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.WizardStepVisitor;

public class ProxyWizardStep
implements WizardStep {
    private ConditionalFunctor condition;
    private WizardContext context;
    private WizardStep nullStep;
    private WizardStep proxiedStep;

    public ProxyWizardStep(WizardContext context, String title) {
        this(context, title, new TrueConditionalFunctor());
    }

    public ProxyWizardStep(WizardContext context, String title, ConditionalFunctor condition) {
        this.proxiedStep = this.nullStep = new NullWizardStep(title);
        this.context = context;
        this.condition = condition;
    }

    public WizardScreen getAttachedScreen() {
        if (this.canHandle()) {
            return this.proxiedStep.getAttachedScreen();
        }
        return new NullWizardScreen();
    }

    public boolean isBegin() {
        return !this.canHandle() || this.proxiedStep.isBegin();
    }

    public void setCurrent() {
        if (this.canHandle()) {
            this.proxiedStep.setCurrent();
        }
    }

    public boolean isCurrent() {
        return this.canHandle() && this.proxiedStep.isCurrent();
    }

    public boolean isEnd() {
        return !this.canHandle() || this.proxiedStep.isEnd();
    }

    public void setFirst() {
        if (this.canHandle()) {
            this.proxiedStep.setFirst();
        }
    }

    public boolean isFirst() {
        return this.canHandle() && this.proxiedStep.isFirst();
    }

    public void setLast() {
        if (this.canHandle()) {
            this.proxiedStep.setLast();
        }
    }

    public boolean isLast() {
        return this.canHandle() && this.proxiedStep.isLast();
    }

    public void setNext() {
        if (this.canHandle()) {
            this.proxiedStep.setNext();
        }
    }

    public void setPrevious() {
        if (this.canHandle()) {
            this.proxiedStep.setPrevious();
        }
    }

    public int getStepIndex() {
        if (this.canHandle()) {
            return this.proxiedStep.getStepIndex();
        }
        return 0;
    }

    public String getTitle() {
        if (this.canHandle()) {
            return this.proxiedStep.getTitle();
        }
        return "";
    }

    public void setWizardContext(WizardContext context) {
        this.context = context;
        this.proxiedStep.setWizardContext(context);
    }

    public void setWizardStep(WizardStep proxiedStep) {
        this.proxiedStep = proxiedStep;
        this.proxiedStep.setWizardContext(this.context);
    }

    public void accept(WizardStepVisitor visitor, WizardContext context, int level) {
        if (this.canHandle()) {
            visitor.visit(this.proxiedStep, context, level);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.proxiedStep.addChangeListener(listener);
    }

    public boolean canBack() {
        return this.canHandle() && this.proxiedStep.canBack();
    }

    public boolean canFinish() {
        return this.canHandle() && this.proxiedStep.canFinish();
    }

    public boolean canHandle() {
        return this.condition.evaluate(this.context) && this.proxiedStep.canHandle();
    }

    public boolean canNext() {
        return this.canHandle() && this.proxiedStep.canNext();
    }

    public boolean onCancel() {
        return this.proxiedStep.onCancel();
    }

    public void onFinish() {
        this.proxiedStep.onFinish();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.proxiedStep.removeChangeListener(listener);
    }

    public void reset() {
        this.proxiedStep = this.nullStep;
    }
}

