/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.framework.steps;

import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.ui.wizards.framework.WizardContext;
import org.netbeans.modules.profiler.ui.wizards.framework.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.ui.wizards.framework.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.ui.wizards.framework.screen.WizardScreen;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.NullWizardStep;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.WizardStep;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.WizardStepVisitor;

public class CompositeWizardStep
implements WizardStep {
    protected int currentIndex;
    private ConditionalFunctor condition;
    private List steps;
    private String title;
    private WizardContext context;
    private WizardStep nullStep = new NullWizardStep();
    private boolean currentFlag;

    public CompositeWizardStep(String title) {
        this(null, title);
    }

    public CompositeWizardStep(WizardContext context, String title) {
        this(context, title, new TrueConditionalFunctor());
    }

    public CompositeWizardStep(WizardContext context, String title, ConditionalFunctor functor) {
        this.title = title;
        this.steps = new Vector(50);
        this.condition = functor;
        this.currentIndex = 0;
        this.context = context;
    }

    public WizardScreen getAttachedScreen() {
        return this.getCurrentStep().getAttachedScreen();
    }

    public boolean isBegin() {
        return this.currentIndex == -1;
    }

    public void setCurrent() {
    }

    public boolean isCurrent() {
        return this.currentFlag;
    }

    public boolean isEnd() {
        return this.currentIndex == this.steps.size();
    }

    public void setFirst() {
        if (this.canHandle()) {
            int iterIndex;
            for (iterIndex = 0; iterIndex < this.steps.size(); ++iterIndex) {
                WizardStep iterStep = this.getStepByIndex(iterIndex);
                iterStep.setFirst();
                if (!iterStep.isEnd()) break;
            }
            if (iterIndex < this.steps.size()) {
                this.currentFlag = true;
                this.currentIndex = iterIndex;
            } else {
                this.currentIndex = this.steps.size();
            }
        } else {
            this.currentIndex = this.steps.size();
        }
    }

    public boolean isFirst() {
        boolean first = this.getCurrentStep().isFirst();
        if (first) {
            for (int index = this.currentIndex - 1; index >= 0; --index) {
                if (!this.getStepByIndex(index).canHandle()) continue;
                first = false;
                break;
            }
        }
        return first;
    }

    public void setLast() {
        if (this.canHandle()) {
            int iterIndex;
            for (iterIndex = this.steps.size() - 1; iterIndex >= 0; --iterIndex) {
                WizardStep iterStep = this.getStepByIndex(iterIndex);
                iterStep.setLast();
                if (!iterStep.isBegin()) break;
            }
            if (iterIndex >= 0) {
                this.currentFlag = true;
                this.currentIndex = iterIndex;
            } else {
                this.currentIndex = -1;
            }
        } else {
            this.currentIndex = -1;
        }
    }

    public boolean isLast() {
        boolean last = this.getCurrentStep().isLast();
        if (last) {
            for (int index = this.currentIndex + 1; index < this.steps.size(); ++index) {
                if (!this.getStepByIndex(index).canHandle()) continue;
                last = false;
                break;
            }
        }
        return last;
    }

    public void setNext() {
        this.getCurrentStep().setNext();
        if (this.getCurrentStep().isEnd()) {
            int iterIndex;
            for (iterIndex = this.currentIndex + 1; iterIndex < this.steps.size(); ++iterIndex) {
                WizardStep iterStep = this.getStepByIndex(iterIndex);
                iterStep.setFirst();
                if (!iterStep.isEnd()) break;
            }
            if (iterIndex < this.steps.size()) {
                this.currentIndex = iterIndex;
            } else {
                this.currentFlag = false;
                this.currentIndex = this.steps.size();
            }
        }
    }

    public void setPrevious() {
        this.getCurrentStep().setPrevious();
        if (this.getCurrentStep().isBegin()) {
            int iterIndex;
            for (iterIndex = this.currentIndex - 1; iterIndex >= 0; --iterIndex) {
                WizardStep iterStep = this.getStepByIndex(iterIndex);
                iterStep.setLast();
                if (!iterStep.isBegin()) break;
            }
            if (iterIndex >= 0) {
                this.currentIndex = iterIndex;
            } else {
                this.currentFlag = false;
                this.currentIndex = -1;
            }
        }
    }

    public int getStepIndex() {
        return this.currentIndex + this.getCurrentStep().getStepIndex();
    }

    public String getTitle() {
        return this.title;
    }

    public void setWizardContext(WizardContext context) {
        this.context = context;
        for (WizardStep step : this.steps) {
            step.setWizardContext(context);
        }
    }

    public void accept(WizardStepVisitor visitor, WizardContext context, int level) {
        if (this.canHandle()) {
            for (WizardStep step : this.steps) {
                step.accept(visitor, context, level + 1);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        for (WizardStep step : this.steps) {
            step.addChangeListener(listener);
        }
    }

    public WizardStep addStep(String title, WizardScreen attachedScreen) {
        return this.addStep(title, attachedScreen, new TrueConditionalFunctor());
    }

    public WizardStep addStep(String title, WizardScreen attachedScreen, ConditionalFunctor condition) {
        SimpleWizardStep step = new SimpleWizardStep(this.context, title, attachedScreen, condition);
        this.steps.add(step);
        return step;
    }

    public void addStep(WizardStep step) {
        this.steps.add(step);
    }

    public boolean canBack() {
        return this.getCurrentStep().canBack();
    }

    public boolean canFinish() {
        return this.getCurrentStep().canFinish();
    }

    public boolean canHandle() {
        if (this.context == null) {
            return false;
        }
        return this.condition.evaluate(this.context);
    }

    public boolean canNext() {
        return this.getCurrentStep().canNext();
    }

    public boolean onCancel() {
        return this.getCurrentStep().onCancel();
    }

    public void onFinish() {
        this.getCurrentStep().onFinish();
    }

    public void removeChangeListener(ChangeListener listener) {
        for (WizardStep step : this.steps) {
            step.removeChangeListener(listener);
        }
    }

    protected WizardStep getCurrentStep() {
        if (this.currentIndex >= 0 && this.currentIndex < this.steps.size()) {
            return (WizardStep)this.steps.get(this.currentIndex);
        }
        return this.nullStep;
    }

    private WizardStep getStepByIndex(int index) {
        index = index < 0 ? 0 : index;
        index = index > this.steps.size() ? this.steps.size() : index;
        return (WizardStep)this.steps.get(index);
    }
}

