/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.framework;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.ui.wizards.TitleCollectingStepVisitor;
import org.netbeans.modules.profiler.ui.wizards.framework.WizardContext;
import org.netbeans.modules.profiler.ui.wizards.framework.steps.WizardStep;
import org.openide.WizardDescriptor;

public abstract class AbstractWizard
implements WizardDescriptor.Iterator,
ChangeListener {
    private Collection listeners = new LinkedList();
    private WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
    private WizardStep wizardModel = null;
    private boolean initialized = false;

    public WizardDescriptor getWizardDescriptor() {
        this.init();
        return this.wizardDescriptor;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public WizardDescriptor.Panel current() {
        return (WizardDescriptor.Panel)this.wizardModel.getAttachedScreen();
    }

    public void finish() {
        this.getRootStep().onFinish();
    }

    public boolean hasNext() {
        return !this.wizardModel.isLast() && this.wizardModel.canNext();
    }

    public boolean hasPrevious() {
        return !this.wizardModel.isFirst() && this.wizardModel.canBack();
    }

    public final synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.prepareWizardModel();
        this.wizardDescriptor.setTitle(this.getTitle());
        this.wizardDescriptor.setTitleFormat(new MessageFormat(this.getTitleFormat()));
        this.wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)this.isAutoWizard());
        this.wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)this.isContentDisplayed());
        this.wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)this.isNumbered());
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        this.wizardDescriptor.putProperty("WIZARD_CONTEXT", (Object)this.getContext());
        this.wizardModel.setFirst();
        this.updateWizardSteps();
        this.initialized = true;
    }

    public String name() {
        return this.getTitle();
    }

    public void nextPanel() {
        this.wizardModel.setNext();
        this.updateWizardSteps();
    }

    public void previousPanel() {
        this.wizardModel.setPrevious();
        this.updateWizardSteps();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateWizardSteps();
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }

    protected final synchronized void invalidate() {
        this.initialized = false;
    }

    protected abstract boolean isAutoWizard();

    protected abstract boolean isContentDisplayed();

    protected abstract WizardContext getContext();

    protected abstract boolean isHelpDisplayed();

    protected abstract boolean isNumbered();

    protected abstract WizardStep getRootStep();

    protected abstract String getTitle();

    protected abstract String getTitleFormat();

    protected abstract void onUpdateWizardSteps();

    private void prepareWizardModel() {
        if (this.wizardModel != null) {
            this.wizardModel.removeChangeListener(this);
        }
        this.wizardModel = this.getRootStep();
        this.wizardModel.addChangeListener(this);
    }

    private void updateWizardSteps() {
        this.onUpdateWizardSteps();
        TitleCollectingStepVisitor visitor = new TitleCollectingStepVisitor();
        this.wizardModel.accept(visitor, this.getContext(), 0);
        this.wizardDescriptor.putProperty("WizardPanel_contentData", (Object)visitor.getTitleArray());
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(visitor.getTitleIndex()));
        this.wizardDescriptor.setTitle(this.wizardModel.getTitle());
    }
}

