/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options;

import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ui.panels.ProfilerOptionsPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProfilerOptionsCategory
extends AdvancedOption {
    private static final String OPTIONS_CATEGORY_NAME = NbBundle.getMessage(ProfilerOptionsCategory.class, (String)"ProfilerOptionsCategory_OptionsCategoryName");
    private static final String TITLE = NbBundle.getMessage(ProfilerOptionsCategory.class, (String)"ProfilerOptionsCategory_Title");

    public String getDisplayName() {
        return TITLE;
    }

    public String getTooltip() {
        return TITLE;
    }

    public OptionsPanelController create() {
        return new ProfilerPanelController();
    }

    private static class ProfilerPanelController
    extends OptionsPanelController {
        private static ProfilerOptionsPanel settingsPanel = null;
        private static JScrollPane optionsComponent = null;

        private ProfilerPanelController() {
        }

        public boolean isChanged() {
            return !settingsPanel.currentSettingsEquals(ProfilerIDESettings.getInstance());
        }

        public JComponent getComponent() {
            return this.getComponent(Lookup.getDefault());
        }

        public JComponent getComponent(Lookup lookup) {
            if (settingsPanel == null) {
                settingsPanel = new ProfilerOptionsPanel();
                optionsComponent = new JScrollPane(settingsPanel, 20, 30);
                optionsComponent.setBorder(BorderFactory.createEmptyBorder());
                optionsComponent.setViewportBorder(BorderFactory.createEmptyBorder());
                if (UIUtils.isMetalLookAndFeel() || UIUtils.isWindowsLookAndFeel()) {
                    optionsComponent.getViewport().setBackground(settingsPanel.getBackground());
                    optionsComponent.setBackground(settingsPanel.getBackground());
                } else {
                    optionsComponent.getViewport().setOpaque(false);
                    optionsComponent.setOpaque(false);
                }
            }
            return optionsComponent;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(NbBundle.getMessage(ProfilerOptionsCategory.class, (String)"ProfilerOptionsCategory_Help"));
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void applyChanges() {
            settingsPanel.applySettings(ProfilerIDESettings.getInstance());
        }

        public void cancel() {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void update() {
            settingsPanel.init(ProfilerIDESettings.getInstance());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JScrollBar hScrollBar;
                    JScrollBar vScrollBar = optionsComponent.getVerticalScrollBar();
                    if (vScrollBar != null) {
                        vScrollBar.setValue(0);
                    }
                    if ((hScrollBar = optionsComponent.getHorizontalScrollBar()) != null) {
                        hScrollBar.setValue(0);
                    }
                }
            });
        }
    }
}

