/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;

public abstract class IteratingRule
extends Rule {
    private MemoryLint context;
    private Pattern classNamePattern;

    public IteratingRule(String name, String desc, String classNamePattern) {
        super(name, desc);
        this.setClassNamePattern(classNamePattern);
    }

    public final void perform() {
        Heap heap = this.context.getHeap();
        List classes = heap.getAllClasses();
        ArrayList<JavaClass> matching = new ArrayList<JavaClass>();
        int count = 0;
        for (JavaClass cls : classes) {
            if (this.classNamePattern.matcher(cls.getName()).matches()) {
                matching.add(cls);
                count += cls.getInstancesCount();
            }
            if (!this.context.isInterruped()) continue;
            return;
        }
        BoundedRangeModel progress = this.context.getProgress();
        progress.setMaximum(count != 0 ? count : 1);
        for (JavaClass actCls : matching) {
            List instances = actCls.getInstances();
            for (Instance inst : instances) {
                Logger.getLogger(IteratingRule.class.getName()).log(Level.FINE, "Executing rule on {0} instance", inst);
                this.perform(inst);
                progress.setValue(progress.getValue() + 1);
                if (!this.context.isInterruped()) continue;
                return;
            }
        }
        if (count == 0) {
            progress.setValue(1);
        }
        this.summary();
    }

    public final void prepare(MemoryLint context) {
        this.context = context;
        this.prepareRule(context);
    }

    protected final void setClassNamePattern(String classNamePattern) {
        this.classNamePattern = Pattern.compile(classNamePattern);
    }

    protected abstract void perform(Instance var1);

    protected final MemoryLint getContext() {
        return this.context;
    }

    protected JComponent createCustomizer() {
        return null;
    }

    protected void prepareRule(MemoryLint context) {
    }

    protected void summary() {
    }
}

