/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Histogram<T extends Entry> {
    private HashMap<String, T> map = new HashMap();

    public static final <E extends Entry> Comparator<E> sortByCount() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Entry)o2).count - ((Entry)o1).count;
            }
        };
    }

    public static final <E extends Entry> Comparator<E> sortBySize() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Entry)o2).size - ((Entry)o1).size;
            }
        };
    }

    public SortedMap<String, T> getResults(final Comparator<T> comparator) {
        TreeMap<String, T> sm = new TreeMap<String, T>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Entry t2;
                Entry t1 = (Entry)Histogram.this.map.get(o1);
                int delta = comparator.compare(t1, t2 = (Entry)Histogram.this.map.get(o2));
                if (delta == 0) {
                    delta = o1.compareTo(o2);
                }
                return delta;
            }
        });
        sm.putAll(this.map);
        return sm;
    }

    public void add(String key, T entry) {
        Entry current = (Entry)this.map.get(key);
        if (current != null) {
            current.doAdd((Entry)entry);
        } else {
            this.map.put(key, entry);
        }
    }

    public String toString(int treshold) {
        StringBuffer result = new StringBuffer();
        int totalSize = 0;
        int totalCount = 0;
        SortedMap bySize = this.getResults(Histogram.sortBySize());
        for (Map.Entry entry : bySize.entrySet()) {
            int size = ((Entry)entry.getValue()).getSize();
            if (size > treshold) {
                result.append(entry.getKey()).append(": ").append(entry.getValue()).append("<br>");
            }
            totalSize += size;
            totalCount += ((Entry)entry.getValue()).getCount();
        }
        result.append(NbBundle.getMessage(Histogram.class, (String)"FMT_HistogramSum", (Object)totalCount, (Object)totalSize));
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<T extends Entry> {
        private int count = 1;
        private int size;

        public Entry(int size) {
            this.size = size;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getSize() {
            return this.size;
        }

        public String toString() {
            return "#:" + this.getCount() + "/" + this.getSize() + "B\n";
        }

        protected void add(T source) {
        }

        private void doAdd(T entry) {
            this.count += ((Entry)entry).count;
            this.size += ((Entry)entry).size;
            this.add(entry);
        }
    }
}

