/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.heapwalk.AbstractController;

public abstract class AbstractTopLevelController
extends AbstractController {
    private AbstractButton[] clientPresenters;

    public AbstractButton[] getClientPresenters() {
        if (this.clientPresenters == null) {
            this.clientPresenters = this.createClientPresenters();
            for (int i = 0; i < this.clientPresenters.length; ++i) {
                Insets presenterMargin = this.clientPresenters[i].getMargin();
                this.clientPresenters[i].setMargin(new Insets(presenterMargin.top, presenterMargin.top + 10, presenterMargin.bottom, presenterMargin.top + 10));
                this.registerClientPresenterListener(this.clientPresenters[i]);
            }
            this.updateClientPresentersEnabling(this.clientPresenters);
        }
        return this.clientPresenters;
    }

    protected abstract AbstractButton[] createClientPresenters();

    protected void updateClientPresentersEnabling(AbstractButton[] clientPresenters) {
        int disabledPresenterIndex = -1;
        int selectedPresenterIndex = -1;
        int unselectedPresentersCount = 0;
        for (int i = 0; i < clientPresenters.length; ++i) {
            if (clientPresenters[i].isSelected()) {
                selectedPresenterIndex = i;
            } else {
                ++unselectedPresentersCount;
            }
            if (clientPresenters[i].isEnabled()) continue;
            disabledPresenterIndex = i;
        }
        if (unselectedPresentersCount == clientPresenters.length - 1) {
            if (disabledPresenterIndex == -1) {
                clientPresenters[selectedPresenterIndex].setEnabled(false);
            }
        } else if (disabledPresenterIndex != -1) {
            clientPresenters[disabledPresenterIndex].setEnabled(true);
        }
    }

    private void registerClientPresenterListener(AbstractButton presenter) {
        presenter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractTopLevelController.this.updateClientPresentersEnabling(AbstractTopLevelController.this.getClientPresenters());
            }
        });
    }
}

