/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class LoadSnapshotAction
extends AbstractAction {
    private static final String ACTION_NAME = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ActionName");
    private static final String ACTION_DESCR = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ActionDescr");
    private static final String OPEN_SNAPSHOT_DIALOG_CAPTION = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_OpenSnapshotDialogCaption");
    private static final String PROFILER_SNAPSHOT_FILE_FILTER = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ProfilerSnapshotFileFilter");
    private static final String OPEN_SNAPSHOT_HEAPDUMP_DIALOG_CAPTION = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_OpenSnapshotHeapdumpDialogCaption");
    private static final String PROFILER_SNAPSHOT_HEAPDUMP_FILE_FILTER = NbBundle.getMessage(LoadSnapshotAction.class, (String)"LoadSnapshotAction_ProfilerSnapshotHeapdumpFileFilter");
    private static File importDir;

    public LoadSnapshotAction() {
        this.putValue("Name", ACTION_NAME);
        this.putValue("ShortDescription", ACTION_DESCR);
        this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/openSnapshot.png")));
    }

    public boolean isEnabled() {
        return NetBeansProfiler.isInitialized();
    }

    public void actionPerformed(ActionEvent e) {
        this.loadSnapshot(false);
    }

    public void loadSnapshotOrHeapdump() {
        this.loadSnapshot(true);
    }

    private void loadSnapshot(final boolean handleHeapdumps) {
        JFileChooser chooser = new JFileChooser();
        if (importDir != null) {
            chooser.setCurrentDirectory(importDir);
        }
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogType(0);
        chooser.setDialogTitle(handleHeapdumps ? OPEN_SNAPSHOT_HEAPDUMP_DIALOG_CAPTION : OPEN_SNAPSHOT_DIALOG_CAPTION);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return handleHeapdumps ? f.isDirectory() || f.getName().endsWith(".nps") || f.getName().endsWith(".hprof") : f.isDirectory() || f.getName().endsWith(".nps");
            }

            public String getDescription() {
                return handleHeapdumps ? MessageFormat.format(PROFILER_SNAPSHOT_HEAPDUMP_FILE_FILTER, "nps", "hprof") : MessageFormat.format(PROFILER_SNAPSHOT_FILE_FILTER, "nps");
            }
        });
        if (chooser.showOpenDialog(IDEUtils.getMainWindow()) == 0) {
            File[] files = chooser.getSelectedFiles();
            ArrayList<FileObject> snapshotsFOArr = new ArrayList<FileObject>();
            final ArrayList<File> heapdumpsFArr = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.getName().endsWith(".nps")) {
                    snapshotsFOArr.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
                    continue;
                }
                if (!file.getName().endsWith(".hprof")) continue;
                heapdumpsFArr.add(file);
            }
            if (snapshotsFOArr.size() > 0) {
                LoadedSnapshot[] imported = ResultsManager.getDefault().loadSnapshots(snapshotsFOArr.toArray(new FileObject[snapshotsFOArr.size()]));
                ResultsManager.getDefault().openSnapshots(imported);
            }
            if (heapdumpsFArr.size() > 0) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        HeapWalkerManager.getDefault().openHeapWalkers(heapdumpsFArr.toArray(new File[heapdumpsFArr.size()]));
                    }
                });
            }
            importDir = chooser.getCurrentDirectory();
        }
    }
}

