/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.openide.util.NbBundle;

public class SnapshotInfoPanel
extends JPanel {
    private static final String DATA_COLLECTED_FROM_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_DataCollectedFromString");
    private static final String SNAPSHOT_TAKEN_AT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SnapshotTakenAtString");
    private static final String FILE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_FileString");
    private static final String NOT_SAVED_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NotSavedString");
    private static final String FILE_SIZE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_FileSizeString");
    private static final String SETTINGS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SettingsString");
    private static final String SETTINGS_NAME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SettingsNameString");
    private static final String PROFILING_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProfilingTypeString");
    private static final String CODE_REGION_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CodeRegionString");
    private static final String PROFILED_CODE_REGION_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProfiledCodeRegionString");
    private static final String EXCLUDE_SLEEP_WAIT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ExcludeSleepWaitString");
    private static final String BUFFER_SIZE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_BufferSizeString");
    private static final String LIMIT_PROFILED_THREADS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LimitProfiledThreadsString");
    private static final String UNLIMITED_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_UnlimitedString");
    private static final String CPU_ENTIRE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuEntireString");
    private static final String CPU_PART_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuPartString");
    private static final String MEMORY_ALLOC_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MemoryAllocString");
    private static final String MEMORY_LIVENESS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MemoryLivenessString");
    private static final String TRACKING_ALL_INSTANCES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TrackingAllInstancesString");
    private static final String TRACK_EVERY_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TrackEveryString");
    private static final String RECORD_STACK_TRACES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RecordStackTracesString");
    private static final String LIMIT_STACK_DEPTH_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LimitStackDepthString");
    private static final String RUN_GC_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RunGcString");
    private static final String ROOT_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_RootMethodsString");
    private static final String CPU_PROFILING_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuProfilingTypeString");
    private static final String SAMPLING_PERIOD_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SamplingPeriodString");
    private static final String CPU_TIMER_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CpuTimerString");
    private static final String INSTRUMENTATION_FILTER_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationFilterString");
    private static final String INSTRUMENTATION_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationSchemeString");
    private static final String INSTRUMENT_METHOD_INVOKE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentMethodInvokeString");
    private static final String INSTRUMENT_NEW_THREADS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentNewThreadsString");
    private static final String INSTRUMENT_GETTERS_SETTERS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentGettersSettersString");
    private static final String INSTRUMENT_EMPTY_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentEmptyMethodsString");
    private static final String OVERRIDEN_GLOBAL_PROPERTIES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OverridenGlobalPropertiesString");
    private static final String WORKING_DIRECTORY_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_WorkingDirectoryString");
    private static final String PROJECT_PLATFORM_NAME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_ProjectPlatformNameString");
    private static final String JAVA_PLATFORM_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_JavaPlatformString");
    private static final String JVM_ARGUMENTS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_JvmArgumentsString");
    private static final String COMM_PORT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_CommPortString");
    private static final String YES_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_YesString");
    private static final String NO_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NoString");
    private static final String ON_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OnString");
    private static final String OFF_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_OffString");
    private static final String INVALID_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InvalidString");
    private static final String NO_METHODS_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_NoMethodsString");
    private static final String METHODS_COUNT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_MethodsCountString");
    private static final String LINES_DEF_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LinesDefString");
    private static final String INSTRUMENTATION_PROF_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstrumentationProfTypeString");
    private static final String SAMPLED_PROF_TYPE_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_SampledProfTypeString");
    private static final String TOTAL_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_TotalProfSchemeString");
    private static final String EAGER_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_EagerProfSchemeString");
    private static final String LAZY_PROF_SCHEME_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_LazyProfSchemeString");
    private static final String INSTANCES_COUNT_STRING = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InstancesCountString");
    private static final String INFO_AREA_ACCESS_NAME = NbBundle.getMessage(SnapshotInfoPanel.class, (String)"SnapshotInfoPanel_InfoAreaAccessName");
    private HTMLTextArea infoArea;
    private JScrollPane infoAreaScrollPane;
    private LoadedSnapshot loadedSnapshot;

    public SnapshotInfoPanel(LoadedSnapshot snapshot) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.infoArea = new HTMLTextArea();
        this.infoArea.getAccessibleContext().setAccessibleName(INFO_AREA_ACCESS_NAME);
        this.infoAreaScrollPane = new JScrollPane((Component)this.infoArea);
        this.add((Component)this.infoAreaScrollPane, "Center");
        this.loadedSnapshot = snapshot;
        this.updateInfo();
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot((Component)this.infoAreaScrollPane);
        }
        return UIUtils.createScreenshot((Component)this.infoArea);
    }

    public boolean fitsVisibleArea() {
        return !this.infoAreaScrollPane.getVerticalScrollBar().isVisible();
    }

    public void updateInfo() {
        ProfilingSettings ps = this.loadedSnapshot.getSettings();
        StringBuffer htmlText = new StringBuffer(1000);
        htmlText.append("<strong>");
        htmlText.append(DATA_COLLECTED_FROM_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getBeginTime())));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(SNAPSHOT_TAKEN_AT_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getTimeTaken())));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(FILE_STRING + " ");
        htmlText.append("</strong>");
        File f = this.loadedSnapshot.getFile();
        if (f == null) {
            htmlText.append(NOT_SAVED_STRING);
        } else {
            htmlText.append(f.getAbsolutePath());
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(FILE_SIZE_STRING + " ");
            htmlText.append("</strong>");
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(true);
            htmlText.append(format.format(f.length()) + " B");
        }
        htmlText.append("<br>");
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(SETTINGS_STRING);
        htmlText.append("</strong>");
        htmlText.append("<br>");
        htmlText.append("<br>");
        htmlText.append("<blockquote>");
        htmlText.append("<strong>");
        htmlText.append(" " + SETTINGS_NAME_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(ps.getSettingsName());
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(" " + PROFILING_TYPE_STRING + " ");
        htmlText.append("</strong>");
        switch (ps.getProfilingType()) {
            case 32: {
                htmlText.append(CODE_REGION_STRING);
                htmlText.append("<br>");
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(PROFILED_CODE_REGION_STRING + " ");
                htmlText.append("</strong>");
                htmlText.append(this.formatRootMethod(ps.getCodeFragmentSelection()));
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(EXCLUDE_SLEEP_WAIT_STRING + " ");
                htmlText.append("</strong>");
                htmlText.append(SnapshotInfoPanel.getYesNo(ps.getExcludeWaitTime()));
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(BUFFER_SIZE_STRING + " ");
                htmlText.append("</strong>");
                htmlText.append(ps.getCodeRegionCPUResBufSize());
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(LIMIT_PROFILED_THREADS_STRING + " ");
                htmlText.append("</strong>");
                if (ps.getNProfiledThreadsLimit() < 0) {
                    htmlText.append(UNLIMITED_STRING);
                } else {
                    htmlText.append("" + ps.getNProfiledThreadsLimit());
                }
                htmlText.append("<br>");
                break;
            }
            case 8: {
                htmlText.append(CPU_ENTIRE_STRING);
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendCPUText(htmlText, ps);
                break;
            }
            case 16: {
                htmlText.append(CPU_PART_STRING);
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendCPUText(htmlText, ps);
                break;
            }
            case 2: {
                htmlText.append(MEMORY_ALLOC_STRING);
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendMemoryText(htmlText, ps);
                break;
            }
            case 4: {
                htmlText.append(MEMORY_LIVENESS_STRING);
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendMemoryText(htmlText, ps);
            }
        }
        this.appendOverridenGlobalProperties(htmlText, ps);
        htmlText.append("</blockquote>");
        htmlText.append("<br>");
        this.infoArea.setText(htmlText.toString());
    }

    private static String getOnOff(boolean b) {
        return b ? ON_STRING : OFF_STRING;
    }

    private static String getYesNo(boolean b) {
        return b ? YES_STRING : NO_STRING;
    }

    private String getCPUProfilingScheme(int type) {
        switch (type) {
            case 3: {
                return TOTAL_PROF_SCHEME_STRING;
            }
            case 2: {
                return EAGER_PROF_SCHEME_STRING;
            }
            case 1: {
                return LAZY_PROF_SCHEME_STRING;
            }
        }
        return INVALID_STRING;
    }

    private String getCPUProfilingType(int type) {
        switch (type) {
            case 0: {
                return INSTRUMENTATION_PROF_TYPE_STRING;
            }
            case 1: {
                return SAMPLED_PROF_TYPE_STRING;
            }
        }
        return INVALID_STRING;
    }

    private void appendCPUText(StringBuffer htmlText, ProfilingSettings ps) {
        htmlText.append("<strong>");
        htmlText.append(ROOT_METHODS_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(this.formatRootMethods(ps.getInstrumentationRootMethods()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(CPU_PROFILING_TYPE_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(this.getCPUProfilingType(ps.getCPUProfilingType()));
        htmlText.append("<br>");
        if (ps.getCPUProfilingType() == 1) {
            htmlText.append("<strong>");
            htmlText.append(SAMPLING_PERIOD_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append(ps.getSamplingInterval());
            htmlText.append(" ms<br>");
        }
        htmlText.append("<strong>");
        htmlText.append(CPU_TIMER_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getOnOff(ps.getThreadCPUTimerOn()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(EXCLUDE_SLEEP_WAIT_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getExcludeWaitTime()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(LIMIT_PROFILED_THREADS_STRING + " ");
        htmlText.append("</strong>");
        if (ps.getNProfiledThreadsLimit() < 0) {
            htmlText.append(UNLIMITED_STRING);
        } else {
            htmlText.append("" + ps.getNProfiledThreadsLimit());
        }
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENTATION_FILTER_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(ps.getSelectedInstrumentationFilter().toString());
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENTATION_SCHEME_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(this.getCPUProfilingScheme(ps.getInstrScheme()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENT_METHOD_INVOKE_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentMethodInvoke()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENT_NEW_THREADS_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentSpawnedThreads()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENT_GETTERS_SETTERS_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentGetterSetterMethods()));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(INSTRUMENT_EMPTY_METHODS_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentEmptyMethods()));
        htmlText.append("<br>");
    }

    private void appendMemoryText(StringBuffer htmlText, ProfilingSettings ps) {
        if (ps.getAllocTrackEvery() == 1) {
            htmlText.append("<strong>");
            htmlText.append(TRACKING_ALL_INSTANCES_STRING + " ");
            htmlText.append("</strong>");
        } else {
            htmlText.append("<strong>");
            htmlText.append(TRACK_EVERY_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append(MessageFormat.format(INSTANCES_COUNT_STRING, "" + ps.getAllocTrackEvery()));
        }
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(RECORD_STACK_TRACES_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getAllocStackTraceLimit() != 0));
        htmlText.append("<br>");
        if (ps.getAllocStackTraceLimit() != 0) {
            htmlText.append("<strong>");
            htmlText.append(LIMIT_STACK_DEPTH_STRING + " ");
            htmlText.append("</strong>");
            if (ps.getAllocStackTraceLimit() < 0) {
                htmlText.append(UNLIMITED_STRING);
            } else {
                htmlText.append(ps.getAllocStackTraceLimit());
            }
            htmlText.append("<br>");
        }
        htmlText.append("<strong>");
        htmlText.append(RUN_GC_STRING + " ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getRunGCOnGetResultsInMemoryProfiling()));
        htmlText.append("<br>");
    }

    private void appendOverridenGlobalProperties(StringBuffer htmlText, ProfilingSettings ps) {
        if (ps.getOverrideGlobalSettings()) {
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(OVERRIDEN_GLOBAL_PROPERTIES_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append("<br>");
            htmlText.append("<blockquote>");
            htmlText.append("<strong>");
            htmlText.append(WORKING_DIRECTORY_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append(ps.getWorkingDir());
            htmlText.append("<br>");
            String platformName = ps.getJavaPlatformName();
            if (platformName == null) {
                platformName = PROJECT_PLATFORM_NAME_STRING;
            }
            htmlText.append("<strong>");
            htmlText.append(JAVA_PLATFORM_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append(platformName);
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(JVM_ARGUMENTS_STRING + " ");
            htmlText.append("</strong>");
            htmlText.append(ps.getJVMArgs());
            htmlText.append("<br>");
            htmlText.append("</blockquote>");
        }
    }

    private String formatRootMethod(ClientUtils.SourceCodeSelection method) {
        String ret;
        if (method.definedViaMethodName()) {
            ret = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(method).toFormatted();
            ret = ret.replaceAll("<", "&lt;");
            ret = ret.replaceAll(">", "&gt;");
        } else {
            ret = MessageFormat.format(LINES_DEF_STRING, method.getClassName(), "" + method.getStartLine(), "" + method.getEndLine());
        }
        return ret;
    }

    private String formatRootMethods(ClientUtils.SourceCodeSelection[] methods) {
        if (methods == null || methods.length == 0) {
            return NO_METHODS_STRING;
        }
        if (methods.length == 1) {
            return this.formatRootMethod(methods[0]);
        }
        StringBuffer ret = new StringBuffer();
        ret.append(MessageFormat.format(METHODS_COUNT_STRING, "" + methods.length));
        ret.append("<br>");
        ret.append("<blockquote>");
        ArrayList<String> rootNames = new ArrayList<String>();
        for (int i = 0; i < methods.length; ++i) {
            String frm = this.formatRootMethod(methods[i]);
            rootNames.add(frm);
        }
        Collections.sort(rootNames);
        for (String rootName : rootNames) {
            ret.append(rootName);
            ret.append("<br>");
        }
        ret.append("</blockquote>");
        return ret.toString();
    }
}

