/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Cursor;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsDiffWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ResultsManager {
    private static final String PROFILED_APP_TERMINATED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfiledAppTerminatedMsg");
    private static final String DATA_NOT_AVAILABLE_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_DataNotAvailableMsg");
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OutOfMemoryMsg");
    private static final String SNAPSHOT_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotDeleteFailedMsg");
    private static final String SNAPSHOT_SAVE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotSaveFailedMsg");
    private static final String CANT_FIND_SNAPSHOT_LOCATION_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_CantFindSnapshotLocationMsg");
    private static final String SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateInProjectFailedMsg");
    private static final String SNAPSHOT_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailedMsg");
    private static final String SNAPSHOTS_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotsLoadFailedMsg");
    private static final String OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ObtainSavedSnapshotsFailedMsg");
    private static final String SELECT_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectDirDialogCaption");
    private static final String SAVE_BUTTON_NAME = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveButtonName");
    private static final String OVERWRITE_FILE_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogCaption");
    private static final String OVERWRITE_FILE_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogMsg");
    private static final String FILE_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_FileDeleteFailedMsg");
    private static final String SNAPSHOT_EXPORT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotExportFailedMsg");
    private static final String SAVE_SNAPSHOTS_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogCaption");
    private static final String SAVE_SNAPSHOTS_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogMsg");
    private static final String SELECT_FILE_OR_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectFileOrDirDialogCaption");
    private static final String PROFILER_SNAPSHOT_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerSnapshotFileFilter");
    private static final String PROFILER_HEAPDUMP_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerHeapdumpFileFilter");
    private static final String SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
    private static final String OUT_OF_MEMORY_SAVING = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_OutOfMemorySavingMsg");
    private static final String CANNOT_COMPARE_SNAPSHOTS_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_CannotCompareSnapshotsMsg");
    private static final String DIRECTORY_DOESNT_EXIST_CAPTION = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistCaption");
    private static final String DIRECTORY_DOESNT_EXIST_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistMsg");
    public static final String SNAPSHOT_EXTENSION = "nps";
    public static final String HEAPDUMP_EXTENSION = "hprof";
    private ArrayList<LoadedSnapshot> loadedSnapshots = new ArrayList();
    private File exportDir;
    private HashMap<FileObject, ProfilingSettings> settingsCache = new HashMap();
    private HashMap<FileObject, Integer> typeCache = new HashMap();
    private Vector resultsListeners;
    private Vector snapshotListeners;
    private Window mainWindow;
    private boolean resultsAvailable = false;

    public static ResultsManager getDefault() {
        return (ResultsManager)Lookup.getDefault().lookup(ResultsManager.class);
    }

    public String getDefaultSnapshotFileName(LoadedSnapshot ls) {
        return "snapshot-" + ls.getSnapshot().getTimeTaken();
    }

    public LoadedSnapshot[] getLoadedSnapshots() {
        return this.loadedSnapshots.toArray(new LoadedSnapshot[0]);
    }

    public LoadedSnapshot getSnapshotFromFileObject(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls;
        }
        try {
            return this.loadSnapshotFromFileObject(fo);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
    }

    public ProfilingSettings getSnapshotSettings(FileObject fo) {
        ProfilingSettings settings = this.settingsCache.get(fo);
        if (settings == null && !this.settingsCache.containsKey(fo)) {
            settings = this.readSettingsFromFile(fo);
            this.settingsCache.put(fo, settings);
        }
        return settings;
    }

    public int getSnapshotType(FileObject fo) {
        Integer type = this.typeCache.get(fo);
        if (type == null) {
            type = new Integer(this.readTypeFromFile(fo));
            this.typeCache.put(fo, type);
        }
        return type;
    }

    public void addResultsListener(ResultsListener listener) {
        if (this.resultsListeners == null) {
            this.resultsListeners = new Vector();
        }
        if (!this.resultsListeners.contains(listener)) {
            this.resultsListeners.add(listener);
        }
    }

    public void addSnapshotsListener(SnapshotsListener profilingStateListener) {
        if (this.snapshotListeners == null) {
            this.snapshotListeners = new Vector();
        }
        if (!this.snapshotListeners.contains(profilingStateListener)) {
            this.snapshotListeners.add(profilingStateListener);
        }
    }

    public void cctEstablished(RuntimeCCTNode runtimeCCTNode) {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    public void cctReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    public void closeSnapshot(LoadedSnapshot ls) {
        if (ls != null) {
            this.loadedSnapshots.remove(ls);
            this.fireSnapshotRemoved(ls);
        }
    }

    public void compareSnapshots(FileObject snapshot1FO, FileObject snapshot2FO) {
        LoadedSnapshot s1 = null;
        LoadedSnapshot s2 = null;
        try {
            s1 = this.findAlreadyLoadedSnapshot(snapshot1FO);
            if (s1 == null) {
                s1 = this.loadSnapshotFromFileObject(snapshot1FO);
            }
            if ((s2 = this.findAlreadyLoadedSnapshot(snapshot2FO)) == null) {
                s2 = this.loadSnapshotFromFileObject(snapshot2FO);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return;
        }
        if (s1 != null && s2 != null) {
            this.compareSnapshots(s1, s2);
        } else {
            NetBeansProfiler.getDefaultNB().displayError(SNAPSHOTS_LOAD_FAILED_MSG);
        }
    }

    public void compareSnapshots(LoadedSnapshot s1, LoadedSnapshot s2) {
        AllocMemoryResultsDiff diff = null;
        if (s1.getSnapshot() instanceof AllocMemoryResultsSnapshot && s2.getSnapshot() instanceof AllocMemoryResultsSnapshot) {
            diff = new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)s1.getSnapshot(), (AllocMemoryResultsSnapshot)s2.getSnapshot());
        } else if (s1.getSnapshot() instanceof LivenessMemoryResultsSnapshot && s2.getSnapshot() instanceof LivenessMemoryResultsSnapshot) {
            diff = new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)s1.getSnapshot(), (LivenessMemoryResultsSnapshot)s2.getSnapshot());
        }
        if (diff != null) {
            SnapshotsDiffWindow sdw = SnapshotsDiffWindow.get(diff, s1, s2);
            sdw.open();
            sdw.requestActive();
        } else {
            NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_COMPARE_SNAPSHOTS_MSG, s1.getFile().getName(), s2.getFile().getName()));
        }
    }

    public void deleteSnapshot(FileObject snapshotFile) {
        LoadedSnapshot ls = this.findLoadedSnapshot(FileUtil.toFile((FileObject)snapshotFile));
        try {
            snapshotFile.delete();
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_DELETE_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return;
        }
        if (ls != null) {
            this.loadedSnapshots.remove(ls);
            this.fireSnapshotRemoved(ls);
        }
    }

    public void exportSnapshots(FileObject[] selectedSnapshots) {
        assert (selectedSnapshots != null);
        assert (selectedSnapshots.length > 0);
        if (selectedSnapshots.length == 1) {
            SelectedFile sf = this.selectSnapshotTargetFile(selectedSnapshots[0].getName(), selectedSnapshots[0].getExt().equals(HEAPDUMP_EXTENSION));
            if (sf != null && this.checkFileExists(sf)) {
                this.exportSnapshot(selectedSnapshots[0], sf.folder, sf.fileName, sf.fileExt);
            }
        } else {
            JFileChooser chooser = new JFileChooser();
            if (this.exportDir != null) {
                chooser.setCurrentDirectory(this.exportDir);
            }
            chooser.setDialogTitle(SELECT_DIR_DIALOG_CAPTION);
            chooser.setApproveButtonText(SAVE_BUTTON_NAME);
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(IDEUtils.getMainWindow()) == 0) {
                File file = chooser.getSelectedFile();
                if (!file.exists()) {
                    if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)DIRECTORY_DOESNT_EXIST_MSG, DIRECTORY_DOESNT_EXIST_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    file.mkdir();
                }
                this.exportDir = file;
                FileObject dir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                for (int i = 0; i < selectedSnapshots.length; ++i) {
                    this.exportSnapshot(selectedSnapshots[i], dir, selectedSnapshots[i].getName(), selectedSnapshots[i].getExt());
                }
            }
        }
    }

    public LoadedSnapshot findLoadedSnapshot(ResultsSnapshot snapshot) {
        for (LoadedSnapshot ls : this.loadedSnapshots) {
            if (ls.getSnapshot() != snapshot) continue;
            return ls;
        }
        return null;
    }

    public LoadedSnapshot findLoadedSnapshot(File snapshotFile) {
        for (LoadedSnapshot ls : this.loadedSnapshots) {
            if (ls.getFile() == null || !ls.getFile().equals(snapshotFile)) continue;
            return ls;
        }
        return null;
    }

    public boolean ideClosing() {
        Iterator<LoadedSnapshot> it = this.loadedSnapshots.iterator();
        ArrayList<LoadedSnapshot> unsaved = new ArrayList<LoadedSnapshot>();
        while (it.hasNext()) {
            LoadedSnapshot ls = it.next();
            if (ls.isSaved()) continue;
            unsaved.add(ls);
        }
        if (unsaved.size() > 0) {
            Object ret = ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(SAVE_SNAPSHOTS_DIALOG_MSG, "" + unsaved.size()), SAVE_SNAPSHOTS_DIALOG_CAPTION, 1));
            if (ret == NotifyDescriptor.YES_OPTION) {
                for (LoadedSnapshot ls : unsaved) {
                    this.saveSnapshot(ls);
                }
                return true;
            }
            return ret == NotifyDescriptor.NO_OPTION;
        }
        return true;
    }

    public FileObject[] listSavedHeapdumps() {
        try {
            FileObject profilerFolder = IDEUtils.getProjectSettingsFolder(false);
            if (profilerFolder == null) {
                return new FileObject[0];
            }
            profilerFolder.refresh();
            FileObject[] children = profilerFolder.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!child.getExt().equalsIgnoreCase(HEAPDUMP_EXTENSION)) continue;
                files.add(child);
            }
            Collections.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FileObject f1 = (FileObject)o1;
                    FileObject f2 = (FileObject)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileObject[] ret = new FileObject[files.size()];
            files.toArray(ret);
            return ret;
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return new FileObject[0];
        }
    }

    public FileObject[] listSavedSnapshots() {
        try {
            FileObject profilerFolder = IDEUtils.getProjectSettingsFolder(false);
            if (profilerFolder == null) {
                return new FileObject[0];
            }
            profilerFolder.refresh();
            FileObject[] children = profilerFolder.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (!child.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) continue;
                files.add(child);
            }
            Collections.sort(files, new Comparator(){

                public int compare(Object o1, Object o2) {
                    FileObject f1 = (FileObject)o1;
                    FileObject f2 = (FileObject)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileObject[] ret = new FileObject[files.size()];
            files.toArray(ret);
            return ret;
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return new FileObject[0];
        }
    }

    public LoadedSnapshot loadSnapshot(FileObject selectedFile) {
        try {
            return this.loadSnapshotImpl(selectedFile);
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
    }

    public LoadedSnapshot[] loadSnapshots(FileObject[] selectedFiles) {
        LoadedSnapshot[] ret = new LoadedSnapshot[selectedFiles.length];
        for (int i = 0; i < selectedFiles.length; ++i) {
            try {
                if (selectedFiles[i] == null) continue;
                ret[i] = this.loadSnapshotImpl(selectedFiles[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return ret;
    }

    public void openSnapshot(LoadedSnapshot ls) {
        this.openSnapshot(ls, -1, false);
    }

    public void openSnapshot(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
        srw.open();
        srw.requestActive();
    }

    public void openSnapshots(LoadedSnapshot[] loaded) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            SnapshotResultsWindow srw = null;
            for (int i = 0; i < loaded.length; ++i) {
                loadedSnapshot = loaded[i];
                if (loaded[i] == null) continue;
                srw = SnapshotResultsWindow.get(loadedSnapshot);
                srw.open();
            }
            if (srw != null) {
                srw.requestActive();
            }
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            NotifyDescriptor.Message loadFailed = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailed", (Object[])new Object[]{loadedSnapshot.getFile().getAbsolutePath()}));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)loadFailed);
        }
    }

    public LoadedSnapshot prepareSnapshot() {
        return this.prepareSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot prepareSnapshot(boolean reqeustData) {
        CodeRegionResultsSnapshot snapshot = null;
        if (!this.resultsAvailable()) {
            return null;
        }
        try {
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient client = runner.getProfilerClient();
            int currentInstrType = client.getCurrentInstrType();
            try {
                switch (currentInstrType) {
                    case 4: 
                    case 5: {
                        snapshot = client.getMemoryProfilingResultsSnapshot(reqeustData);
                        break;
                    }
                    case 2: 
                    case 3: {
                        snapshot = client.getCPUProfilingResultsSnapshot(reqeustData);
                        break;
                    }
                    case 1: {
                        snapshot = client.getCodeRegionProfilingResultsSnapshot();
                    }
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated e1) {
                ErrorManager.getDefault().annotate((Throwable)e1, PROFILED_APP_TERMINATED_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)e1);
            }
            catch (CPUResultsSnapshot.NoDataAvailableException e2) {
                ErrorManager.getDefault().annotate((Throwable)e2, DATA_NOT_AVAILABLE_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)e2);
            }
            catch (OutOfMemoryError e) {
                try {
                    runner.resetTimers();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
                ErrorManager.getDefault().annotate((Throwable)e, OUT_OF_MEMORY_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        finally {
            if (snapshot != null) {
                ProfilingSettings settings = new ProfilingSettings();
                Profiler.getDefault().getLastProfilingSettings().copySettingsInto(settings);
                settings.setSettingsName(Profiler.getDefault().getLastProfilingSettings().getSettingsName());
                return new LoadedSnapshot((ResultsSnapshot)snapshot, settings, null);
            }
        }
        return null;
    }

    public void removeResultsListener(ResultsListener listener) {
        if (this.resultsListeners != null) {
            this.resultsListeners.remove(listener);
        }
    }

    public void removeSnapshotsListener(SnapshotsListener profilingStateListener) {
        if (this.snapshotListeners != null) {
            this.snapshotListeners.remove(profilingStateListener);
        }
    }

    public void reset() {
        ProfilingResultsDispatcher.getDefault().reset();
        this.resultsReset();
    }

    public boolean resultsAvailable() {
        return this.resultsAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSnapshot(LoadedSnapshot snapshot, FileObject profFile) {
        FileLock lock = null;
        FilterOutputStream dos = null;
        try {
            lock = profFile.lock();
            OutputStream os = profFile.getOutputStream(lock);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            dos = new DataOutputStream(bos);
            snapshot.save((DataOutputStream)dos);
            dos.close();
            snapshot.setFile(FileUtil.toFile((FileObject)profFile));
            snapshot.setSaved(true);
            this.fireSnapshotSaved(snapshot);
        }
        catch (IOException e) {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    profFile.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(SNAPSHOT_SAVE_FAILED_MSG, e.getMessage()));
            boolean e2 = false;
            return e2;
        }
        catch (OutOfMemoryError e) {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (lock != null) {
                    profFile.delete(lock);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_SAVING);
            boolean bl = false;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return true;
    }

    public boolean saveSnapshot(LoadedSnapshot ls) {
        FileObject profFile = null;
        FileObject saveDir = null;
        try {
            saveDir = IDEUtils.getProjectSettingsFolder(true);
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(CANT_FIND_SNAPSHOT_LOCATION_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return false;
        }
        try {
            profFile = saveDir.createData(this.getDefaultSnapshotFileName(ls), SNAPSHOT_EXTENSION);
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG, e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return false;
        }
        return this.saveSnapshot(ls, profFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot takeSnapshot() {
        IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

            public void run() {
                ResultsManager.this.mainWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        Cursor cursor = this.mainWindow.getCursor();
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadedSnapshot snapshot = this.prepareSnapshot();
            if (snapshot != null) {
                this.loadedSnapshots.add(snapshot);
                this.fireSnapshotTaken(snapshot);
                LoadedSnapshot loadedSnapshot = snapshot;
                return loadedSnapshot;
            }
        }
        finally {
            this.mainWindow.setCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResultsAvailable() {
        Vector toNotify;
        if (this.resultsListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.resultsListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((ResultsListener)iterator.next()).resultsAvailable();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResultsReset() {
        Vector toNotify;
        if (this.resultsListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.resultsListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((ResultsListener)iterator.next()).resultsReset();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotLoaded(final LoadedSnapshot snapshot) {
        Vector toNotify;
        if (this.snapshotListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.snapshotListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((SnapshotsListener)iterator.next()).snapshotLoaded(snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotRemoved(final LoadedSnapshot snapshot) {
        Vector toNotify;
        if (this.snapshotListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.snapshotListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((SnapshotsListener)iterator.next()).snapshotRemoved(snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotSaved(final LoadedSnapshot snapshot) {
        Vector toNotify;
        if (this.snapshotListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.snapshotListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((SnapshotsListener)iterator.next()).snapshotSaved(snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotTaken(final LoadedSnapshot snapshot) {
        Vector toNotify;
        if (this.snapshotListeners == null) {
            return;
        }
        ResultsManager resultsManager = this;
        synchronized (resultsManager) {
            toNotify = (Vector)this.snapshotListeners.clone();
        }
        final Iterator iterator = toNotify.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ((SnapshotsListener)iterator.next()).snapshotTaken(snapshot);
                }
            }
        });
    }

    void exportSnapshot(LoadedSnapshot snapshot) {
        SelectedFile targetFile = this.selectSnapshotTargetFile(this.getDefaultSnapshotFileName(snapshot), false);
        if (targetFile != null && this.checkFileExists(targetFile)) {
            try {
                FileObject fo = targetFile.folder.createData(targetFile.fileName, targetFile.fileExt);
                ResultsManager.getDefault().saveSnapshot(snapshot, fo);
            }
            catch (IOException e1) {
                ErrorManager.getDefault().annotate((Throwable)e1, MessageFormat.format(SNAPSHOT_CREATE_FAILED_MSG, e1.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e1);
            }
        }
    }

    void resultsBecameAvailable() {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    void resultsReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    SelectedFile selectSnapshotTargetFile(String defaultName, final boolean heapdump) {
        String targetName;
        FileObject targetDir;
        String targetExt;
        JFileChooser chooser = new JFileChooser();
        if (this.exportDir != null) {
            chooser.setCurrentDirectory(this.exportDir);
        }
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(SELECT_FILE_OR_DIR_DIALOG_CAPTION);
        chooser.setApproveButtonText(SAVE_BUTTON_NAME);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith("." + (heapdump ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION));
            }

            public String getDescription() {
                return MessageFormat.format(PROFILER_SNAPSHOT_FILE_FILTER, heapdump ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION);
            }
        });
        if (chooser.showSaveDialog(IDEUtils.getMainWindow()) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        String string = targetExt = heapdump ? HEAPDUMP_EXTENSION : SNAPSHOT_EXTENSION;
        if (file.isDirectory()) {
            this.exportDir = chooser.getCurrentDirectory();
            targetDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            targetName = defaultName;
        } else {
            this.exportDir = chooser.getCurrentDirectory();
            targetDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.exportDir));
            String fName = file.getName();
            int idx = fName.lastIndexOf(".");
            if (idx == -1) {
                targetName = fName;
            } else {
                targetName = fName.substring(0, idx);
                targetExt = fName.substring(idx + 1);
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt);
    }

    private boolean checkFileExists(SelectedFile sf) {
        FileObject existingFile = sf.folder.getFileObject(sf.fileName, sf.fileExt);
        if (existingFile != null) {
            if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(OVERWRITE_FILE_DIALOG_MSG, sf.fileName + "." + sf.fileExt), OVERWRITE_FILE_DIALOG_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            try {
                existingFile.delete();
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(FILE_DELETE_FAILED_MSG, e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void exportSnapshot(FileObject selectedSnapshot, FileObject targetFolder, String fileName, String fileExt) {
        if (this.checkFileExists(new SelectedFile(targetFolder, fileName, fileExt))) {
            try {
                FileUtil.copyFile((FileObject)selectedSnapshot, (FileObject)targetFolder, (String)fileName, (String)fileExt);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, MessageFormat.format(SNAPSHOT_EXPORT_FAILED_MSG, e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
    }

    private LoadedSnapshot findAlreadyLoadedSnapshot(FileObject selectedFile) {
        Iterator<LoadedSnapshot> it = this.loadedSnapshots.iterator();
        File f = FileUtil.toFile((FileObject)selectedFile);
        if (f == null) {
            return null;
        }
        while (it.hasNext()) {
            LoadedSnapshot ls = it.next();
            if (ls.getFile() == null || !ls.getFile().equals(f)) continue;
            return ls;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedSnapshot loadSnapshotFromFileObject(FileObject selectedFile) throws IOException {
        FilterInputStream dis = null;
        try {
            InputStream is = selectedFile.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            LoadedSnapshot ls = LoadedSnapshot.loadSnapshot((DataInputStream)dis);
            if (ls != null) {
                ls.setFile(FileUtil.toFile((FileObject)selectedFile));
            }
            LoadedSnapshot loadedSnapshot = ls;
            return loadedSnapshot;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private LoadedSnapshot loadSnapshotImpl(FileObject selectedFile) throws IOException {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(selectedFile);
        if (ls != null) {
            return ls;
        }
        ls = this.loadSnapshotFromFileObject(selectedFile);
        if (ls != null) {
            this.loadedSnapshots.add(ls);
            this.fireSnapshotLoaded(ls);
        }
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings readSettingsFromFile(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls.getSettings();
        }
        FilterInputStream dis = null;
        try {
            InputStream is = fo.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            byte[] magicArray = new byte["nBpRoFiLeR".length()];
            int len = ((DataInputStream)dis).read(magicArray);
            if (len != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(magicArray))) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            byte majorVersion = ((DataInputStream)dis).readByte();
            byte minorVersion = ((DataInputStream)dis).readByte();
            int type = ((DataInputStream)dis).readInt();
            int compressedDataLen = ((DataInputStream)dis).readInt();
            int uncompressedDataLen = ((DataInputStream)dis).readInt();
            if (((DataInputStream)dis).skipBytes(compressedDataLen) != compressedDataLen) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            int settingsLen = ((DataInputStream)dis).readInt();
            byte[] settingsBytes = new byte[settingsLen];
            if (((DataInputStream)dis).read(settingsBytes) != settingsLen) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            Properties props = new Properties();
            ProfilingSettings settings = new ProfilingSettings();
            ByteArrayInputStream bais2 = new ByteArrayInputStream(settingsBytes);
            BufferedInputStream bufBais2 = new BufferedInputStream(bais2);
            DataInputStream settingsDis = new DataInputStream(bufBais2);
            try {
                props.load(settingsDis);
            }
            catch (IOException e) {
                ProfilerLogger.log((Exception)e);
                ProfilingSettings profilingSettings = null;
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
                return profilingSettings;
            }
            finally {
                settingsDis.close();
            }
            settings.load((Map)props);
            ProfilingSettings profilingSettings = settings;
            return profilingSettings;
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilingSettings profilingSettings = null;
            return profilingSettings;
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                ProfilerLogger.log((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTypeFromFile(FileObject fo) {
        LoadedSnapshot ls = this.findAlreadyLoadedSnapshot(fo);
        if (ls != null) {
            return ls.getType();
        }
        FilterInputStream dis = null;
        try {
            int type;
            InputStream is = fo.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            dis = new DataInputStream(bis);
            byte[] magicArray = new byte["nBpRoFiLeR".length()];
            int len = ((DataInputStream)dis).read(magicArray);
            if (len != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(magicArray))) {
                int n = 0;
                return n;
            }
            byte majorVersion = ((DataInputStream)dis).readByte();
            byte minorVersion = ((DataInputStream)dis).readByte();
            int n = type = ((DataInputStream)dis).readInt();
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    static class SelectedFile {
        FileObject folder;
        String fileExt;
        String fileName;

        SelectedFile(FileObject folder, String fileName, String fileExt) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
        }
    }
}

