/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.ExportSnapshotAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.actions.FindAction;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class MemorySnapshotPanel
extends SnapshotPanel
implements ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider {
    private static final String MEMORY_RESULTS_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabName");
    private static final String STACK_TRACES_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabName");
    private static final String INFO_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabName");
    private static final String MEMORY_RESULTS_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabDescr");
    private static final String STACK_TRACES_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabDescr");
    private static final String PANEL_TITLE = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_PanelTitle");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_FindActionTooltip");
    private static final ImageIcon MEMORY_RESULTS_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memoryResultsTab.png"));
    private static final ImageIcon INFO_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));
    private static final ImageIcon STACK_TRACES_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/stackTracesTab.png"));
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private JTabbedPane tabs = new JTabbedPane(3);
    private MemoryResultsPanel memoryPanel;
    private MemoryResultsSnapshot snapshot;
    private SnapshotInfoPanel infoPanel;
    private SnapshotReverseMemCallGraphPanel reversePanel;

    public MemorySnapshotPanel(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.snapshot = (MemoryResultsSnapshot)ls.getSnapshot();
        this.setLayout(new BorderLayout());
        SnapshotActionsHandler memoryActionsHandler = new SnapshotActionsHandler();
        this.infoPanel = new SnapshotInfoPanel(ls);
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotLivenessResultsPanel((LivenessMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler, ls.getSettings().getAllocTrackEvery());
            SnapshotLivenessResultsPanel lmemoryPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            lmemoryPanel.setSorting(sortingColumn, sortingOrder);
            lmemoryPanel.prepareResults();
        } else {
            this.memoryPanel = new SnapshotAllocResultsPanel((AllocMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            SnapshotAllocResultsPanel amemoryPanel = (SnapshotAllocResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        }
        this.infoPanel.updateInfo();
        this.tabs.addTab(MEMORY_RESULTS_TAB_NAME, MEMORY_RESULTS_TAB_ICON, (Component)this.memoryPanel, MEMORY_RESULTS_TAB_DESCR);
        if (this.snapshot.containsStacks()) {
            this.reversePanel = new SnapshotReverseMemCallGraphPanel(this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            this.reversePanel.prepareResults();
            this.tabs.addTab(STACK_TRACES_TAB_NAME, STACK_TRACES_TAB_ICON, (Component)this.reversePanel, STACK_TRACES_TAB_DESCR);
            this.tabs.setEnabledAt(this.tabs.getTabCount() - 1, false);
        }
        this.tabs.addTab(INFO_TAB_NAME, INFO_TAB_ICON, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        JToolBar toolBar = new JToolBar(){

            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        toolBar.add(new ExportSnapshotAction(ls));
        toolBar.add(new SaveViewAction(this));
        toolBar.addSeparator();
        this.findActionPresenter = toolBar.add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = toolBar.add(new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton ab = this.findActionPresenter;
            ab.setIcon(Utils.FIND_ACTION_ICON);
            ab.setText("");
            ab.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add((Component)toolBar, "North");
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.moveToNextSubTab();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindNext();
            }
        });
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        return null;
    }

    public String getViewName() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-memory_results";
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-allocation_stack_traces";
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-info";
        }
        return null;
    }

    public void displayStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.setReverseCallGraphClass(selectedClassId, sortingColumn, sortingOrder);
        this.tabs.setSelectedComponent((Component)this.reversePanel);
    }

    public boolean fitsVisibleArea() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.fitsVisibleArea();
        }
        return true;
    }

    public boolean hasView() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return true;
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return this.tabs.getSelectedComponent() == this.infoPanel;
    }

    public void performFind() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            this.reversePanel.setFindString(findString);
            if (!this.memoryPanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            this.reversePanel.setFindString(findString);
            if (!this.reversePanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void performFindNext() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.memoryPanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void performFindPrevious() {
        String findString;
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.memoryPanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    public void requestFocus() {
        if (this.memoryPanel != null) {
            this.memoryPanel.requestFocus();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        if (this.tabs.getSelectedComponent() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MemorySnapshotPanel.this.tabs.getSelectedComponent().requestFocus();
                }
            });
        }
    }

    public void updateSavedState() {
        this.infoPanel.updateInfo();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setReverseCallGraphClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.reversePanel.setClassId(selectedClassId);
        this.reversePanel.setSorting(sortingColumn, sortingOrder);
        this.reversePanel.prepareResults();
        this.tabs.setEnabledAt(this.tabs.indexOfTab(STACK_TRACES_TAB_NAME), true);
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
        boolean findEnabled = this.tabs.getSelectedComponent() != this.infoPanel && (this.tabs.getSelectedComponent() != this.reversePanel || !this.reversePanel.isEmpty());
        this.findActionPresenter.setEnabled(findEnabled);
        this.findPreviousPresenter.setEnabled(findEnabled);
        this.findNextPresenter.setEnabled(findEnabled);
    }

    private class SnapshotActionsHandler
    implements MemoryResUserActionsHandler {
        private SnapshotActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (className.length() == 1 && ("Z".equals(className) || "C".equals(className) || "B".equals(className) || "S".equals(className) || "I".equals(className) || "J".equals(className) || "F".equals(className) || "D".equals(className))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
                return;
            }
            NetBeansProfiler.getDefaultNB().openJavaSource(className, methodName, methodSig);
        }

        public void showStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
            MemorySnapshotPanel.this.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
        }
    }
}

