/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.HistoryListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class History
implements SynchronousXYChartModel,
ActionsHandler,
ProfilingStateListener {
    private static final int HISTORY_LENGTH = 1024;
    private static final String LIVE_OBJECS = NbBundle.getMessage(History.class, (String)"History_LiveObjects");
    private static final String ALLOCATED_OBJECS = NbBundle.getMessage(History.class, (String)"History_AllocatedObjects");
    private static final String ALLOCATED_SIZE = NbBundle.getMessage(History.class, (String)"History_AllocatedSize");
    private static final String LOGGING_CONFIRMATION_CAPTION = NbBundle.getMessage(History.class, (String)"History_LoggingConfirmationCaption");
    private static final String LOGGING_RESET_MSG = NbBundle.getMessage(History.class, (String)"History_LoggingResetMsg");
    private static final String LOGGING_STOP_MSG = NbBundle.getMessage(History.class, (String)"History_LoggingStopMsg");
    private static History instance = null;
    protected Color[] seriesColors = new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)};
    protected String[] seriesNames1 = new String[]{ALLOCATED_OBJECS, ALLOCATED_SIZE};
    protected String[] seriesNames2 = new String[]{LIVE_OBJECS, ALLOCATED_OBJECS};
    protected int itemCount = 0;
    protected int seriesCount = 2;
    protected long maxXValue = 0L;
    protected long maxYDisplayValue = 0L;
    protected long minXValue = 0L;
    protected long[] maxYValues = new long[this.seriesCount];
    protected long[] minYValues = new long[this.seriesCount];
    ArrayList historyListeners = new ArrayList(4);
    ArrayList listeners = new ArrayList(4);
    int[] history1;
    long[] history2;
    long[] time;
    boolean firstLine = true;
    int current = 0;
    private String className;
    private boolean enabled = false;
    private boolean liveness = false;
    private int historyClassID = -1;

    public History() {
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static History getInstance() {
        if (instance == null) {
            instance = new History();
        }
        return instance;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCurrent() {
        return this.current;
    }

    public int[] getData() {
        return this.history1;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setHistoryClass(int historyClassID, String className) {
        if (!this.enabled) {
            this.enabled = true;
            this.history1 = new int[1024];
            this.history2 = new long[1024];
            this.time = new long[1024];
        }
        this.historyClassID = historyClassID;
        this.className = StringUtils.userFormClassName((String)className);
        this.current = 0;
        this.firstLine = true;
        for (int i = 0; i < this.history1.length; ++i) {
            this.history1[i] = 0;
            this.time[i] = 0L;
        }
        this.fireHistoryLogging();
    }

    public int getHistoryClassID() {
        return this.historyClassID;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public Color getLimitYColor() {
        return Color.WHITE;
    }

    public long getLimitYValue() {
        return Long.MAX_VALUE;
    }

    public void setLiveness(boolean liveness) {
        this.liveness = liveness;
    }

    public boolean isLiveness() {
        return this.liveness;
    }

    public long getMaxDisplayYValue(int seriesIndex) {
        return seriesIndex == 0 ? this.maxYValues[seriesIndex] : this.maxYDisplayValue;
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int seriesIndex) {
        return this.maxYValues[seriesIndex];
    }

    public long getMinDisplayYValue(int seriesIndex) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int seriesIndex) {
        return 0L;
    }

    public Color getSeriesColor(int seriesIndex) {
        return this.seriesColors[seriesIndex];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int seriesIndex) {
        if (!this.isLiveness()) {
            return this.seriesNames1[seriesIndex];
        }
        return this.seriesNames2[seriesIndex];
    }

    public long getXValue(int itemIndex) {
        int index;
        if (itemIndex < 0) {
            return 0L;
        }
        int n = index = !this.firstLine ? itemIndex + this.current : itemIndex;
        if (index >= this.time.length) {
            index -= this.time.length;
        }
        return this.time[index];
    }

    public long getYValue(int itemIndex, int seriesIndex) {
        int index;
        if (itemIndex < 0) {
            return 0L;
        }
        int n = index = !this.firstLine ? itemIndex + this.current : itemIndex;
        if (index >= this.history1.length) {
            index -= this.history1.length;
        }
        if (seriesIndex == 0) {
            return this.history1[index];
        }
        return this.history2[index];
    }

    public void addChartModelListener(ChartModelListener listener) {
        this.listeners.add(listener);
    }

    public void addHistoryListener(HistoryListener listener) {
        this.historyListeners.add(listener);
    }

    public void instrumentationChanged(int i, int i0) {
    }

    public void performAction(String actionName, Object[] arguments) {
        if ("history logging".equals(actionName)) {
            ProfilerDialogs.DNSAConfirmationChecked dnsa;
            int newHistoryClassID = (Integer)arguments[0];
            if (this.historyClassID != -1 && (newHistoryClassID == this.historyClassID ? !ProfilerDialogs.notify((NotifyDescriptor)(dnsa = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.reset", (Object)MessageFormat.format(LOGGING_RESET_MSG, this.className), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION) : !ProfilerDialogs.notify((NotifyDescriptor)(dnsa = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.stop", (Object)MessageFormat.format(LOGGING_STOP_MSG, this.className), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION))) {
                return;
            }
            this.setLiveness((Boolean)arguments[2]);
            this.setHistoryClass(newHistoryClassID, (String)arguments[1]);
        } else if ("history update".equals(actionName)) {
            this.update(arguments[0], arguments[1]);
        }
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        if (profilingStateEvent.getNewState() == 1) {
            this.enabled = false;
        } else if (profilingStateEvent.getNewState() == 2) {
            this.historyClassID = -1;
        }
    }

    public void removeChartModelListener(ChartModelListener listener) {
        this.listeners.remove(listener);
    }

    public void removeHistoryListener(HistoryListener listener) {
        this.historyListeners.remove(listener);
    }

    public void threadsMonitoringChanged() {
    }

    public void update(Object hist1, Object hist2) {
        if (this.historyClassID > -1 && this.enabled) {
            if (hist1 instanceof int[]) {
                this.history1[this.current] = ((int[])hist1)[this.historyClassID];
            }
            if (hist2 != null) {
                if (hist2 instanceof int[]) {
                    this.history2[this.current] = ((int[])hist2)[this.historyClassID];
                } else if (hist2 instanceof long[]) {
                    this.history2[this.current] = ((long[])hist2)[this.historyClassID];
                }
            }
            this.time[this.current] = System.currentTimeMillis();
            ++this.current;
            if (this.current >= this.history1.length) {
                this.current = 0;
                this.firstLine = false;
            }
            int n = this.itemCount = this.firstLine ? this.current : this.history1.length;
            this.minXValue = this.firstLine ? this.time[0] : (this.current < this.time.length - 1 ? this.time[this.current] : this.time[0]);
            this.maxXValue = this.current > 0 ? this.time[this.current - 1] : this.time[this.time.length - 1];
            this.setMinMax();
            this.fireChartChanged();
        }
    }

    protected long getDisplay(long min, long max) {
        long n = max - min;
        for (long num = 1L; 10L * n > num; num *= 10L) {
            if (num > n) {
                return num;
            }
            if (2L * num > n) {
                return 2L * num;
            }
            if (5L * num <= n) continue;
            return 5L * num;
        }
        return n;
    }

    protected void setMinMax() {
        int a = this.firstLine ? this.current : this.history1.length;
        int m = 0;
        long m2 = 0L;
        for (int i = 0; i < a; ++i) {
            if (this.history1[i] > m) {
                m = this.history1[i];
            }
            if (this.history2[i] <= m2) continue;
            m2 = this.history2[i];
        }
        this.maxYValues[0] = m;
        this.maxYValues[1] = m2;
        this.maxYDisplayValue = this.getDisplay(this.getMinYValue(1), m2);
    }

    protected void fireChartChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ChartModelListener)this.listeners.get(i)).chartDataChanged();
        }
    }

    protected void fireHistoryLogging() {
        for (int i = 0; i < this.historyListeners.size(); ++i) {
            ((HistoryListener)this.historyListeners.get(i)).historyLogging();
        }
    }
}

