/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.modules.autoupdate.updateprovider.LocalNBMsProvider;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateUnitProviderImpl {
    private UpdateProvider provider;
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl");
    private static final String REMOVED_MASK = "_removed";
    private static final String URL = "url";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENABLED = "enabled";
    private static final String CATEGORY_NAME = "categoryName";

    public UpdateUnitProviderImpl(UpdateProvider updateProvider) {
        this.provider = updateProvider;
    }

    public String getName() {
        return this.getUpdateProvider().getName();
    }

    public String getDescription() {
        return this.getUpdateProvider().getDescription();
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.getUpdateProvider().getCategory();
    }

    public String getDisplayName() {
        return UpdateUnitProviderImpl.loadDisplayName(this.getUpdateProvider());
    }

    public void setDisplayName(String string) {
        UpdateUnitProviderImpl.storeDisplayName(this.getUpdateProvider(), string);
    }

    public URL getProviderURL() {
        return UpdateUnitProviderImpl.loadUrl(this.getUpdateProvider());
    }

    public void setProviderURL(URL uRL) {
        UpdateUnitProviderImpl.storeUrl(this.getUpdateProvider(), uRL);
    }

    public List<UpdateUnit> getUpdateUnits(UpdateManager.TYPE ... tYPEArray) {
        return UpdateManagerImpl.getUpdateUnits(this.getUpdateProvider(), tYPEArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(ProgressHandle progressHandle, boolean bl) throws IOException {
        boolean bl2 = false;
        ProgressHandle progressHandle2 = null;
        if (progressHandle == null) {
            CancellableProgress cancellableProgress = new CancellableProgress();
            progressHandle2 = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_CheckingForUpdates"), (Cancellable)cancellableProgress);
            cancellableProgress.setHandle(progressHandle2);
            progressHandle2.setInitialDelay(0);
            progressHandle2.start();
        }
        try {
            if (progressHandle != null) {
                progressHandle.progress(NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_FormatCheckingForUpdates", (Object)this.getDisplayName()));
            } else if (progressHandle2 != null) {
                progressHandle2.progress(this.getDisplayName());
            }
            this.getUpdateProvider().refresh(bl);
            if (bl) {
                AutoupdateSettings.setLastCheck(new Date());
            }
        }
        finally {
            if (progressHandle2 != null) {
                progressHandle2.finish();
            }
        }
        UpdateManagerImpl.getInstance().clearCache();
        return bl2;
    }

    public void setEnable(boolean bl) {
        UpdateManagerImpl.getInstance().clearCache();
        UpdateUnitProviderImpl.storeState(this.getUpdateProvider(), bl);
    }

    public boolean isEnabled() {
        return UpdateUnitProviderImpl.loadState(this.getUpdateProvider().getName());
    }

    public UpdateProvider getUpdateProvider() {
        assert (this.provider != null) : "UpdateProvider found.";
        return this.provider;
    }

    public static void remove(UpdateUnitProvider updateUnitProvider) {
        UpdateUnitProviderImpl updateUnitProviderImpl = Trampoline.API.impl(updateUnitProvider);
        updateUnitProviderImpl.remove();
    }

    private void remove() {
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(this.getName())) {
                UpdateUnitProviderImpl.getPreferences().node(this.getName()).removeNode();
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            } else {
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL) {
        return UpdateUnitProviderImpl.createUpdateUnitProvider(string, string2, uRL, UpdateUnitProvider.CATEGORY.COMMUNITY);
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, String string2, URL uRL, UpdateUnitProvider.CATEGORY cATEGORY) {
        UpdateUnitProviderImpl.storeProvider(string, string2, uRL);
        AutoupdateCatalogProvider autoupdateCatalogProvider = new AutoupdateCatalogProvider(string, string2, uRL, cATEGORY);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(autoupdateCatalogProvider));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String string, File ... fileArray) {
        LocalNBMsProvider localNBMsProvider = new LocalNBMsProvider(string, fileArray);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(localNBMsProvider));
    }

    public static List<UpdateUnitProvider> getUpdateUnitProviders(boolean bl) {
        Object object;
        ArrayList<UpdateUnitProvider> arrayList;
        Object object2;
        Lookup.Result result;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/AutoupdateType");
        if (fileObject != null) {
            result = fileObject.getChildren();
            for (int i = 0; i < ((Lookup.Result)result).length; ++i) {
                try {
                    if (UpdateUnitProviderImpl.getPreferences().nodeExists(result[i].getName())) continue;
                    try {
                        object2 = (String)result[i].getAttribute("SystemFileSystem.localizingBundle");
                        if (object2 != null) {
                            arrayList = AutoupdateCatalogFactory.createUpdateProvider((FileObject)result[i]);
                            assert (arrayList != null) : "UpdateProvider found for " + result[i];
                            UpdateUnitProviderImpl.getPreferences().node(result[i].getName()).putBoolean("loaded", Boolean.TRUE);
                            err.log(Level.FINEST, result[i] + " loaded.");
                            continue;
                        }
                        err.log(Level.INFO, result[i] + " cannot be loaded because doesn't contain SystemFileSystem.localizingBundle.");
                        UpdateUnitProviderImpl.getPreferences().node(result[i].getName()).putBoolean("loaded", Boolean.FALSE);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    continue;
                }
                catch (BackingStoreException backingStoreException) {
                    err.log(Level.INFO, backingStoreException.getMessage() + " while loading " + result[i], backingStoreException);
                }
            }
        }
        result = Lookup.getDefault().lookup(new Lookup.Template(UpdateProvider.class));
        result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                try {
                    UpdateUnitProviderImpl.refreshProviders(null, false);
                    err.log(Level.FINE, "Lookup.Result changed " + lookupEvent);
                }
                catch (IOException iOException) {
                    err.log(Level.INFO, iOException.getMessage(), iOException);
                }
            }
        });
        Collection collection = result.allInstances();
        object2 = new HashMap();
        for (Object object3 : collection) {
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(object3.getName() + REMOVED_MASK)) {
                    continue;
                }
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
            object2.put(object3.getName(), object3);
        }
        try {
            Object object3;
            arrayList = UpdateUnitProviderImpl.getPreferences();
            object3 = ((Preferences)((Object)arrayList)).childrenNames();
            if (object3 != null) {
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    object = UpdateUnitProviderImpl.loadProvider(object3[i]);
                    if (object != null && object2.containsKey(object.getName())) {
                        err.log(Level.FINE, "Customized Provider " + object.getName());
                    }
                    if (object != null) {
                        object2.put(object.getName(), object);
                    }
                    boolean bl2 = UpdateUnitProviderImpl.loadState((String)object3[i]);
                    if (!bl || bl2) continue;
                    object2.remove(object3[i]);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            err.log(Level.INFO, backingStoreException.getMessage(), backingStoreException);
        }
        arrayList = new ArrayList<UpdateUnitProvider>(object2.values().size());
        for (UpdateProvider updateProvider : object2.values()) {
            object = new UpdateUnitProviderImpl(updateProvider);
            arrayList.add(Trampoline.API.createUpdateUnitProvider((UpdateUnitProviderImpl)object));
        }
        return arrayList;
    }

    public static void refreshProviders(ProgressHandle progressHandle, boolean bl) throws IOException {
        List<UpdateUnitProvider> list = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        for (UpdateUnitProvider updateUnitProvider : list) {
            updateUnitProvider.refresh(progressHandle, bl);
        }
        if (bl) {
            AutoupdateSettings.setLastCheck(new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    private static void storeProvider(String string, String string2, URL uRL) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        preferences.put(URL, uRL.toString());
        preferences.put(DISPLAY_NAME, string2);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static UpdateProvider loadProvider(String string) {
        URL uRL;
        UpdateUnitProvider.CATEGORY cATEGORY;
        String string2;
        block4: {
            Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
            assert (preferences != null) : "Preferences node " + string + " found.";
            String string3 = preferences.get(URL, preferences.get("originalUrl", null));
            string2 = preferences.get(DISPLAY_NAME, preferences.get("originalDisplayName", string));
            cATEGORY = UpdateUnitProvider.CATEGORY.valueOf(preferences.get(CATEGORY_NAME, preferences.get("originalCategoryName", UpdateUnitProvider.CATEGORY.COMMUNITY.name())));
            if (string3 == null) {
                return null;
            }
            uRL = null;
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return new AutoupdateCatalogProvider(string, string2, uRL, cATEGORY);
    }

    private static boolean loadState(String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(string);
        assert (preferences != null) : "Preferences node " + string + " found.";
        String string2 = preferences.get(ENABLED, preferences.get("originalEnabled", null));
        return !Boolean.FALSE.toString().equals(string2);
    }

    private static void storeState(UpdateProvider updateProvider, boolean bl) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        preferences.put(ENABLED, Boolean.valueOf(bl).toString());
    }

    private static String loadDisplayName(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        return preferences.get(DISPLAY_NAME, updateProvider.getDisplayName());
    }

    private static void storeDisplayName(UpdateProvider updateProvider, String string) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (string == null) {
            preferences.remove(DISPLAY_NAME);
        } else if (!string.equals(updateProvider.getDisplayName())) {
            preferences.put(DISPLAY_NAME, string);
        }
    }

    private static URL loadUrl(UpdateProvider updateProvider) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        String string = null;
        if (updateProvider instanceof AutoupdateCatalogProvider) {
            string = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL().toExternalForm();
        }
        if ((string = preferences.get(URL, string)) == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("?unique");
        if (n != -1) {
            string = string.substring(0, n);
        }
        err.log(Level.FINE, "Use urlSpec " + string + " for Provider " + updateProvider);
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            err.log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    private static void storeUrl(UpdateProvider updateProvider, URL uRL) {
        Preferences preferences = UpdateUnitProviderImpl.getPreferences().node(updateProvider.getName());
        assert (preferences != null) : "Preferences node " + updateProvider.getName() + " found.";
        if (uRL == null) {
            preferences.remove(URL);
        } else {
            URL uRL2 = null;
            if (updateProvider instanceof AutoupdateCatalogProvider) {
                uRL2 = ((AutoupdateCatalogProvider)updateProvider).getUpdateCenterURL();
            }
            if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                preferences.put(URL, uRL.toExternalForm());
                if (updateProvider instanceof AutoupdateCatalogProvider) {
                    ((AutoupdateCatalogProvider)updateProvider).setUpdateCenterURL(uRL);
                }
            }
        }
    }

    private static class CancellableProgress
    implements Cancellable {
        private ProgressHandle handle;

        private CancellableProgress() {
        }

        public boolean cancel() {
            assert (this.handle != null);
            this.handle.finish();
            return true;
        }

        private void setHandle(ProgressHandle progressHandle) {
            this.handle = progressHandle;
        }
    }
}

