/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.coredump.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.coredump.CoreDumpSupport;
import com.sun.tools.visualvm.coredump.CoreDumpsContainer;
import com.sun.tools.visualvm.coredump.impl.CoreDumpImpl;
import com.sun.tools.visualvm.tools.sa.SaModel;
import com.sun.tools.visualvm.tools.sa.SaModelFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class CoreDumpProvider {
    private static final Logger LOGGER = Logger.getLogger(CoreDumpProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTY_JAVA_HOME = "prop_java_home";

    static void createCoreDump(final String coreDumpFile, final String displayName, final String jdkHome, final boolean deleteCoreDump) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CoreDumpProvider.createCoreDumpImpl(coreDumpFile, displayName, jdkHome, deleteCoreDump);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createCoreDumpImpl(String coreDumpFile, final String displayName, String jdkHome, boolean deleteCoreDump) {
        final CoreDumpImpl knownCoreDump = CoreDumpProvider.getCoreDumpByFile(new File(coreDumpFile));
        if (knownCoreDump != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExplorerSupport.sharedInstance().selectDataSource((DataSource)knownCoreDump);
                    NetBeansProfiler.getDefaultNB().displayWarning(NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_Core_dump_already_added", (Object[])new Object[]{displayName, DataSourceDescriptorFactory.getDescriptor((DataSource)knownCoreDump).getName()}));
                }
            });
            return;
        }
        if (deleteCoreDump) {
            ProgressHandle pHandleF;
            ProgressHandle pHandle = null;
            try {
                pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_Adding", (Object)displayName));
                pHandle.setInitialDelay(0);
                pHandle.start();
                File file = new File(coreDumpFile);
                File copy = Utils.getUniqueFile((File)CoreDumpSupport.getStorageDirectory(), (String)file.getName());
                if (Utils.copyFile((File)file, (File)copy)) {
                    coreDumpFile = copy.getAbsolutePath();
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
                pHandleF = pHandle;
            }
            catch (Throwable throwable) {
                ProgressHandle pHandleF2 = pHandle;
                SwingUtilities.invokeLater(new Runnable(pHandleF2){
                    final /* synthetic */ ProgressHandle val$pHandleF;
                    {
                        this.val$pHandleF = progressHandle;
                    }

                    public void run() {
                        if (this.val$pHandleF != null) {
                            this.val$pHandleF.finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        String[] propNames = new String[]{SNAPSHOT_VERSION, "prop_file", "prop_name", PROPERTY_JAVA_HOME};
        String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, coreDumpFile, displayName, jdkHome};
        File customPropertiesStorage = Utils.getUniqueFile((File)CoreDumpSupport.getStorageDirectory(), (String)new File(coreDumpFile).getName(), (String)".properties");
        Storage storage = new Storage(customPropertiesStorage.getParentFile(), customPropertiesStorage.getName());
        try {
            CoreDumpImpl newCoreDump = new CoreDumpImpl(new File(coreDumpFile), new File(jdkHome), storage);
            if (newCoreDump != null) {
                new CoreDumpAdder(newCoreDump, storage, propNames, propValues).execute();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error creating coredump", e);
            return;
        }
    }

    private static CoreDumpImpl getCoreDumpByFile(File file) {
        if (!file.isFile()) {
            return null;
        }
        Set knownCoredumps = DataSourceRepository.sharedInstance().getDataSources(CoreDumpImpl.class);
        for (CoreDumpImpl knownCoredump : knownCoredumps) {
            if (!knownCoredump.getFile().equals(file)) continue;
            return knownCoredump;
        }
        return null;
    }

    private void initPersistedCoreDumps() {
        if (!CoreDumpSupport.storageDirectoryExists()) {
            return;
        }
        File[] files = CoreDumpSupport.getStorageDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        HashSet<CoreDumpImpl> coredumps = new HashSet<CoreDumpImpl>();
        for (File file : files) {
            Storage storage = new Storage(file.getParentFile(), file.getName());
            String[] propNames = new String[]{"prop_file", PROPERTY_JAVA_HOME};
            String[] propValues = storage.getCustomProperties(propNames);
            CoreDumpImpl persistedCoredump = null;
            try {
                persistedCoredump = new CoreDumpImpl(new File(propValues[0]), new File(propValues[1]), storage);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error loading persisted host", e);
            }
            if (persistedCoredump == null) continue;
            coredumps.add(persistedCoredump);
        }
        if (!coredumps.isEmpty()) {
            CoreDumpsContainer.sharedInstance().getRepository().addDataSources(coredumps);
        }
    }

    CoreDumpProvider() {
    }

    public static void register() {
        if (Utilities.isWindows()) {
            return;
        }
        final CoreDumpProvider provider = new CoreDumpProvider();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        provider.initPersistedCoreDumps();
                    }
                });
            }
        });
    }

    private static class CoreDumpAdder
    extends SwingWorker {
        private volatile ProgressHandle ph = null;
        private volatile boolean success = false;
        private CoreDumpImpl newCoreDump;
        private Storage storage;
        private String[] propNames;
        private String[] propValues;

        public CoreDumpAdder(CoreDumpImpl newCoreDump, Storage storage, String[] propNames, String[] propValues) {
            this.newCoreDump = newCoreDump;
            this.storage = storage;
            this.propValues = propValues;
            this.propNames = propNames;
        }

        protected void doInBackground() {
            SaModel model = SaModelFactory.getSAAgentFor((DataSource)this.newCoreDump);
            if (model != null) {
                CoreDumpsContainer.sharedInstance().getRepository().addDataSource((DataSource)this.newCoreDump);
                this.storage.setCustomProperties(this.propNames, this.propValues);
                this.success = true;
            }
        }

        protected void nonResponding() {
            this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CoreDumpProvider.class, (String)"LBL_Inspecting_core_dump"));
            this.ph.start();
        }

        protected void done() {
            if (this.ph != null) {
                this.ph.finish();
            }
            if (!this.success) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CoreDumpProvider.class, (String)"MSG_not_valid_core_dump", (Object)this.newCoreDump.getFile().getAbsolutePath())));
            }
        }
    }
}

