/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.providers.AutoMountProvider;
import org.netbeans.modules.masterfs.providers.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ProviderCall {
    private static Map providerMap;
    private static Lookup.Result preventsLookupResultFromGC;

    static void init() {
        ProviderCall.getProviderMap();
    }

    static FileSystem createFileSystem(String string) {
        FileSystem fileSystem = null;
        AutoMountProvider autoMountProvider = ProviderCall.getMountAble(string);
        if (autoMountProvider != null) {
            try {
                fileSystem = autoMountProvider.createFileSystem(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
                return null;
            }
        }
        return fileSystem;
    }

    static boolean isMountAble(String string) {
        return ProviderCall.getMountAble(string) != null;
    }

    static Image getIcon(String string, int n) {
        Image image = null;
        AutoMountProvider autoMountProvider = ProviderCall.getMountAble(string);
        if (autoMountProvider != null) {
            image = autoMountProvider.getIcon(string, n);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoMountProvider getMountAble(String string) {
        HashMap hashMap;
        Object object = ProviderCall.getProviderMap();
        synchronized (object) {
            hashMap = new HashMap(ProviderCall.getProviderMap());
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            boolean bl;
            AutoMountProvider autoMountProvider = (AutoMountProvider)object.next();
            if (autoMountProvider == null || !(bl = autoMountProvider.isRootOfFileSystem(string))) continue;
            return autoMountProvider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getProviderMap() {
        Class clazz = MasterFileSystem.class;
        synchronized (clazz) {
            if (providerMap == null) {
                Lookup.Result result;
                providerMap = Collections.synchronizedMap(new HashMap());
                preventsLookupResultFromGC = result = Lookup.getDefault().lookup(new Lookup.Template(FileSystemProvider.class));
                ProviderCall.initFileSystemProviders(result);
                result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        ProviderCall.initFileSystemProviders(result);
                    }
                });
            }
        }
        return providerMap;
    }

    private static void initFileSystemProviders(Lookup.Result result) {
        HashSet hashSet = new HashSet(result.allInstances());
        HashMap<FileSystemProvider, AutoMountProvider> hashMap = new HashMap<FileSystemProvider, AutoMountProvider>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            FileSystemProvider fileSystemProvider = (FileSystemProvider)iterator.next();
            AutoMountProvider autoMountProvider = (AutoMountProvider)ProviderCall.getProviderMap().get(fileSystemProvider);
            if (autoMountProvider == null && !ProviderCall.getProviderMap().keySet().contains(fileSystemProvider)) {
                MountTable.getDefault();
                autoMountProvider = fileSystemProvider.initialize(MountTable.mountSupport);
            }
            hashMap.put(fileSystemProvider, autoMountProvider);
        }
        ProviderCall.getProviderMap().clear();
        ProviderCall.getProviderMap().putAll(hashMap);
    }
}

