/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import sun.jvm.hotspot.interpreter.Bytecodes;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.Bytes;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class ByteCodeRewriter {
    private Method method;
    private ConstantPool cpool;
    private ConstantPoolCache cpCache;
    private byte[] code;
    private Bytes bytes;
    public static final boolean DEBUG = false;
    private static final int jintSize = 4;

    protected void debugMessage(String message) {
        System.out.println(message);
    }

    public ByteCodeRewriter(Method method, ConstantPool cpool, byte[] code) {
        this.method = method;
        this.cpool = cpool;
        this.cpCache = cpool.getCache();
        this.code = code;
        this.bytes = VM.getVM().getBytes();
    }

    protected short getConstantPoolIndex(int bci) {
        short cpCacheIndex = this.method.getBytecodeShortArg(bci);
        if (this.cpCache == null) {
            return cpCacheIndex;
        }
        return (short)this.cpCache.getEntryAt(0xFFFF & this.bytes.swapShort(cpCacheIndex)).getConstantPoolIndex();
    }

    private static void writeShort(byte[] buf, int index, short value) {
        buf[index] = (byte)(value >> 8 & 0xFF);
        buf[index + 1] = (byte)(value & 0xFF);
    }

    public void rewrite() {
        int bytecode = -1;
        int hotspotcode = -1;
        int len = 0;
        for (int bci = 0; bci < this.code.length; bci += len) {
            hotspotcode = Bytecodes.codeAt(this.method, bci);
            bytecode = Bytecodes.javaCode(hotspotcode);
            if (Assert.ASSERTS_ENABLED) {
                int code_from_buffer = 0xFF & this.code[bci];
                Assert.that(code_from_buffer == hotspotcode || code_from_buffer == 202, "Unexpected bytecode found in method bytecode buffer!");
            }
            this.code[bci] = (byte)(0xFF & bytecode);
            if (hotspotcode == 220 || hotspotcode == 221 || hotspotcode == 222) {
                this.code[++bci] = -76;
                bytecode = 180;
                hotspotcode = 180;
            } else if (hotspotcode == 224) {
                this.code[++bci] = 21;
                bytecode = 21;
                hotspotcode = 21;
            } else if (hotspotcode == 225) {
                this.code[++bci] = 52;
                bytecode = 52;
                bytecode = 52;
            }
            short cpoolIndex = 0;
            switch (bytecode) {
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    cpoolIndex = this.getConstantPoolIndex(bci + 1);
                    ByteCodeRewriter.writeShort(this.code, bci + 1, cpoolIndex);
                }
            }
            len = Bytecodes.lengthFor(bytecode);
            if (len > 0) continue;
            len = Bytecodes.lengthAt(this.method, bci);
        }
    }
}

