/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ArrayKlassKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class TypeArrayKlassKlass
extends ArrayKlassKlass {
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("typeArrayKlassKlass");
        headerSize = type.getSize() + Oop.getHeaderSize();
    }

    public TypeArrayKlassKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public long getObjectSize() {
        return TypeArrayKlassKlass.alignObjectSize(headerSize);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("TypeArrayKlassKlass");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                TypeArrayKlassKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

