/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class LocalVariableTableElement {
    private static long offsetOfStartBCI;
    private static long offsetOfLength;
    private static long offsetOfNameCPIndex;
    private static long offsetOfDescriptorCPIndex;
    private static long offsetOfSignatureCPIndex;
    private static long offsetOfSlot;
    private OopHandle handle;
    private long offset;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("LocalVariableTableElement");
        offsetOfStartBCI = type.getCIntegerField("start_bci").getOffset();
        offsetOfLength = type.getCIntegerField("length").getOffset();
        offsetOfNameCPIndex = type.getCIntegerField("name_cp_index").getOffset();
        offsetOfDescriptorCPIndex = type.getCIntegerField("descriptor_cp_index").getOffset();
        offsetOfSignatureCPIndex = type.getCIntegerField("signature_cp_index").getOffset();
        offsetOfSlot = type.getCIntegerField("slot").getOffset();
    }

    public LocalVariableTableElement(OopHandle handle, long offset) {
        this.handle = handle;
        this.offset = offset;
    }

    public int getStartBCI() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfStartBCI, 2L, true);
    }

    public int getLength() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfLength, 2L, true);
    }

    public int getNameCPIndex() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfNameCPIndex, 2L, true);
    }

    public int getDescriptorCPIndex() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfDescriptorCPIndex, 2L, true);
    }

    public int getSignatureCPIndex() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfSignatureCPIndex, 2L, true);
    }

    public int getSlot() {
        return (int)this.handle.getCIntegerAt(this.offset + offsetOfSlot, 2L, true);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                LocalVariableTableElement.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

