/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.BooleanValueImpl;
import sun.jvm.hotspot.jdi.ByteValueImpl;
import sun.jvm.hotspot.jdi.CharValueImpl;
import sun.jvm.hotspot.jdi.DoubleValueImpl;
import sun.jvm.hotspot.jdi.FloatValueImpl;
import sun.jvm.hotspot.jdi.IntegerValueImpl;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.LongValueImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.ShortValueImpl;
import sun.jvm.hotspot.jdi.TypeComponentImpl;
import sun.jvm.hotspot.jdi.ValueImpl;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;

public class FieldImpl
extends TypeComponentImpl
implements com.sun.jdi.Field {
    private JNITypeParser signatureParser;
    private Field saField;

    FieldImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, Field saField) {
        super(vm, declaringType);
        this.saField = saField;
        this.getParser();
    }

    private void getParser() {
        if (this.signatureParser == null) {
            Symbol sig1 = this.saField.getSignature();
            this.signature = sig1.asString();
            this.signatureParser = new JNITypeParser(this.signature);
        }
    }

    Field ref() {
        return this.saField;
    }

    ValueImpl getValue() {
        return this.getValue(this.saField.getFieldHolder());
    }

    ValueImpl getValue(Oop target) {
        ValueImpl valueImpl;
        Field saField = this.ref();
        FieldType ft = saField.getFieldType();
        if (ft.isArray()) {
            OopField of = (OopField)saField;
            valueImpl = this.vm.arrayMirror((Array)of.getValue(target));
        } else if (ft.isObject()) {
            OopField of = (OopField)saField;
            valueImpl = this.vm.objectMirror(of.getValue(target));
        } else if (ft.isByte()) {
            ByteField bf = (ByteField)saField;
            valueImpl = (ByteValueImpl)this.vm.mirrorOf(bf.getValue(target));
        } else if (ft.isChar()) {
            CharField cf = (CharField)saField;
            valueImpl = (CharValueImpl)this.vm.mirrorOf(cf.getValue(target));
        } else if (ft.isDouble()) {
            DoubleField df = (DoubleField)saField;
            valueImpl = (DoubleValueImpl)this.vm.mirrorOf(df.getValue(target));
        } else if (ft.isFloat()) {
            FloatField ff = (FloatField)saField;
            valueImpl = (FloatValueImpl)this.vm.mirrorOf(ff.getValue(target));
        } else if (ft.isInt()) {
            IntField iif = (IntField)saField;
            valueImpl = (IntegerValueImpl)this.vm.mirrorOf(iif.getValue(target));
        } else if (ft.isLong()) {
            LongField lf = (LongField)saField;
            valueImpl = (LongValueImpl)this.vm.mirrorOf(lf.getValue(target));
        } else if (ft.isShort()) {
            ShortField sf = (ShortField)saField;
            valueImpl = (ShortValueImpl)this.vm.mirrorOf(sf.getValue(target));
        } else if (ft.isBoolean()) {
            BooleanField bf = (BooleanField)saField;
            valueImpl = (BooleanValueImpl)this.vm.mirrorOf(bf.getValue(target));
        } else {
            throw new RuntimeException("Should not reach here");
        }
        return valueImpl;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FieldImpl) {
            FieldImpl other = (FieldImpl)obj;
            return ((Object)this.declaringType()).equals(other.declaringType()) && this.ref().equals(other.ref()) && super.equals(obj);
        }
        return false;
    }

    public boolean isTransient() {
        return this.saField.isTransient();
    }

    public boolean isVolatile() {
        return this.saField.isVolatile();
    }

    public boolean isEnumConstant() {
        return this.saField.isEnumConstant();
    }

    public Type type() throws ClassNotLoadedException {
        return this.findType(this.signature());
    }

    public String typeName() {
        this.getParser();
        return this.signatureParser.typeName();
    }

    public String genericSignature() {
        Symbol genSig = this.saField.getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    public int compareTo(Object object) {
        com.sun.jdi.Field field = (com.sun.jdi.Field)object;
        ReferenceTypeImpl declaringType = (ReferenceTypeImpl)this.declaringType();
        int rc = declaringType.compareTo(field.declaringType());
        if (rc == 0) {
            rc = declaringType.indexOf(this) - declaringType.indexOf(field);
        }
        return rc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.declaringType().name());
        buf.append('.');
        buf.append(this.name());
        return buf.toString();
    }

    public String name() {
        FieldIdentifier myName = this.saField.getID();
        return myName.getName();
    }

    public int modifiers() {
        return this.saField.getAccessFlagsObj().getStandardFlags();
    }

    public boolean isPackagePrivate() {
        return this.saField.isPackagePrivate();
    }

    public boolean isPrivate() {
        return this.saField.isPrivate();
    }

    public boolean isProtected() {
        return this.saField.isProtected();
    }

    public boolean isPublic() {
        return this.saField.isPublic();
    }

    public boolean isStatic() {
        return this.saField.isStatic();
    }

    public boolean isFinal() {
        return this.saField.isFinal();
    }

    public boolean isSynthetic() {
        return this.saField.isSynthetic();
    }

    public int hashCode() {
        return this.saField.hashCode();
    }

    private Type findType(String signature) throws ClassNotLoadedException {
        ReferenceTypeImpl enclosing = (ReferenceTypeImpl)this.declaringType();
        return enclosing.findType(signature);
    }
}

