/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.ObjectReferenceImpl;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference {
    private List visibleClassesCache;
    private List definedClassesCache;

    ClassLoaderReferenceImpl(VirtualMachine aVm, Instance oRef) {
        super(aVm, oRef);
    }

    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    public List definedClasses() {
        if (this.definedClassesCache == null) {
            this.definedClassesCache = new ArrayList();
            Iterator iter = this.vm.allClasses().iterator();
            while (iter.hasNext()) {
                ReferenceType type = (ReferenceType)iter.next();
                if (!this.equals(type.classLoader())) continue;
                this.definedClassesCache.add(type);
            }
        }
        return this.definedClassesCache;
    }

    private SystemDictionary getSystemDictionary() {
        return this.vm.saSystemDictionary();
    }

    private Universe getUniverse() {
        return this.vm.saUniverse();
    }

    public List visibleClasses() {
        if (this.visibleClassesCache != null) {
            return this.visibleClassesCache;
        }
        this.visibleClassesCache = new ArrayList();
        SystemDictionary sysDict = this.getSystemDictionary();
        sysDict.classesDo(new SystemDictionary.ClassAndLoaderVisitor(){

            public void visit(Klass k, Oop loader) {
                if (ClassLoaderReferenceImpl.this.ref().equals(loader)) {
                    for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                        ClassLoaderReferenceImpl.this.visibleClassesCache.add(ClassLoaderReferenceImpl.this.vm.referenceType(l));
                    }
                }
            }
        });
        sysDict.primArrayClassesDo(new SystemDictionary.ClassAndLoaderVisitor(){

            public void visit(Klass k, Oop loader) {
                if (ClassLoaderReferenceImpl.this.ref().equals(loader)) {
                    ClassLoaderReferenceImpl.this.visibleClassesCache.add(ClassLoaderReferenceImpl.this.vm.referenceType(k));
                }
            }
        });
        this.getUniverse().basicTypeClassesDo(new SystemDictionary.ClassVisitor(){

            public void visit(Klass k) {
                ClassLoaderReferenceImpl.this.visibleClassesCache.add(ClassLoaderReferenceImpl.this.vm.referenceType(k));
            }
        });
        return this.visibleClassesCache;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        List types = this.visibleClasses();
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            ReferenceType type = (ReferenceType)iter.next();
            if (!type.signature().equals(signature)) continue;
            return type;
        }
        JNITypeParser parser = new JNITypeParser(signature);
        throw new ClassNotLoadedException(parser.typeName(), "Class " + parser.typeName() + " not loaded");
    }
}

