/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.RemoteHostsContainer;
import com.sun.tools.visualvm.host.impl.HostDescriptorProvider;
import com.sun.tools.visualvm.host.impl.HostProperties;
import com.sun.tools.visualvm.host.impl.HostProvider;
import java.io.File;
import java.net.InetAddress;

public final class HostsSupport {
    private static final String HOSTS_STORAGE_DIRNAME = "hosts";
    private static final Object hostsStorageDirectoryLock = new Object();
    private static File hostsStorageDirectory;
    private static final Object hostsStorageDirectoryStringLock;
    private static String hostsStorageDirectoryString;
    private static HostsSupport instance;
    private final HostProvider hostProvider = new HostProvider();

    public static synchronized HostsSupport getInstance() {
        if (instance == null) {
            instance = new HostsSupport();
        }
        return instance;
    }

    public Host createHost(String hostname) {
        return this.getHostProvider().createHost(new HostProperties(hostname, hostname), true);
    }

    public Host getHostByAddress(InetAddress inetAddress) {
        return this.getHostProvider().getHostByAddress(inetAddress);
    }

    public HostProvider getHostProvider() {
        return this.hostProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStorageDirectoryString() {
        Object object = hostsStorageDirectoryStringLock;
        synchronized (object) {
            if (hostsStorageDirectoryString == null) {
                hostsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + HOSTS_STORAGE_DIRNAME;
            }
            return hostsStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = hostsStorageDirectoryLock;
        synchronized (object) {
            if (hostsStorageDirectory == null) {
                String snapshotsStorageString = HostsSupport.getStorageDirectoryString();
                hostsStorageDirectory = new File(snapshotsStorageString);
                if (hostsStorageDirectory.exists() && hostsStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + snapshotsStorageString + ", file in the way");
                }
                if (!(!hostsStorageDirectory.exists() || hostsStorageDirectory.canRead() && hostsStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access hosts storage directory " + snapshotsStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)hostsStorageDirectory)) {
                    throw new IllegalStateException("Cannot create hosts storage directory " + snapshotsStorageString);
                }
            }
            return hostsStorageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(HostsSupport.getStorageDirectoryString()).isDirectory();
    }

    Host createLocalHost() {
        return this.hostProvider.createLocalHost();
    }

    Host createUnknownHost() {
        return this.hostProvider.createUnknownHost();
    }

    private HostsSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new HostDescriptorProvider());
        RemoteHostsContainer container = RemoteHostsContainer.sharedInstance();
        DataSource.ROOT.getRepository().addDataSource((DataSource)container);
        this.hostProvider.initialize();
    }

    static {
        hostsStorageDirectoryStringLock = new Object();
    }
}

