/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm;

import sun.jvm.hotspot.asm.ImmediateOrRegister;

public abstract class Register
extends ImmediateOrRegister {
    protected int number;

    public Register() {
        this.number = -1;
    }

    public Register(int number) {
        this.number = number;
    }

    public abstract int getNumberOfRegisters();

    public boolean isValid() {
        return 0 <= this.number && this.number <= this.getNumberOfRegisters();
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (!this.getClass().equals(x.getClass())) {
            return false;
        }
        Register reg = (Register)x;
        return reg.getNumber() == this.getNumber();
    }

    public int hashCode() {
        return this.number;
    }

    public boolean isRegister() {
        return true;
    }

    public abstract boolean isStackPointer();

    public abstract boolean isFramePointer();

    public abstract boolean isFloat();
}

