/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.MixerThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.AudioPermission;
import sun.misc.Service;

class JSSecurityManager {
    private JSSecurityManager() {
    }

    private static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AudioPermission("record"));
        }
    }

    static void loadLibrary(final String string) {
        if (JSSecurityManager.hasSecurityManager()) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary(string);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        } else {
            System.loadLibrary(string);
        }
    }

    static String getProperty(final String string) {
        String string2;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty(string);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                };
                string2 = (String)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                string2 = System.getProperty(string);
            }
        } else {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    static void loadProperties(final Properties properties, final String string) {
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        JSSecurityManager.loadPropertiesImpl(properties, string);
                        return null;
                    }
                };
                AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                JSSecurityManager.loadPropertiesImpl(properties, string);
            }
        } else {
            JSSecurityManager.loadPropertiesImpl(properties, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesImpl(Properties properties, String string) {
        String string2 = System.getProperty("java.home");
        try {
            if (string2 == null) {
                throw new Error("Can't find java.home ??");
            }
            File file = new File(string2, "lib");
            file = new File(file, string);
            string2 = file.getCanonicalPath();
            FileInputStream fileInputStream = new FileInputStream(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                properties.load(bufferedInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return JSSecurityManager.getTopmostThreadGroupImpl();
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                };
                threadGroup = (ThreadGroup)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                threadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
            }
        } else {
            threadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
        }
        return threadGroup;
    }

    private static ThreadGroup getTopmostThreadGroupImpl() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    static MixerThread newMixerThread(final String string) {
        MixerThread mixerThread = null;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction privilegedAction = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return JSSecurityManager.newMixerThreadImpl(string);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                };
                mixerThread = (MixerThread)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                mixerThread = JSSecurityManager.newMixerThreadImpl(string);
            }
        } else {
            mixerThread = JSSecurityManager.newMixerThreadImpl(string);
        }
        return mixerThread;
    }

    private static MixerThread newMixerThreadImpl(String string) {
        ThreadGroup threadGroup = JSSecurityManager.getTopmostThreadGroup();
        MixerThread mixerThread = new MixerThread(threadGroup);
        mixerThread.setDaemon(true);
        mixerThread.setPriority(10);
        mixerThread.setName(string);
        return mixerThread;
    }

    static Thread createThread(final Runnable runnable, final String string, final boolean bl, final int n, final boolean bl2) {
        Thread thread = null;
        if (JSSecurityManager.hasSecurityManager()) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    try {
                        return JSSecurityManager.createThreadImpl(runnable, string, bl, n, bl2);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            };
            thread = (Thread)AccessController.doPrivileged(privilegedAction);
        } else {
            thread = JSSecurityManager.createThreadImpl(runnable, string, bl, n, bl2);
        }
        return thread;
    }

    private static Thread createThreadImpl(Runnable runnable, String string, boolean bl, int n, boolean bl2) {
        ThreadGroup threadGroup = JSSecurityManager.getTopmostThreadGroupImpl();
        Thread thread = new Thread(threadGroup, runnable);
        if (string != null) {
            thread.setName(string);
        }
        thread.setDaemon(bl);
        if (n >= 0) {
            thread.setPriority(n);
        }
        if (bl2) {
            thread.start();
        }
        return thread;
    }

    static List getProviders(final Class clazz) {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = Service.providers(clazz);
                while (iterator.hasNext()) {
                    try {
                        Object e = iterator.next();
                        if (!clazz.isInstance(e)) continue;
                        arrayList.add(0, e);
                    }
                    catch (Throwable throwable) {}
                }
                return arrayList;
            }
        };
        List list = (List)AccessController.doPrivileged(privilegedAction);
        return list;
    }
}

