.TH XScreenSaver 1 "30-Oct-99" "X Version 11"
.SH NAME
pinion - draws a scrolling sequence of interconnected gears
.SH SYNOPSIS
.B pinion
[\-display \fIhost:display.screen\fP] [\-window] [\-root] [\-install]
[\-visual \fIvisual\fP] 
[\-delay \fIusecs\fP] 
[\-scroll \fIratio\fP]
[\-spin \fIratio\fP]
[\-size \fIratio\fP]
[\-max-rpm \fIint\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
The \fIpinion\fP program draws an interconnected set of gears moving
across the screen.
.SH OPTIONS
.I pinion
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fIusecs\fP
The delay between frames of the animation, in microseconds: default 15000.
.TP 8
.B \-spin \fIratio\fP
How fast the gears should spin; default 1.0.  2.0 means twice as fast,
0.5 means half as fast.
.TP 8
.B \-scroll \fIratio\fP
How fast the gears should scroll past the screen; default 1.0.  
2.0 means twice as fast, 0.5 means half as fast.
.TP 8
.B \-size \fIratio\fP
How big the gears should be, on average; default 1.0. 
2.0 means twice as large, 0.5 means half as large.
.TP 8
.B \-max\-rpm \fIinteger\fP
If any gear exceeds the maximum RPM, the current gear train is broken there,
and we start a new train.  Default: 900 RPM.  (At 30 FPS, that's about half
a rotation per frame.)
.TP 8
.B \-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display a running tally of how many frames per second are being rendered.
In conjunction with \fB\-delay 0\fP, this can be a useful benchmark of 
your GL performance.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR gears (1),
.BR xscreensaver (1),
.BR X (1)
.SH COPYRIGHT
Copyright \(co 2004 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 12-Dec-2004.
