#!/usr/local/bin/perl

###
#
# pack.pl:  A script to pack up databases generated by gen_upgrade (in
#   upgrade.tcl) and package them into a tgz format suitable
#   for archiving and for the upgrade test.
#
# Before use, you must set the following parameters:

use Getopt::Long;

&GetOptions("version=s" => \$version, "be", "le", "dir=s" => \$build_dir);

if (not defined $version) {
	$version = "3.1";
}
if (not defined $build_dir) {
	$build_dir = "/work/db/db_upgrade/db/work";
}

my $db_dump_path = "$build_dir/db_dump";

#
# If, for instance, --version is 3.0, the script will take the databases in
# ./3.0le and ./3.0be and pack them up into a directory hierarchy in
# ./3.0.
#
# Note that this requires ./3.0le, ./3.0be, ./3.0, and
# $build_dir to all be on the same filesystem;  it makes use of the link()
# system call to put together the collection of files it generates.
#
# The --be and --le options make the "primary" endianness be and le,
# respectively.  The default is le.

my $local_en = "le";
my $other_en = "be";

if (defined $opt_be) {
	print "Big-endian architecture.\n");
	$local_en = "be";
	$other_en = "le";
}


use strict;

my $subdir;
my $file;
my $archive_name;

my $pwd = `pwd`;
chomp( $pwd );
my $packtmp = $pwd . "/$version/packtmp";

$| = 1;

opendir( DIR, $version . $local_en ) || die;
while( $subdir = readdir( DIR ) )
{
	if( $subdir !~ m{^\.\.?$} )
	{
		opendir( SUBDIR, $version . "$local_en/$subdir" ) || die;
		while( $file = readdir( SUBDIR ) )
		{
			if( $file !~ m{^\.\.?$} )
			{
				print "[" . localtime() . "] " . "$subdir $file", "\n";

				eval
				{
					system( "mkdir", "-p", "$version/$subdir" );
                                        system( "mkdir", "-p", $packtmp );
					$file =~ m{(.*)\.};
					$archive_name = "$1";
					$archive_name =~ s{Test}{test};
                                        link( $version . 
					    "$local_en/$subdir/$file",
                                            $packtmp . 
					    "/$archive_name-$local_en.db") 
					    or die;
                                        link( $version . 
					    "$other_en/$subdir/$file",
                                            $packtmp . 
					    "/$archive_name-$other_en.db") 
					    or die;
                                        link( db_dump( "$pwd/$version" . 
				            "$local_en/$subdir/$file" ),
                                            $packtmp . 
					    "/$archive_name.dump") or die;
                                        link( tcl_dump( "$pwd/$version" . 
					    "$local_en/$subdir/$file" ),
                                            $packtmp . 
					    "/$archive_name.tcldump") or die;

                                        chdir $packtmp or die;
                                        system( "tar", "-zcf",
                                "$pwd/$version/$subdir/$archive_name.tar.gz",
                                            "." );
                                        chdir $pwd or die;
                                        system( "rm", "-rf", $packtmp );
				};
				if( $@ )
				{
					print( "Could not process $file: $@\n" );
				}
			}
		}
	}
}

sub db_dump
{
	my ($file) = @_;

	#print $file, "\n";
	unlink( "temp.dump" );
	#print "$db_dump_path\n";
	system( "sh", "-c", "$db_dump_path -k $file >temp.dump" ) && die;
	if( -e "temp.dump" )
	{
		return "temp.dump";
	}
	else
	{
		die "db_dump failure: $file\n";
	}
}

sub tcl_dump
{
	my ($file) = @_;

	#print $file, "\n";
	unlink( "temp.dump" );
	open( TCL, "|tclsh" );
print TCL <<END;
cd $build_dir
source ../test/test.tcl
upgrade_dump $file $pwd/temp.dump
END
	close( TCL );
	if( -e "temp.dump" )
	{
		return "temp.dump";
	}
	else
	{
		die "TCL dump failure: $file\n";
	}
}
